/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.file;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.request.validation.RequestFeatureValidator;
import org.apache.hadoop.ozone.om.request.validation.RequestProcessingPhase;
import org.apache.hadoop.ozone.om.request.validation.ValidationCondition;
import org.apache.hadoop.ozone.om.request.validation.ValidationContext;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.file.OMDirectoryCreateResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeature;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.upgrade.LayoutFeature;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMDirectoryCreateRequest
extends OMKeyRequest {
    private static final Logger LOG;
    private static final long MAX_NUM_OF_RECURSIVE_DIRS = 255L;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMDirectoryCreateRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMDirectoryCreateRequest.class);
    }

    public OMDirectoryCreateRequest(OzoneManagerProtocolProtos.OMRequest omRequest, BucketLayout bucketLayout) {
        super(omRequest, bucketLayout);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OzoneManagerProtocolProtos.CreateDirectoryRequest createDirectoryRequest = this.getOmRequest().getCreateDirectoryRequest();
        Preconditions.checkNotNull((Object)createDirectoryRequest);
        OmUtils.verifyKeyNameWithSnapshotReservedWord((String)createDirectoryRequest.getKeyArgs().getKeyName());
        OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs = createDirectoryRequest.getKeyArgs().toBuilder().setModificationTime(Time.now());
        OzoneManagerProtocolProtos.CreateDirectoryRequest.Builder newCreateDirectoryRequest = createDirectoryRequest.toBuilder().setKeyArgs(newKeyArgs);
        return this.getOmRequest().toBuilder().setCreateDirectoryRequest(newCreateDirectoryRequest).setUserInfo(this.getUserInfo()).build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex) {
        int numMissingParents;
        Result result;
        OMClientResponse omClientResponse;
        Exception exception;
        Map<String, String> auditMap;
        OzoneManagerProtocolProtos.UserInfo userInfo;
        AuditLogger auditLogger;
        OMMetrics omMetrics;
        OzoneManagerProtocolProtos.KeyArgs keyArgs;
        OzoneManagerProtocolProtos.CreateDirectoryRequest createDirectoryRequest;
        block15: {
            createDirectoryRequest = this.getOmRequest().getCreateDirectoryRequest();
            keyArgs = createDirectoryRequest.getKeyArgs();
            String volumeName = keyArgs.getVolumeName();
            String bucketName = keyArgs.getBucketName();
            String keyName = keyArgs.getKeyName();
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            omResponse.setCreateDirectoryResponse(OzoneManagerProtocolProtos.CreateDirectoryResponse.newBuilder());
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumCreateDirectory();
            auditLogger = ozoneManager.getAuditLogger();
            userInfo = this.getOmRequest().getUserInfo();
            auditMap = this.buildKeyArgsAuditMap(keyArgs);
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            boolean acquiredLock = false;
            exception = null;
            omClientResponse = null;
            result = Result.FAILURE;
            numMissingParents = 0;
            try {
                try {
                    keyArgs = this.resolveBucketLink(ozoneManager, keyArgs, auditMap);
                    volumeName = keyArgs.getVolumeName();
                    bucketName = keyArgs.getBucketName();
                    this.checkKeyAcls(ozoneManager, volumeName, bucketName, keyName, IAccessAuthorizer.ACLType.CREATE, OzoneObj.ResourceType.KEY);
                    if (keyName.length() == 0) {
                        throw new OMException("Directory create failed. Cannot create directory at root of the filesystem", OMException.ResultCodes.CANNOT_CREATE_DIRECTORY_AT_ROOT);
                    }
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    acquiredLock = this.getOmLockDetails().isLockAcquired();
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    Path keyPath = Paths.get(keyName, new String[0]);
                    OMFileRequest.OMPathInfo omPathInfo = OMFileRequest.verifyFilesInPath(omMetadataManager, volumeName, bucketName, keyName, keyPath);
                    OMFileRequest.OMDirectoryResult omDirectoryResult = omPathInfo.getDirectoryResult();
                    OmKeyInfo dirKeyInfo = null;
                    if (omDirectoryResult == OMFileRequest.OMDirectoryResult.FILE_EXISTS || omDirectoryResult == OMFileRequest.OMDirectoryResult.FILE_EXISTS_IN_GIVENPATH) {
                        throw new OMException("Unable to create directory: " + keyName + " in volume/bucket: " + volumeName + "/" + bucketName, OMException.ResultCodes.FILE_ALREADY_EXISTS);
                    }
                    if (omDirectoryResult == OMFileRequest.OMDirectoryResult.DIRECTORY_EXISTS_IN_GIVENPATH || omDirectoryResult == OMFileRequest.OMDirectoryResult.NONE) {
                        List<String> missingParents = omPathInfo.getMissingParents();
                        long baseObjId = ozoneManager.getObjectIdFromTxId(trxnLogIndex);
                        OmBucketInfo omBucketInfo = this.getBucketInfo(omMetadataManager, volumeName, bucketName);
                        dirKeyInfo = OMDirectoryCreateRequest.createDirectoryKeyInfoWithACL(keyName, keyArgs, baseObjId, omBucketInfo, omPathInfo, trxnLogIndex, ozoneManager.getDefaultReplicationConfig());
                        List<OmKeyInfo> missingParentInfos = OMDirectoryCreateRequest.getAllParentInfo(ozoneManager, keyArgs, missingParents, omBucketInfo, omPathInfo, trxnLogIndex);
                        numMissingParents = missingParentInfos.size();
                        this.checkBucketQuotaInNamespace(omBucketInfo, (long)numMissingParents + 1L);
                        omBucketInfo.incrUsedNamespace((long)numMissingParents + 1L);
                        OMFileRequest.addKeyTableCacheEntries(omMetadataManager, volumeName, bucketName, omBucketInfo.getBucketLayout(), dirKeyInfo, missingParentInfos, trxnLogIndex);
                        result = Result.SUCCESS;
                        omClientResponse = new OMDirectoryCreateResponse(omResponse.build(), dirKeyInfo, missingParentInfos, result, this.getBucketLayout(), omBucketInfo.copyObject());
                    } else {
                        result = Result.DIRECTORY_ALREADY_EXISTS;
                        omResponse.setStatus(OzoneManagerProtocolProtos.Status.DIRECTORY_ALREADY_EXISTS);
                        omClientResponse = new OMDirectoryCreateResponse(omResponse.build(), result);
                    }
                }
                catch (IOException | InvalidPathException ex) {
                    exception = ex;
                    omClientResponse = new OMDirectoryCreateResponse(this.createErrorOMResponse(omResponse, exception), result);
                    if (acquiredLock) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (acquiredLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (acquiredLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        this.auditLog(auditLogger, this.buildAuditMessage(OMAction.CREATE_DIRECTORY, auditMap, exception, userInfo));
        this.logResult(createDirectoryRequest, keyArgs, omMetrics, result, exception, numMissingParents);
        return omClientResponse;
    }

    public static List<OmKeyInfo> getAllParentInfo(OzoneManager ozoneManager, OzoneManagerProtocolProtos.KeyArgs keyArgs, List<String> missingParents, OmBucketInfo bucketInfo, OMFileRequest.OMPathInfo omPathInfo, long trxnLogIndex) throws IOException {
        OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
        ArrayList<OmKeyInfo> missingParentInfos = new ArrayList<OmKeyInfo>();
        long baseObjId = ozoneManager.getObjectIdFromTxId(trxnLogIndex);
        long maxObjId = baseObjId + 255L;
        long objectCount = 1L;
        String volumeName = keyArgs.getVolumeName();
        String bucketName = keyArgs.getBucketName();
        String keyName = keyArgs.getKeyName();
        for (String missingKey : missingParents) {
            long nextObjId = baseObjId + objectCount;
            if (nextObjId > maxObjId) {
                throw new OMException("Too many directories in path. Exceeds limit of 255. Unable to create directory: " + keyName + " in volume/bucket: " + volumeName + "/" + bucketName, OMException.ResultCodes.INVALID_KEY_NAME);
            }
            LOG.debug("missing parent {} getting added to KeyTable", (Object)missingKey);
            OmKeyInfo parentKeyInfo = OMDirectoryCreateRequest.createDirectoryKeyInfoWithACL(missingKey, keyArgs, nextObjId, bucketInfo, omPathInfo, trxnLogIndex, ozoneManager.getDefaultReplicationConfig());
            ++objectCount;
            missingParentInfos.add(parentKeyInfo);
            omMetadataManager.getKeyTable(BucketLayout.DEFAULT).addCacheEntry((Object)omMetadataManager.getOzoneKey(volumeName, bucketName, parentKeyInfo.getKeyName()), (Object)parentKeyInfo, trxnLogIndex);
        }
        return missingParentInfos;
    }

    private void logResult(OzoneManagerProtocolProtos.CreateDirectoryRequest createDirectoryRequest, OzoneManagerProtocolProtos.KeyArgs keyArgs, OMMetrics omMetrics, Result result, Exception exception, int numMissingParents) {
        String volumeName = keyArgs.getVolumeName();
        String bucketName = keyArgs.getBucketName();
        String keyName = keyArgs.getKeyName();
        switch (result) {
            case SUCCESS: {
                omMetrics.incNumKeys(numMissingParents + 1);
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Directory created. Volume:{}, Bucket:{}, Key:{}", new Object[]{volumeName, bucketName, keyName});
                break;
            }
            case DIRECTORY_ALREADY_EXISTS: {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Directory already exists. Volume:{}, Bucket:{}, Key{}", new Object[]{volumeName, bucketName, keyName, exception});
                break;
            }
            case FAILURE: {
                omMetrics.incNumCreateDirectoryFails();
                LOG.error("Directory creation failed. Volume:{}, Bucket:{}, Key{}. Exception:{}", new Object[]{volumeName, bucketName, keyName, exception});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for OMDirectoryCreateRequest: {}", (Object)createDirectoryRequest);
            }
        }
    }

    public static OmKeyInfo createDirectoryKeyInfoWithACL(String keyName, OzoneManagerProtocolProtos.KeyArgs keyArgs, long objectId, OmBucketInfo bucketInfo, OMFileRequest.OMPathInfo omPathInfo, long transactionIndex, ReplicationConfig serverDefaultReplConfig) {
        return OMDirectoryCreateRequest.dirKeyInfoBuilderNoACL(keyName, keyArgs, objectId, serverDefaultReplConfig).setAcls(OMDirectoryCreateRequest.getAclsForDir(keyArgs, bucketInfo, omPathInfo)).setUpdateID(transactionIndex).build();
    }

    private static OmKeyInfo.Builder dirKeyInfoBuilderNoACL(String keyName, OzoneManagerProtocolProtos.KeyArgs keyArgs, long objectId, ReplicationConfig serverDefaultReplConfig) {
        String dirName = OzoneFSUtils.addTrailingSlashIfNeeded((String)keyName);
        OmKeyInfo.Builder keyInfoBuilder = new OmKeyInfo.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(dirName).setOmKeyLocationInfos(Collections.singletonList(new OmKeyLocationInfoGroup(0L, new ArrayList()))).setCreationTime(keyArgs.getModificationTime()).setModificationTime(keyArgs.getModificationTime()).setDataSize(0L);
        if (keyArgs.getFactor() != null && keyArgs.getFactor() != HddsProtos.ReplicationFactor.ZERO && keyArgs.getType() != HddsProtos.ReplicationType.EC) {
            keyInfoBuilder.setReplicationConfig(ReplicationConfig.fromProtoTypeAndFactor((HddsProtos.ReplicationType)keyArgs.getType(), (HddsProtos.ReplicationFactor)keyArgs.getFactor()));
        } else if (keyArgs.getType() == HddsProtos.ReplicationType.EC) {
            keyInfoBuilder.setReplicationConfig((ReplicationConfig)new ECReplicationConfig(keyArgs.getEcReplicationConfig()));
        } else {
            keyInfoBuilder.setReplicationConfig(serverDefaultReplConfig);
        }
        keyInfoBuilder.setObjectID(objectId);
        return keyInfoBuilder;
    }

    static long getMaxNumOfRecursiveDirs() {
        return 255L;
    }

    @RequestFeatureValidator(conditions={ValidationCondition.CLUSTER_NEEDS_FINALIZATION}, processingPhase=RequestProcessingPhase.PRE_PROCESS, requestType=OzoneManagerProtocolProtos.Type.CreateDirectory)
    public static OzoneManagerProtocolProtos.OMRequest disallowCreateDirectoryWithECReplicationConfig(OzoneManagerProtocolProtos.OMRequest req, ValidationContext ctx) throws OMException {
        if (!ctx.versionManager().isAllowed((LayoutFeature)OMLayoutFeature.ERASURE_CODED_STORAGE_SUPPORT) && req.getCreateDirectoryRequest().getKeyArgs().hasEcReplicationConfig()) {
            throw new OMException("Cluster does not have the Erasure Coded Storage support feature finalized yet, but the request contains an Erasure Coded replication type. Rejecting the request, please finalize the cluster upgrade and then try again.", OMException.ResultCodes.NOT_SUPPORTED_OPERATION_PRIOR_FINALIZATION);
        }
        return req;
    }

    @RequestFeatureValidator(conditions={ValidationCondition.OLDER_CLIENT_REQUESTS}, processingPhase=RequestProcessingPhase.PRE_PROCESS, requestType=OzoneManagerProtocolProtos.Type.CreateDirectory)
    public static OzoneManagerProtocolProtos.OMRequest blockCreateDirectoryWithBucketLayoutFromOldClient(OzoneManagerProtocolProtos.OMRequest req, ValidationContext ctx) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs;
        if (req.getCreateDirectoryRequest().hasKeyArgs() && (keyArgs = req.getCreateDirectoryRequest().getKeyArgs()).hasVolumeName() && keyArgs.hasBucketName()) {
            BucketLayout bucketLayout = ctx.getBucketLayout(keyArgs.getVolumeName(), keyArgs.getBucketName());
            bucketLayout.validateSupportedOperation();
        }
        return req;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMDirectoryCreateRequest.java", OMDirectoryCreateRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.file.OMDirectoryCreateRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 115);
    }

    public static enum Result {
        SUCCESS,
        DIRECTORY_ALREADY_EXISTS,
        FAILURE;

    }
}

