/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.KeyValueUtil;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.WithMetadata;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyCommitRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeyCommitResponseWithFSO;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeyCommitRequestWithFSO
extends OMKeyCommitRequest {
    @VisibleForTesting
    public static final Logger LOG = LoggerFactory.getLogger(OMKeyCommitRequestWithFSO.class);

    public OMKeyCommitRequestWithFSO(OzoneManagerProtocolProtos.OMRequest omRequest, BucketLayout bucketLayout) {
        super(omRequest, bucketLayout);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex) {
        OMClientRequest.Result result;
        boolean isHSync;
        OMClientResponse omClientResponse;
        OmKeyInfo omKeyInfo;
        Exception exception;
        Map<String, String> auditMap;
        AuditLogger auditLogger;
        OMMetrics omMetrics;
        String keyName;
        String bucketName;
        String volumeName;
        OzoneManagerProtocolProtos.CommitKeyRequest commitKeyRequest;
        block27: {
            commitKeyRequest = this.getOmRequest().getCommitKeyRequest();
            OzoneManagerProtocolProtos.KeyArgs commitKeyArgs = commitKeyRequest.getKeyArgs();
            volumeName = commitKeyArgs.getVolumeName();
            bucketName = commitKeyArgs.getBucketName();
            keyName = commitKeyArgs.getKeyName();
            omMetrics = ozoneManager.getMetrics();
            auditLogger = ozoneManager.getAuditLogger();
            auditMap = this.buildKeyArgsAuditMap(commitKeyArgs);
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            exception = null;
            omKeyInfo = null;
            OmBucketInfo omBucketInfo = null;
            omClientResponse = null;
            boolean bucketLockAcquired = false;
            boolean bl = isHSync = commitKeyRequest.hasHsync() && commitKeyRequest.getHsync();
            if (isHSync) {
                omMetrics.incNumKeyHSyncs();
            } else {
                omMetrics.incNumKeyCommits();
            }
            LOG.debug("isHSync = {}, volumeName = {}, bucketName = {}, keyName = {}", new Object[]{isHSync, volumeName, bucketName, keyName});
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            try {
                try {
                    OmKeyInfo pseudoKeyInfo;
                    String delKeyName;
                    commitKeyArgs = this.resolveBucketLink(ozoneManager, commitKeyArgs, auditMap);
                    volumeName = commitKeyArgs.getVolumeName();
                    bucketName = commitKeyArgs.getBucketName();
                    this.checkKeyAclsInOpenKeyTable(ozoneManager, volumeName, bucketName, keyName, IAccessAuthorizer.ACLType.WRITE, commitKeyRequest.getClientID());
                    Iterator<Path> pathComponents = Paths.get(keyName, new String[0]).iterator();
                    String dbOpenFileKey = null;
                    List<OmKeyLocationInfo> locationInfoList = this.getOmKeyLocationInfos(ozoneManager, commitKeyArgs);
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    bucketLockAcquired = this.getOmLockDetails().isLockAcquired();
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    String fileName = OzoneFSUtils.getFileName((String)keyName);
                    omBucketInfo = this.getBucketInfo(omMetadataManager, volumeName, bucketName);
                    long volumeId = omMetadataManager.getVolumeId(volumeName);
                    long bucketId = omMetadataManager.getBucketId(volumeName, bucketName);
                    long parentID = OMFileRequest.getParentID(volumeId, bucketId, pathComponents, keyName, omMetadataManager, "Cannot create file : " + keyName + " as parent directory doesn't exist");
                    String dbFileKey = omMetadataManager.getOzonePathKey(volumeId, bucketId, parentID, fileName);
                    dbOpenFileKey = omMetadataManager.getOpenFileName(volumeId, bucketId, parentID, fileName, commitKeyRequest.getClientID());
                    omKeyInfo = OMFileRequest.getOmKeyInfoFromFileTable(true, omMetadataManager, dbOpenFileKey, keyName);
                    if (omKeyInfo == null) {
                        String action = "commit";
                        if (isHSync) {
                            action = "hsync";
                        }
                        throw new OMException("Failed to " + action + " key, as " + dbOpenFileKey + "entry is not found in the OpenKey table", OMException.ResultCodes.KEY_NOT_FOUND);
                    }
                    omKeyInfo.getMetadata().putAll(KeyValueUtil.getFromProtobuf((List)commitKeyArgs.getMetadataList()));
                    if (isHSync) {
                        omKeyInfo.getMetadata().put("hsyncClientId", String.valueOf(commitKeyRequest.getClientID()));
                    }
                    omKeyInfo.setDataSize(commitKeyArgs.getDataSize());
                    omKeyInfo.setModificationTime(commitKeyArgs.getModificationTime());
                    List uncommitted = omKeyInfo.updateLocationInfoList(locationInfoList, false);
                    omKeyInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
                    boolean isPreviousCommitHsync = false;
                    HashMap<String, RepeatedOmKeyInfo> oldKeyVersionsToDeleteMap = null;
                    OmKeyInfo keyToDelete = (OmKeyInfo)omMetadataManager.getKeyTable(this.getBucketLayout()).get((Object)dbFileKey);
                    if (keyToDelete != null) {
                        String clientIdString = String.valueOf(commitKeyRequest.getClientID());
                        isPreviousCommitHsync = Optional.ofNullable(keyToDelete).map(WithMetadata::getMetadata).map(meta -> (String)meta.get("hsyncClientId")).filter(id -> id.equals(clientIdString)).isPresent();
                    }
                    long correctedSpace = omKeyInfo.getReplicatedSize();
                    if (keyToDelete != null && (isHSync || isPreviousCommitHsync)) {
                        this.checkBucketQuotaInBytes(omMetadataManager, omBucketInfo, correctedSpace -= keyToDelete.getReplicatedSize());
                    } else if (keyToDelete != null && !omBucketInfo.getIsVersionEnabled()) {
                        RepeatedOmKeyInfo oldVerKeyInfo = this.getOldVersionsToCleanUp(keyToDelete, trxnLogIndex, ozoneManager.isRatisEnabled());
                        this.checkBucketQuotaInBytes(omMetadataManager, omBucketInfo, correctedSpace -= keyToDelete.getReplicatedSize());
                        delKeyName = omMetadataManager.getOzoneKey(volumeName, bucketName, fileName);
                        delKeyName = omMetadataManager.getOzoneDeletePathKey(keyToDelete.getObjectID(), delKeyName);
                        if (oldKeyVersionsToDeleteMap == null) {
                            oldKeyVersionsToDeleteMap = new HashMap<String, RepeatedOmKeyInfo>();
                        }
                        this.filterOutBlocksStillInUse(omKeyInfo, oldVerKeyInfo);
                        if (!oldVerKeyInfo.getOmKeyInfoList().isEmpty()) {
                            oldKeyVersionsToDeleteMap.put(delKeyName, oldVerKeyInfo);
                        }
                    } else {
                        this.checkBucketQuotaInNamespace(omBucketInfo, 1L);
                        this.checkBucketQuotaInBytes(omMetadataManager, omBucketInfo, correctedSpace);
                        omBucketInfo.incrUsedNamespace(1L);
                    }
                    OmKeyInfo omKeyInfo2 = pseudoKeyInfo = isHSync ? null : this.wrapUncommittedBlocksAsPseudoKey(uncommitted, omKeyInfo);
                    if (pseudoKeyInfo != null) {
                        delKeyName = omMetadataManager.getOzoneKey(volumeName, bucketName, fileName);
                        long pseudoObjId = ozoneManager.getObjectIdFromTxId(trxnLogIndex);
                        delKeyName = omMetadataManager.getOzoneDeletePathKey(pseudoObjId, delKeyName);
                        if (oldKeyVersionsToDeleteMap == null) {
                            oldKeyVersionsToDeleteMap = new HashMap();
                        }
                        oldKeyVersionsToDeleteMap.put(delKeyName, new RepeatedOmKeyInfo(pseudoKeyInfo));
                    }
                    if (!isHSync) {
                        OMFileRequest.addOpenFileTableCacheEntry(omMetadataManager, dbOpenFileKey, null, fileName, trxnLogIndex);
                    }
                    OMFileRequest.addFileTableCacheEntry(omMetadataManager, dbFileKey, omKeyInfo, fileName, trxnLogIndex);
                    omBucketInfo.incrUsedBytes(correctedSpace);
                    omClientResponse = new OMKeyCommitResponseWithFSO(omResponse.build(), omKeyInfo, dbFileKey, dbOpenFileKey, omBucketInfo.copyObject(), oldKeyVersionsToDeleteMap, volumeId, isHSync);
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException | InvalidPathException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omClientResponse = new OMKeyCommitResponseWithFSO(this.createErrorOMResponse(omResponse, exception), this.getBucketLayout());
                    if (bucketLockAcquired) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block27;
                }
            }
            catch (Throwable throwable) {
                if (bucketLockAcquired) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (bucketLockAcquired) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        LOG.debug("Key commit {} with isHSync = {}, omKeyInfo = {}", new Object[]{result == OMClientRequest.Result.SUCCESS ? "succeeded" : "failed", isHSync, omKeyInfo});
        if (!isHSync) {
            this.auditLog(auditLogger, this.buildAuditMessage(OMAction.COMMIT_KEY, auditMap, exception, this.getOmRequest().getUserInfo()));
            this.processResult(commitKeyRequest, volumeName, bucketName, keyName, omMetrics, exception, omKeyInfo, result);
        }
        return omClientResponse;
    }
}

