/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.request.validation.RequestFeatureValidator;
import org.apache.hadoop.ozone.om.request.validation.RequestProcessingPhase;
import org.apache.hadoop.ozone.om.request.validation.ValidationCondition;
import org.apache.hadoop.ozone.om.request.validation.ValidationContext;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeysDeleteResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeysDeleteRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMKeysDeleteRequest.class);
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$apache$hadoop$ozone$om$request$OMClientRequest$Result;

    public OMKeysDeleteRequest(OzoneManagerProtocolProtos.OMRequest omRequest, BucketLayout bucketLayout) {
        super(omRequest, bucketLayout);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex) {
        block21: {
            block19: {
                block20: {
                    deleteKeyRequest = this.getOmRequest().getDeleteKeysRequest();
                    deleteKeyArgs = deleteKeyRequest.getDeleteKeys();
                    deleteKeys = new ArrayList<String>(deleteKeyArgs.getKeysList());
                    exception = null;
                    omClientResponse = null;
                    result = null;
                    omMetrics = ozoneManager.getMetrics();
                    omMetrics.incNumKeyDeletes();
                    volumeName = deleteKeyArgs.getVolumeName();
                    bucketName = deleteKeyArgs.getBucketName();
                    auditMap = new LinkedHashMap<String, String>();
                    auditMap.put("volume", volumeName);
                    auditMap.put("bucket", bucketName);
                    omKeyInfoList = new ArrayList<OmKeyInfo>();
                    dirList = new ArrayList<OmKeyInfo>();
                    auditLogger = ozoneManager.getAuditLogger();
                    userInfo = this.getOmRequest().getUserInfo();
                    omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
                    omMetadataManager = ozoneManager.getMetadataManager();
                    acquiredLock = false;
                    indexFailed = 0;
                    length = deleteKeys.size();
                    unDeletedKeys = OzoneManagerProtocolProtos.DeleteKeyArgs.newBuilder().setVolumeName(volumeName).setBucketName(bucketName);
                    deleteStatus = true;
                    try {
                        try {
                            bucket = ozoneManager.resolveBucketLink((Pair<String, String>)Pair.of((Object)volumeName, (Object)bucketName), (OMClientRequest)this);
                            bucket.audit(auditMap);
                            volumeName = bucket.realVolume();
                            bucketName = bucket.realBucket();
                            this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                            acquiredLock = this.getOmLockDetails().isLockAcquired();
                            this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                            volumeOwner = this.getVolumeOwner(omMetadataManager, volumeName);
                            indexFailed = 0;
                            while (indexFailed < length) {
                                keyName = deleteKeyArgs.getKeys(indexFailed);
                                objectKey = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
                                omKeyInfo = this.getOmKeyInfo(ozoneManager, omMetadataManager, volumeName, bucketName, keyName);
                                if (omKeyInfo == null) {
                                    deleteStatus = false;
                                    OMKeysDeleteRequest.LOG.error("Received a request to delete a Key does not exist {}", (Object)objectKey);
                                    deleteKeys.remove(keyName);
                                    unDeletedKeys.addKeys(keyName);
                                } else {
                                    try {
                                        this.checkKeyAcls(ozoneManager, volumeName, bucketName, keyName, IAccessAuthorizer.ACLType.DELETE, OzoneObj.ResourceType.KEY, volumeOwner);
                                        fileStatus = this.getOzoneKeyStatus(ozoneManager, omMetadataManager, volumeName, bucketName, keyName);
                                        this.addKeyToAppropriateList(omKeyInfoList, omKeyInfo, dirList, fileStatus);
                                    }
                                    catch (Exception ex) {
                                        deleteStatus = false;
                                        OMKeysDeleteRequest.LOG.error("Acl check failed for Key: {}", (Object)objectKey, (Object)ex);
                                        deleteKeys.remove(keyName);
                                        unDeletedKeys.addKeys(keyName);
                                    }
                                }
                                ++indexFailed;
                            }
                            quotaReleased = 0L;
                            omBucketInfo = this.getBucketInfo(omMetadataManager, volumeName, bucketName);
                            quotaReleased = this.markKeysAsDeletedInCache(ozoneManager, trxnLogIndex, omKeyInfoList, dirList, omMetadataManager, quotaReleased);
                            omBucketInfo.incrUsedBytes(-quotaReleased);
                            omBucketInfo.incrUsedNamespace(-1L * (long)omKeyInfoList.size());
                            volumeId = omMetadataManager.getVolumeId(volumeName);
                            omClientResponse = this.getOmClientResponse(ozoneManager, omKeyInfoList, dirList, omResponse, unDeletedKeys, deleteStatus, omBucketInfo, volumeId);
                            result = OMClientRequest.Result.SUCCESS;
                            break block19;
                        }
                        catch (IOException | InvalidPathException ex) {
                            result = OMClientRequest.Result.FAILURE;
                            exception = ex;
                            this.createErrorOMResponse(omResponse, exception);
                            deleteKeys = new ArrayList<E>();
                            i = indexFailed;
                            ** while (i < length)
                        }
lbl-1000:
                        // 1 sources

                        {
                            unDeletedKeys.addKeys(deleteKeyArgs.getKeys(i));
                            ++i;
                            continue;
                        }
lbl86:
                        // 1 sources

                        omResponse.setDeleteKeysResponse(OzoneManagerProtocolProtos.DeleteKeysResponse.newBuilder().setStatus(false).setUnDeletedKeys(unDeletedKeys).build()).build();
                        omClientResponse = new OMKeysDeleteResponse(omResponse.build(), this.getBucketLayout());
                        if (!acquiredLock) break block20;
                    }
                    catch (Throwable var32_35) {
                        if (acquiredLock) {
                            this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                        }
                        if (omClientResponse != null) {
                            omClientResponse.setOmLockDetails(this.getOmLockDetails());
                        }
                        throw var32_35;
                    }
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                break block21;
            }
            if (acquiredLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        OMKeysDeleteRequest.addDeletedKeys(auditMap, deleteKeys, unDeletedKeys.getKeysList());
        this.auditLog(auditLogger, this.buildAuditMessage(OMAction.DELETE_KEYS, auditMap, exception, userInfo));
        switch (OMKeysDeleteRequest.$SWITCH_TABLE$org$apache$hadoop$ozone$om$request$OMClientRequest$Result()[result.ordinal()]) {
            case 1: {
                omMetrics.decNumKeys(deleteKeys.size());
                if (!OMKeysDeleteRequest.LOG.isDebugEnabled()) break;
                OMKeysDeleteRequest.LOG.debug("Keys delete success. Volume:{}, Bucket:{}, Keys:{}", new Object[]{volumeName, bucketName, auditMap.get("deletedKeysList")});
                break;
            }
            case 2: {
                omMetrics.incNumKeyDeleteFails();
                if (!OMKeysDeleteRequest.LOG.isDebugEnabled()) break;
                OMKeysDeleteRequest.LOG.debug("Keys delete failed. Volume:{}, Bucket:{}, DeletedKeys:{}, UnDeletedKeys:{}", new Object[]{volumeName, bucketName, auditMap.get("deletedKeysList"), auditMap.get("unDeletedKeysList"), exception});
                break;
            }
            default: {
                OMKeysDeleteRequest.LOG.error("Unrecognized Result for OMKeysDeleteRequest: {}", (Object)deleteKeyRequest);
            }
        }
        return omClientResponse;
    }

    protected OzoneFileStatus getOzoneKeyStatus(OzoneManager ozoneManager, OMMetadataManager omMetadataManager, String volumeName, String bucketName, String keyName) throws IOException {
        return null;
    }

    @NotNull
    protected OMClientResponse getOmClientResponse(OzoneManager ozoneManager, List<OmKeyInfo> omKeyInfoList, List<OmKeyInfo> dirList, OzoneManagerProtocolProtos.OMResponse.Builder omResponse, OzoneManagerProtocolProtos.DeleteKeyArgs.Builder unDeletedKeys, boolean deleteStatus, OmBucketInfo omBucketInfo, long volumeId) {
        OMKeysDeleteResponse omClientResponse = new OMKeysDeleteResponse(omResponse.setDeleteKeysResponse(OzoneManagerProtocolProtos.DeleteKeysResponse.newBuilder().setStatus(deleteStatus).setUnDeletedKeys(unDeletedKeys)).setStatus(deleteStatus ? OzoneManagerProtocolProtos.Status.OK : OzoneManagerProtocolProtos.Status.PARTIAL_DELETE).setSuccess(deleteStatus).build(), omKeyInfoList, ozoneManager.isRatisEnabled(), omBucketInfo.copyObject());
        return omClientResponse;
    }

    protected long markKeysAsDeletedInCache(OzoneManager ozoneManager, long trxnLogIndex, List<OmKeyInfo> omKeyInfoList, List<OmKeyInfo> dirList, OMMetadataManager omMetadataManager, long quotaReleased) throws IOException {
        for (OmKeyInfo omKeyInfo : omKeyInfoList) {
            omMetadataManager.getKeyTable(this.getBucketLayout()).addCacheEntry(new CacheKey((Object)omMetadataManager.getOzoneKey(omKeyInfo.getVolumeName(), omKeyInfo.getBucketName(), omKeyInfo.getKeyName())), CacheValue.get((long)trxnLogIndex));
            omKeyInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
            quotaReleased += OMKeysDeleteRequest.sumBlockLengths(omKeyInfo);
        }
        return quotaReleased;
    }

    protected void addKeyToAppropriateList(List<OmKeyInfo> omKeyInfoList, OmKeyInfo omKeyInfo, List<OmKeyInfo> dirList, OzoneFileStatus keyStatus) {
        omKeyInfoList.add(omKeyInfo);
    }

    protected OmKeyInfo getOmKeyInfo(OzoneManager ozoneManager, OMMetadataManager omMetadataManager, String volume, String bucket, String key) throws IOException {
        String objectKey = omMetadataManager.getOzoneKey(volume, bucket, key);
        return (OmKeyInfo)omMetadataManager.getKeyTable(this.getBucketLayout()).get((Object)objectKey);
    }

    protected static void addDeletedKeys(Map<String, String> auditMap, List<String> deletedKeys, List<String> unDeletedKeys) {
        auditMap.put("deletedKeysList", String.join((CharSequence)",", deletedKeys));
        auditMap.put("unDeletedKeysList", String.join((CharSequence)",", unDeletedKeys));
    }

    @RequestFeatureValidator(conditions={ValidationCondition.OLDER_CLIENT_REQUESTS}, processingPhase=RequestProcessingPhase.PRE_PROCESS, requestType=OzoneManagerProtocolProtos.Type.DeleteKeys)
    public static OzoneManagerProtocolProtos.OMRequest blockDeleteKeysWithBucketLayoutFromOldClient(OzoneManagerProtocolProtos.OMRequest req, ValidationContext ctx) throws IOException {
        OzoneManagerProtocolProtos.DeleteKeyArgs keyArgs;
        if (req.getDeleteKeysRequest().hasDeleteKeys() && (keyArgs = req.getDeleteKeysRequest().getDeleteKeys()).hasVolumeName() && keyArgs.hasBucketName()) {
            BucketLayout bucketLayout = ctx.getBucketLayout(keyArgs.getVolumeName(), keyArgs.getBucketName());
            bucketLayout.validateSupportedOperation();
        }
        return req;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$apache$hadoop$ozone$om$request$OMClientRequest$Result() {
        if ($SWITCH_TABLE$org$apache$hadoop$ozone$om$request$OMClientRequest$Result != null) {
            return $SWITCH_TABLE$org$apache$hadoop$ozone$om$request$OMClientRequest$Result;
        }
        int[] nArray = new int[OMClientRequest.Result.values().length];
        try {
            nArray[OMClientRequest.Result.FAILURE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OMClientRequest.Result.SUCCESS.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$apache$hadoop$ozone$om$request$OMClientRequest$Result = nArray;
        return nArray;
    }
}

