/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMOpenKeysDeleteResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMOpenKeysDeleteRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMOpenKeysDeleteRequest.class);

    public OMOpenKeysDeleteRequest(OzoneManagerProtocolProtos.OMRequest omRequest, BucketLayout bucketLayout) {
        super(omRequest, bucketLayout);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex) {
        HashMap<String, OmKeyInfo> deletedOpenKeys;
        OMClientRequest.Result result;
        OMClientResponse omClientResponse;
        long numSubmittedOpenKeys;
        OzoneManagerProtocolProtos.DeleteOpenKeysRequest deleteOpenKeysRequest;
        OMMetrics omMetrics;
        block10: {
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumOpenKeyDeleteRequests();
            deleteOpenKeysRequest = this.getOmRequest().getDeleteOpenKeysRequest();
            List submittedOpenKeyBuckets = deleteOpenKeysRequest.getOpenKeysPerBucketList();
            numSubmittedOpenKeys = 0L;
            for (OzoneManagerProtocolProtos.OpenKeyBucket keyBucket : submittedOpenKeyBuckets) {
                numSubmittedOpenKeys += (long)keyBucket.getKeysCount();
            }
            LOG.debug("{} open keys submitted for deletion.", (Object)numSubmittedOpenKeys);
            omMetrics.incNumOpenKeysSubmittedForDeletion(numSubmittedOpenKeys);
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            Exception exception = null;
            omClientResponse = null;
            result = null;
            deletedOpenKeys = new HashMap<String, OmKeyInfo>();
            try {
                try {
                    for (OzoneManagerProtocolProtos.OpenKeyBucket openKeyBucket : submittedOpenKeyBuckets) {
                        this.updateOpenKeyTableCache(ozoneManager, trxnLogIndex, openKeyBucket, deletedOpenKeys);
                    }
                    omClientResponse = new OMOpenKeysDeleteResponse(omResponse.build(), deletedOpenKeys, ozoneManager.isRatisEnabled(), this.getBucketLayout());
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException | InvalidPathException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omClientResponse = new OMOpenKeysDeleteResponse(this.createErrorOMResponse(omResponse, exception), this.getBucketLayout());
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block10;
                }
            }
            catch (Throwable throwable) {
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        this.processResults(omMetrics, numSubmittedOpenKeys, deletedOpenKeys.size(), deleteOpenKeysRequest, result);
        return omClientResponse;
    }

    private void processResults(OMMetrics omMetrics, long numSubmittedOpenKeys, long numDeletedOpenKeys, OzoneManagerProtocolProtos.DeleteOpenKeysRequest request, OMClientRequest.Result result) {
        switch (result) {
            case SUCCESS: {
                LOG.debug("Deleted {} open keys out of {} submitted keys.", (Object)numDeletedOpenKeys, (Object)numSubmittedOpenKeys);
                break;
            }
            case FAILURE: {
                omMetrics.incNumOpenKeyDeleteRequestFails();
                LOG.error("Failure occurred while trying to delete {} submitted open keys.", (Object)numSubmittedOpenKeys);
                break;
            }
            default: {
                LOG.error("Unrecognized result for OMOpenKeysDeleteRequest: {}", (Object)request);
            }
        }
    }

    private void updateOpenKeyTableCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerProtocolProtos.OpenKeyBucket keysPerBucket, Map<String, OmKeyInfo> deletedOpenKeys) throws IOException {
        boolean acquiredLock = false;
        String volumeName = keysPerBucket.getVolumeName();
        String bucketName = keysPerBucket.getBucketName();
        OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
        try {
            this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            acquiredLock = this.getOmLockDetails().isLockAcquired();
            for (OzoneManagerProtocolProtos.OpenKey key : keysPerBucket.getKeysList()) {
                String fullKeyName = key.getName();
                OmKeyInfo omKeyInfo = (OmKeyInfo)omMetadataManager.getOpenKeyTable(this.getBucketLayout()).get((Object)fullKeyName);
                if (omKeyInfo != null) {
                    if (ozoneManager.isRatisEnabled() && trxnLogIndex < omKeyInfo.getUpdateID()) {
                        LOG.warn("Transaction log index {} is smaller than the current updateID {} of key {}, skipping deletion.", new Object[]{trxnLogIndex, omKeyInfo.getUpdateID(), fullKeyName});
                        continue;
                    }
                    omKeyInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
                    deletedOpenKeys.put(fullKeyName, omKeyInfo);
                    omMetadataManager.getOpenKeyTable(this.getBucketLayout()).addCacheEntry(new CacheKey((Object)fullKeyName), CacheValue.get((long)trxnLogIndex));
                    ozoneManager.getMetrics().incNumOpenKeysDeleted();
                    LOG.debug("Open key {} deleted.", (Object)fullKeyName);
                    continue;
                }
                LOG.debug("Key {} was not deleted, as it was not found in the open key table.", (Object)fullKeyName);
            }
        }
        catch (Throwable throwable) {
            if (acquiredLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            }
            throw throwable;
        }
        if (acquiredLock) {
            this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
        }
    }
}

