/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeysDeleteRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeysDeleteResponseWithFSO;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmKeysDeleteRequestWithFSO
extends OMKeysDeleteRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OmKeysDeleteRequestWithFSO.class);

    public OmKeysDeleteRequestWithFSO(OzoneManagerProtocolProtos.OMRequest omRequest, BucketLayout bucketLayout) {
        super(omRequest, bucketLayout);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex) {
        return super.validateAndUpdateCache(ozoneManager, trxnLogIndex);
    }

    @Override
    protected OmKeyInfo getOmKeyInfo(OzoneManager ozoneManager, OMMetadataManager omMetadataManager, String volumeName, String bucketName, String keyName) throws IOException {
        OzoneFileStatus keyStatus = this.getOzoneKeyStatus(ozoneManager, omMetadataManager, volumeName, bucketName, keyName);
        return keyStatus != null ? keyStatus.getKeyInfo() : null;
    }

    @Override
    protected void addKeyToAppropriateList(List<OmKeyInfo> omKeyInfoList, OmKeyInfo omKeyInfo, List<OmKeyInfo> dirList, OzoneFileStatus keyStatus) {
        if (keyStatus.isDirectory()) {
            dirList.add(omKeyInfo);
        } else {
            omKeyInfoList.add(omKeyInfo);
        }
    }

    @Override
    protected OzoneFileStatus getOzoneKeyStatus(OzoneManager ozoneManager, OMMetadataManager omMetadataManager, String volumeName, String bucketName, String keyName) throws IOException {
        return OMFileRequest.getOMKeyInfoIfExists(omMetadataManager, volumeName, bucketName, keyName, 0L, ozoneManager.getDefaultReplicationConfig());
    }

    @Override
    protected long markKeysAsDeletedInCache(OzoneManager ozoneManager, long trxnLogIndex, List<OmKeyInfo> omKeyInfoList, List<OmKeyInfo> dirList, OMMetadataManager omMetadataManager, long quotaReleased) throws IOException {
        long bucketId;
        long volumeId;
        for (OmKeyInfo omKeyInfo : omKeyInfoList) {
            volumeId = omMetadataManager.getVolumeId(omKeyInfo.getVolumeName());
            bucketId = omMetadataManager.getBucketId(omKeyInfo.getVolumeName(), omKeyInfo.getBucketName());
            omMetadataManager.getKeyTable(this.getBucketLayout()).addCacheEntry(new CacheKey((Object)omMetadataManager.getOzonePathKey(volumeId, bucketId, omKeyInfo.getParentObjectID(), omKeyInfo.getFileName())), CacheValue.get((long)trxnLogIndex));
            omKeyInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
            quotaReleased += OmKeysDeleteRequestWithFSO.sumBlockLengths(omKeyInfo);
        }
        for (OmKeyInfo omKeyInfo : dirList) {
            volumeId = omMetadataManager.getVolumeId(omKeyInfo.getVolumeName());
            bucketId = omMetadataManager.getBucketId(omKeyInfo.getVolumeName(), omKeyInfo.getBucketName());
            omMetadataManager.getDirectoryTable().addCacheEntry(new CacheKey((Object)omMetadataManager.getOzonePathKey(volumeId, bucketId, omKeyInfo.getParentObjectID(), omKeyInfo.getFileName())), CacheValue.get((long)trxnLogIndex));
            omKeyInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
            quotaReleased += OmKeysDeleteRequestWithFSO.sumBlockLengths(omKeyInfo);
        }
        return quotaReleased;
    }

    @Override
    @NotNull
    protected OMClientResponse getOmClientResponse(OzoneManager ozoneManager, List<OmKeyInfo> omKeyInfoList, List<OmKeyInfo> dirList, OzoneManagerProtocolProtos.OMResponse.Builder omResponse, OzoneManagerProtocolProtos.DeleteKeyArgs.Builder unDeletedKeys, boolean deleteStatus, OmBucketInfo omBucketInfo, long volumeId) {
        OMKeysDeleteResponseWithFSO omClientResponse = new OMKeysDeleteResponseWithFSO(omResponse.setDeleteKeysResponse(OzoneManagerProtocolProtos.DeleteKeysResponse.newBuilder().setStatus(deleteStatus).setUnDeletedKeys(unDeletedKeys)).setStatus(deleteStatus ? OzoneManagerProtocolProtos.Status.OK : OzoneManagerProtocolProtos.Status.PARTIAL_DELETE).setSuccess(deleteStatus).build(), omKeyInfoList, dirList, ozoneManager.isRatisEnabled(), omBucketInfo.copyObject(), volumeId);
        return omClientResponse;
    }
}

