/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key.acl;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.acl.OMKeyAclRequestWithFSO;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.acl.OMKeyAclResponse;
import org.apache.hadoop.ozone.om.response.key.acl.OMKeyAclResponseWithFSO;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObjInfo;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeySetAclRequestWithFSO
extends OMKeyAclRequestWithFSO {
    private static final Logger LOG;
    private String path;
    private List<OzoneAcl> ozoneAcls;
    private OzoneObj obj;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMKeySetAclRequestWithFSO.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMKeySetAclRequestWithFSO.class);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        long modificationTime = Time.now();
        OzoneManagerProtocolProtos.SetAclRequest.Builder setAclRequestBuilder = this.getOmRequest().getSetAclRequest().toBuilder().setModificationTime(modificationTime);
        return this.getOmRequest().toBuilder().setSetAclRequest(setAclRequestBuilder).setUserInfo(this.getUserInfo()).build();
    }

    public OMKeySetAclRequestWithFSO(OzoneManagerProtocolProtos.OMRequest omReq, BucketLayout bucketLayout) {
        super(omReq, bucketLayout);
        OzoneManagerProtocolProtos.SetAclRequest setAclRequest = this.getOmRequest().getSetAclRequest();
        this.obj = OzoneObjInfo.fromProtobuf((OzoneManagerProtocolProtos.OzoneObj)setAclRequest.getObj());
        this.path = this.obj.getPath();
        this.ozoneAcls = Lists.newArrayList((Iterable)OzoneAclUtil.fromProtobuf((List)setAclRequest.getAclList()));
    }

    @Override
    String getPath() {
        return this.path;
    }

    @Override
    OzoneObj getObject() {
        return this.obj;
    }

    @Override
    OzoneManagerProtocolProtos.OMResponse.Builder onInit() {
        return OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
    }

    @Override
    OMClientResponse onSuccess(OzoneManagerProtocolProtos.OMResponse.Builder omResponse, OmKeyInfo omKeyInfo, boolean operationResult) {
        omResponse.setSuccess(operationResult);
        omResponse.setSetAclResponse(OzoneManagerProtocolProtos.SetAclResponse.newBuilder().setResponse(operationResult));
        return new OMKeyAclResponse(omResponse.build(), omKeyInfo);
    }

    @Override
    void onComplete(OMClientRequest.Result result, boolean operationResult, Exception exception, long trxnLogIndex, AuditLogger auditLogger, Map<String, String> auditMap) {
        switch (result) {
            case SUCCESS: {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Set acl: {} to path: {} success!", this.ozoneAcls, (Object)this.path);
                break;
            }
            case FAILURE: {
                LOG.error("Set acl {} to path {} failed!", new Object[]{this.ozoneAcls, this.path, exception});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for OMKeySetAclRequest: {}", (Object)this.getOmRequest());
            }
        }
        if (this.ozoneAcls != null) {
            auditMap.put("acl", this.ozoneAcls.toString());
        }
        this.auditLog(auditLogger, this.buildAuditMessage(OMAction.SET_ACL, auditMap, exception, this.getOmRequest().getUserInfo()));
    }

    @Override
    boolean apply(OmKeyInfo omKeyInfo, long trxnLogIndex) {
        return omKeyInfo.setAcls(this.ozoneAcls);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex) {
        ozoneManager.getMetrics().incNumSetAcl();
        return super.validateAndUpdateCache(ozoneManager, trxnLogIndex);
    }

    @Override
    OMClientResponse onSuccess(OzoneManagerProtocolProtos.OMResponse.Builder omResponse, OmKeyInfo omKeyInfo, boolean operationResult, boolean isDir, long volumeId, long bucketId) {
        omResponse.setSuccess(operationResult);
        omResponse.setSetAclResponse(OzoneManagerProtocolProtos.SetAclResponse.newBuilder().setResponse(operationResult));
        return new OMKeyAclResponseWithFSO(omResponse.build(), omKeyInfo, isDir, this.getBucketLayout(), volumeId, bucketId);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMKeySetAclRequestWithFSO.java", OMKeySetAclRequestWithFSO.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.key.acl.OMKeySetAclRequestWithFSO", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 53);
    }
}

