/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.multipart;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneConfigUtil;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.file.OMDirectoryCreateRequestWithFSO;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.s3.multipart.S3InitiateMultipartUploadRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.s3.multipart.S3InitiateMultipartUploadResponseWithFSO;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;

public class S3InitiateMultipartUploadRequestWithFSO
extends S3InitiateMultipartUploadRequest {
    public S3InitiateMultipartUploadRequestWithFSO(OzoneManagerProtocolProtos.OMRequest omRequest, BucketLayout bucketLayout) {
        super(omRequest, bucketLayout);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex) {
        OMClientResponse omClientResponse;
        OMClientRequest.Result result;
        Exception exception;
        String keyName;
        String bucketName;
        String volumeName;
        Map<String, String> auditMap;
        OzoneManagerProtocolProtos.MultipartInfoInitiateRequest multipartInfoInitiateRequest;
        block12: {
            multipartInfoInitiateRequest = this.getOmRequest().getInitiateMultiPartUploadRequest();
            OzoneManagerProtocolProtos.KeyArgs keyArgs = multipartInfoInitiateRequest.getKeyArgs();
            Preconditions.checkNotNull((Object)keyArgs.getMultipartUploadID());
            auditMap = this.buildKeyArgsAuditMap(keyArgs);
            volumeName = keyArgs.getVolumeName();
            bucketName = keyArgs.getBucketName();
            String requestedVolume = volumeName;
            String requestedBucket = bucketName;
            keyName = keyArgs.getKeyName();
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            ozoneManager.getMetrics().incNumInitiateMultipartUploads();
            boolean acquiredBucketLock = false;
            exception = null;
            OmMultipartKeyInfo multipartKeyInfo = null;
            OmKeyInfo omKeyInfo = null;
            result = null;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            omClientResponse = null;
            try {
                try {
                    keyArgs = this.resolveBucketLink(ozoneManager, keyArgs, auditMap);
                    volumeName = keyArgs.getVolumeName();
                    bucketName = keyArgs.getBucketName();
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    acquiredBucketLock = this.getOmLockDetails().isLockAcquired();
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    OMFileRequest.OMPathInfoWithFSO pathInfoFSO = OMFileRequest.verifyDirectoryKeysInPath(omMetadataManager, volumeName, bucketName, keyName, Paths.get(keyName, new String[0]));
                    this.checkDirectoryResult(keyName, pathInfoFSO.getDirectoryResult());
                    OmBucketInfo bucketInfo = this.getBucketInfo(omMetadataManager, volumeName, bucketName);
                    List<OmDirectoryInfo> missingParentInfos = OMDirectoryCreateRequestWithFSO.getAllMissingParentDirInfo(ozoneManager, keyArgs, bucketInfo, pathInfoFSO, transactionLogIndex);
                    String multipartKey = omMetadataManager.getMultipartKey(volumeName, bucketName, keyName, keyArgs.getMultipartUploadID());
                    long volumeId = omMetadataManager.getVolumeId(volumeName);
                    long bucketId = omMetadataManager.getBucketId(volumeName, bucketName);
                    String multipartOpenKey = omMetadataManager.getMultipartKey(volumeId, bucketId, pathInfoFSO.getLastKnownParentId(), pathInfoFSO.getLeafNodeName(), keyArgs.getMultipartUploadID());
                    ReplicationConfig replicationConfig = OzoneConfigUtil.resolveReplicationConfigPreference(keyArgs.getType(), keyArgs.getFactor(), keyArgs.getEcReplicationConfig(), bucketInfo != null ? bucketInfo.getDefaultReplicationConfig() : null, ozoneManager);
                    multipartKeyInfo = new OmMultipartKeyInfo.Builder().setUploadID(keyArgs.getMultipartUploadID()).setCreationTime(keyArgs.getModificationTime()).setReplicationConfig(replicationConfig).setObjectID(pathInfoFSO.getLeafNodeObjectId()).setUpdateID(transactionLogIndex).setParentID(pathInfoFSO.getLastKnownParentId()).build();
                    omKeyInfo = new OmKeyInfo.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyArgs.getKeyName()).setCreationTime(keyArgs.getModificationTime()).setModificationTime(keyArgs.getModificationTime()).setReplicationConfig(replicationConfig).setOmKeyLocationInfos(Collections.singletonList(new OmKeyLocationInfoGroup(0L, new ArrayList(), true))).setAcls(this.getAclsForKey(keyArgs, bucketInfo, pathInfoFSO, ozoneManager.getPrefixManager())).setObjectID(pathInfoFSO.getLeafNodeObjectId()).setUpdateID(transactionLogIndex).setFileEncryptionInfo(keyArgs.hasFileEncryptionInfo() ? OMPBHelper.convert((OzoneManagerProtocolProtos.FileEncryptionInfoProto)keyArgs.getFileEncryptionInfo()) : null).setParentObjectID(pathInfoFSO.getLastKnownParentId()).build();
                    if (missingParentInfos != null) {
                        this.checkBucketQuotaInNamespace(bucketInfo, missingParentInfos.size());
                        bucketInfo.incrUsedNamespace((long)missingParentInfos.size());
                    }
                    OMFileRequest.addDirectoryTableCacheEntries(omMetadataManager, volumeId, bucketId, transactionLogIndex, missingParentInfos, null);
                    OMFileRequest.addOpenFileTableCacheEntry(omMetadataManager, multipartOpenKey, omKeyInfo, pathInfoFSO.getLeafNodeName(), transactionLogIndex);
                    omMetadataManager.getMultipartInfoTable().addCacheEntry((Object)multipartKey, (Object)multipartKeyInfo, transactionLogIndex);
                    omClientResponse = new S3InitiateMultipartUploadResponseWithFSO(omResponse.setInitiateMultiPartUploadResponse(OzoneManagerProtocolProtos.MultipartInfoInitiateResponse.newBuilder().setVolumeName(requestedVolume).setBucketName(requestedBucket).setKeyName(keyName).setMultipartUploadID(keyArgs.getMultipartUploadID())).build(), multipartKeyInfo, omKeyInfo, multipartKey, missingParentInfos, this.getBucketLayout(), volumeId, bucketId, bucketInfo.copyObject());
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException | InvalidPathException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omClientResponse = new S3InitiateMultipartUploadResponseWithFSO(this.createErrorOMResponse(omResponse, exception), this.getBucketLayout());
                    if (acquiredBucketLock) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (acquiredBucketLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (acquiredBucketLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        this.logResult(ozoneManager, multipartInfoInitiateRequest, auditMap, volumeName, bucketName, keyName, exception, result);
        return omClientResponse;
    }

    private void checkDirectoryResult(String keyName, OMFileRequest.OMDirectoryResult omDirectoryResult) throws OMException {
        if (omDirectoryResult == OMFileRequest.OMDirectoryResult.DIRECTORY_EXISTS) {
            throw new OMException("Can not write to directory: " + keyName, OMException.ResultCodes.NOT_A_FILE);
        }
    }
}

