/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.security;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMultiTenantManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.s3.security.S3SecretRequestHelper;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.s3.security.S3GetSecretResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.security.UserGroupInformation;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3GetSecretRequest
extends OMClientRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        S3GetSecretRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(S3GetSecretRequest.class);
    }

    public S3GetSecretRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OzoneManagerProtocolProtos.GetS3SecretRequest s3GetSecretRequest = this.getOmRequest().getGetS3SecretRequest();
        String accessId = s3GetSecretRequest.getKerberosID();
        UserGroupInformation ugi = S3SecretRequestHelper.getOrCreateUgi(accessId);
        S3SecretRequestHelper.checkAccessIdSecretOpPermission(ozoneManager, ugi, accessId);
        OzoneManagerProtocolProtos.OMRequest.Builder omRequest = OzoneManagerProtocolProtos.OMRequest.newBuilder().setUserInfo(this.getUserInfo()).setCmdType(this.getOmRequest().getCmdType()).setClientId(this.getOmRequest().getClientId());
        boolean createIfNotExist = !s3GetSecretRequest.hasCreateIfNotExist() || s3GetSecretRequest.getCreateIfNotExist();
        OzoneManagerProtocolProtos.GetS3SecretRequest newGetS3SecretRequest = OzoneManagerProtocolProtos.GetS3SecretRequest.newBuilder().setKerberosID(accessId).setCreateIfNotExist(createIfNotExist).build();
        omRequest.setGetS3SecretRequest(newGetS3SecretRequest);
        if (createIfNotExist) {
            String s3Secret = DigestUtils.sha256Hex((byte[])OmUtils.getSHADigest());
            OzoneManagerProtocolProtos.UpdateGetS3SecretRequest updateGetS3SecretRequest = OzoneManagerProtocolProtos.UpdateGetS3SecretRequest.newBuilder().setKerberosID(accessId).setAwsSecret(s3Secret).build();
            omRequest.setUpdateGetS3SecretRequest(updateGetS3SecretRequest);
        }
        if (this.getOmRequest().hasTraceID()) {
            omRequest.setTraceID(this.getOmRequest().getTraceID());
        }
        return omRequest.build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex) {
        OMClientResponse omClientResponse = null;
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
        Exception exception = null;
        OzoneManagerProtocolProtos.GetS3SecretRequest getS3SecretRequest = this.getOmRequest().getGetS3SecretRequest();
        assert (getS3SecretRequest.hasCreateIfNotExist());
        boolean createIfNotExist = getS3SecretRequest.getCreateIfNotExist();
        String accessId = getS3SecretRequest.getKerberosID();
        AtomicReference<String> awsSecret = new AtomicReference<String>();
        if (createIfNotExist) {
            OzoneManagerProtocolProtos.UpdateGetS3SecretRequest updateGetS3SecretRequest = this.getOmRequest().getUpdateGetS3SecretRequest();
            awsSecret.set(updateGetS3SecretRequest.getAwsSecret());
            assert (accessId.equals(updateGetS3SecretRequest.getKerberosID()));
        }
        try {
            omClientResponse = (OMClientResponse)ozoneManager.getS3SecretManager().doUnderLock(accessId, s3SecretManager -> {
                S3SecretValue assignS3SecretValue;
                S3SecretValue s3SecretValue = s3SecretManager.getSecret(accessId);
                if (s3SecretValue == null) {
                    if (createIfNotExist) {
                        assignS3SecretValue = new S3SecretValue(accessId, (String)awsSecret.get());
                        assignS3SecretValue.setTransactionLogIndex(transactionLogIndex);
                        s3SecretManager.updateCache(accessId, assignS3SecretValue);
                    } else {
                        assignS3SecretValue = null;
                    }
                } else {
                    OMMultiTenantManager multiTenantManager = ozoneManager.getMultiTenantManager();
                    if (multiTenantManager == null || !multiTenantManager.getTenantForAccessID(accessId).isPresent()) {
                        throw new OMException("Secret for '" + accessId + "' already exists", OMException.ResultCodes.S3_SECRET_ALREADY_EXISTS);
                    }
                    awsSecret.set(s3SecretValue.getAwsSecret());
                    assignS3SecretValue = null;
                }
                if (awsSecret.get() == null) {
                    assert (!createIfNotExist);
                    throw new OMException("accessId '" + accessId + "' doesn't exist", OMException.ResultCodes.ACCESS_ID_NOT_FOUND);
                }
                OzoneManagerProtocolProtos.GetS3SecretResponse.Builder getS3SecretResponse = OzoneManagerProtocolProtos.GetS3SecretResponse.newBuilder().setS3Secret(OzoneManagerProtocolProtos.S3Secret.newBuilder().setAwsSecret((String)awsSecret.get()).setKerberosID(accessId));
                return new S3GetSecretResponse(assignS3SecretValue, s3SecretManager, omResponse.setGetS3SecretResponse(getS3SecretResponse).build());
            });
        }
        catch (IOException | InvalidPathException ex) {
            exception = ex;
            omClientResponse = new S3GetSecretResponse(null, ozoneManager.getS3SecretManager(), this.createErrorOMResponse(omResponse, exception));
        }
        HashMap<String, String> auditMap = new HashMap<String, String>();
        auditMap.put("S3GetSecretUser", accessId);
        this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage(OMAction.GET_S3_SECRET, auditMap, exception, this.getOmRequest().getUserInfo()));
        if (exception == null) {
            LOG.debug("Success: GetSecret for accessKey '{}', createIfNotExist '{}'", (Object)accessId, (Object)createIfNotExist);
        } else {
            LOG.error("Failed to GetSecret for accessKey '{}', createIfNotExist '{}': {}", new Object[]{accessId, createIfNotExist, exception});
        }
        return omClientResponse;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("S3GetSecretRequest.java", S3GetSecretRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.s3.security.S3GetSecretRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 63);
    }
}

