/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.snapshot;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OmSnapshotManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.SnapshotChainManager;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.snapshot.OMSnapshotPurgeResponse;
import org.apache.hadoop.ozone.om.snapshot.SnapshotUtils;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class OMSnapshotPurgeRequest
extends OMClientRequest {
    public OMSnapshotPurgeRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex) {
        OmSnapshotManager omSnapshotManager = ozoneManager.getOmSnapshotManager();
        OmMetadataManagerImpl omMetadataManager = (OmMetadataManagerImpl)ozoneManager.getMetadataManager();
        SnapshotChainManager snapshotChainManager = omMetadataManager.getSnapshotChainManager();
        OMSnapshotPurgeResponse omClientResponse = null;
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
        OzoneManagerProtocolProtos.SnapshotPurgeRequest snapshotPurgeRequest = this.getOmRequest().getSnapshotPurgeRequest();
        try {
            List snapshotDbKeys = snapshotPurgeRequest.getSnapshotDBKeysList();
            List snapInfosToUpdate = snapshotPurgeRequest.getUpdatedSnapshotDBKeyList();
            HashMap<String, SnapshotInfo> updatedSnapInfos = new HashMap<String, SnapshotInfo>();
            HashMap<String, SnapshotInfo> updatedPathPreviousAndGlobalSnapshots = new HashMap<String, SnapshotInfo>();
            for (String snapTableKey : snapInfosToUpdate) {
                SnapshotInfo snapInfo = (SnapshotInfo)omMetadataManager.getSnapshotInfoTable().get((Object)snapTableKey);
                this.updateSnapshotInfoAndCache(snapInfo, omMetadataManager, trxnLogIndex, updatedSnapInfos, false);
            }
            for (String snapTableKey : snapshotDbKeys) {
                SnapshotInfo fromSnapshot = (SnapshotInfo)omMetadataManager.getSnapshotInfoTable().get((Object)snapTableKey);
                SnapshotInfo nextSnapshot = SnapshotUtils.getNextActiveSnapshot(fromSnapshot, snapshotChainManager, omSnapshotManager);
                this.updateSnapshotInfoAndCache(nextSnapshot, omMetadataManager, trxnLogIndex, updatedSnapInfos, true);
                this.updateSnapshotChainAndCache(omMetadataManager, fromSnapshot, trxnLogIndex, updatedPathPreviousAndGlobalSnapshots);
                ozoneManager.getOmSnapshotManager().getSnapshotCache().invalidate(snapTableKey);
            }
            omClientResponse = new OMSnapshotPurgeResponse(omResponse.build(), snapshotDbKeys, updatedSnapInfos, updatedPathPreviousAndGlobalSnapshots);
        }
        catch (IOException ex) {
            omClientResponse = new OMSnapshotPurgeResponse(this.createErrorOMResponse(omResponse, ex));
        }
        return omClientResponse;
    }

    private void updateSnapshotInfoAndCache(SnapshotInfo snapInfo, OmMetadataManagerImpl omMetadataManager, long trxnLogIndex, Map<String, SnapshotInfo> updatedSnapInfos, boolean deepClean) {
        if (snapInfo != null) {
            snapInfo.setDeepClean(deepClean);
            omMetadataManager.getSnapshotInfoTable().addCacheEntry(new CacheKey((Object)snapInfo.getTableKey()), CacheValue.get((long)trxnLogIndex, (Object)snapInfo));
            updatedSnapInfos.put(snapInfo.getTableKey(), snapInfo);
        }
    }

    private void updateSnapshotChainAndCache(OmMetadataManagerImpl metadataManager, SnapshotInfo snapInfo, long trxnLogIndex, Map<String, SnapshotInfo> updatedPathPreviousAndGlobalSnapshots) throws IOException {
        String snapshotTableKey;
        boolean hasNextGlobalSnapshot;
        boolean hasNextPathSnapshot;
        if (snapInfo == null) {
            return;
        }
        SnapshotChainManager snapshotChainManager = metadataManager.getSnapshotChainManager();
        SnapshotInfo nextPathSnapInfo = null;
        try {
            hasNextPathSnapshot = snapshotChainManager.hasNextPathSnapshot(snapInfo.getSnapshotPath(), snapInfo.getSnapshotId());
            hasNextGlobalSnapshot = snapshotChainManager.hasNextGlobalSnapshot(snapInfo.getSnapshotId());
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
        if (hasNextPathSnapshot) {
            UUID nextPathSnapshotId = snapshotChainManager.nextPathSnapshot(snapInfo.getSnapshotPath(), snapInfo.getSnapshotId());
            snapshotTableKey = snapshotChainManager.getTableKey(nextPathSnapshotId);
            nextPathSnapInfo = (SnapshotInfo)metadataManager.getSnapshotInfoTable().get((Object)snapshotTableKey);
            if (nextPathSnapInfo != null) {
                nextPathSnapInfo.setPathPreviousSnapshotId(snapInfo.getPathPreviousSnapshotId());
                metadataManager.getSnapshotInfoTable().addCacheEntry(new CacheKey((Object)nextPathSnapInfo.getTableKey()), CacheValue.get((long)trxnLogIndex, (Object)nextPathSnapInfo));
                updatedPathPreviousAndGlobalSnapshots.put(nextPathSnapInfo.getTableKey(), nextPathSnapInfo);
            }
        }
        if (hasNextGlobalSnapshot) {
            UUID nextGlobalSnapshotId = snapshotChainManager.nextGlobalSnapshot(snapInfo.getSnapshotId());
            snapshotTableKey = snapshotChainManager.getTableKey(nextGlobalSnapshotId);
            SnapshotInfo nextGlobalSnapInfo = (SnapshotInfo)metadataManager.getSnapshotInfoTable().get((Object)snapshotTableKey);
            if (nextGlobalSnapInfo != null && nextPathSnapInfo != null && nextGlobalSnapInfo.getSnapshotId().equals(nextPathSnapInfo.getSnapshotId())) {
                nextPathSnapInfo.setGlobalPreviousSnapshotId(snapInfo.getGlobalPreviousSnapshotId());
                metadataManager.getSnapshotInfoTable().addCacheEntry(new CacheKey((Object)nextPathSnapInfo.getTableKey()), CacheValue.get((long)trxnLogIndex, (Object)nextPathSnapInfo));
                updatedPathPreviousAndGlobalSnapshots.put(nextPathSnapInfo.getTableKey(), nextPathSnapInfo);
            } else if (nextGlobalSnapInfo != null) {
                nextGlobalSnapInfo.setGlobalPreviousSnapshotId(snapInfo.getGlobalPreviousSnapshotId());
                metadataManager.getSnapshotInfoTable().addCacheEntry(new CacheKey((Object)nextGlobalSnapInfo.getTableKey()), CacheValue.get((long)trxnLogIndex, (Object)nextGlobalSnapInfo));
                updatedPathPreviousAndGlobalSnapshots.put(nextGlobalSnapInfo.getTableKey(), nextGlobalSnapInfo);
            }
        }
        snapshotChainManager.deleteSnapshot(snapInfo);
    }
}

