/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.snapshot;

import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.snapshot.OMSnapshotSetPropertyResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMSnapshotSetPropertyRequest
extends OMClientRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMSnapshotSetPropertyRequest.class);

    public OMSnapshotSetPropertyRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex) {
        OMSnapshotSetPropertyResponse omClientResponse = null;
        OMMetadataManager metadataManager = ozoneManager.getMetadataManager();
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
        OzoneManagerProtocolProtos.SetSnapshotPropertyRequest setSnapshotPropertyRequest = this.getOmRequest().getSetSnapshotPropertyRequest();
        OzoneManagerProtocolProtos.SnapshotProperty snapshotProperty = setSnapshotPropertyRequest.getSnapshotProperty();
        SnapshotInfo updatedSnapInfo = null;
        try {
            String snapshotKey = snapshotProperty.getSnapshotKey();
            long exclusiveSize = snapshotProperty.getExclusiveSize();
            long exclusiveReplicatedSize = snapshotProperty.getExclusiveReplicatedSize();
            updatedSnapInfo = (SnapshotInfo)metadataManager.getSnapshotInfoTable().get((Object)snapshotKey);
            if (updatedSnapInfo == null) {
                LOG.error("SnapshotInfo for Snapshot: {} is not found", (Object)snapshotKey);
                throw new OMException("SnapshotInfo for Snapshot: " + snapshotKey + " is not found", OMException.ResultCodes.INVALID_SNAPSHOT_ERROR);
            }
            updatedSnapInfo.setExclusiveSize(exclusiveSize);
            updatedSnapInfo.setExclusiveReplicatedSize(exclusiveReplicatedSize);
            metadataManager.getSnapshotInfoTable().addCacheEntry(new CacheKey((Object)snapshotKey), CacheValue.get((long)trxnLogIndex, (Object)updatedSnapInfo));
            omClientResponse = new OMSnapshotSetPropertyResponse(omResponse.build(), updatedSnapInfo);
        }
        catch (IOException ex) {
            omClientResponse = new OMSnapshotSetPropertyResponse(this.createErrorOMResponse(omResponse, ex));
        }
        return omClientResponse;
    }
}

