/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.key.OmKeyResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"openKeyTable", "keyTable", "deletedTable", "bucketTable"})
public class OMKeyCommitResponse
extends OmKeyResponse {
    private OmKeyInfo omKeyInfo;
    private String ozoneKeyName;
    private String openKeyName;
    private OmBucketInfo omBucketInfo;
    private Map<String, RepeatedOmKeyInfo> keyToDeleteMap;
    private boolean isHSync;

    public OMKeyCommitResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull OmKeyInfo omKeyInfo, String ozoneKeyName, String openKeyName, @Nonnull OmBucketInfo omBucketInfo, Map<String, RepeatedOmKeyInfo> keyToDeleteMap, boolean isHSync) {
        super(omResponse, omBucketInfo.getBucketLayout());
        this.omKeyInfo = omKeyInfo;
        this.ozoneKeyName = ozoneKeyName;
        this.openKeyName = openKeyName;
        this.omBucketInfo = omBucketInfo;
        this.keyToDeleteMap = keyToDeleteMap;
        this.isHSync = isHSync;
    }

    public OMKeyCommitResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull BucketLayout bucketLayout) {
        super(omResponse, bucketLayout);
        this.checkStatusNotOK();
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (!this.isHSync()) {
            omMetadataManager.getOpenKeyTable(this.getBucketLayout()).deleteWithBatch(batchOperation, (Object)this.openKeyName);
        }
        omMetadataManager.getKeyTable(this.getBucketLayout()).putWithBatch(batchOperation, (Object)this.ozoneKeyName, (Object)this.omKeyInfo);
        this.updateDeletedTable(omMetadataManager, batchOperation);
        omMetadataManager.getBucketTable().putWithBatch(batchOperation, (Object)omMetadataManager.getBucketKey(this.omBucketInfo.getVolumeName(), this.omBucketInfo.getBucketName()), (Object)this.omBucketInfo);
    }

    protected String getOpenKeyName() {
        return this.openKeyName;
    }

    protected OmKeyInfo getOmKeyInfo() {
        return this.omKeyInfo;
    }

    protected OmBucketInfo getOmBucketInfo() {
        return this.omBucketInfo;
    }

    protected String getOzoneKeyName() {
        return this.ozoneKeyName;
    }

    @VisibleForTesting
    public Map<String, RepeatedOmKeyInfo> getKeysToDelete() {
        return this.keyToDeleteMap;
    }

    protected void updateDeletedTable(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.keyToDeleteMap != null) {
            for (Map.Entry<String, RepeatedOmKeyInfo> entry : this.keyToDeleteMap.entrySet()) {
                omMetadataManager.getDeletedTable().putWithBatch(batchOperation, (Object)entry.getKey(), (Object)entry.getValue());
            }
        }
    }

    protected boolean isHSync() {
        return this.isHSync;
    }
}

