/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.key.AbstractOMKeyDeleteResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"keyTable", "deletedTable", "bucketTable"})
public class OMKeyDeleteResponse
extends AbstractOMKeyDeleteResponse {
    private OmKeyInfo omKeyInfo;
    private OmBucketInfo omBucketInfo;

    public OMKeyDeleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull OmKeyInfo omKeyInfo, boolean isRatisEnabled, @Nonnull OmBucketInfo omBucketInfo) {
        super(omResponse, isRatisEnabled, omBucketInfo.getBucketLayout());
        this.omKeyInfo = omKeyInfo;
        this.omBucketInfo = omBucketInfo;
    }

    public OMKeyDeleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull BucketLayout bucketLayout) {
        super(omResponse, bucketLayout);
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        String ozoneKey = omMetadataManager.getOzoneKey(this.omKeyInfo.getVolumeName(), this.omKeyInfo.getBucketName(), this.omKeyInfo.getKeyName());
        Table keyTable = omMetadataManager.getKeyTable(this.getBucketLayout());
        this.addDeletionToBatch(omMetadataManager, batchOperation, keyTable, ozoneKey, this.omKeyInfo);
        omMetadataManager.getBucketTable().putWithBatch(batchOperation, (Object)omMetadataManager.getBucketKey(this.omBucketInfo.getVolumeName(), this.omBucketInfo.getBucketName()), (Object)this.omBucketInfo);
    }

    protected OmKeyInfo getOmKeyInfo() {
        return this.omKeyInfo;
    }

    protected OmBucketInfo getOmBucketInfo() {
        return this.omBucketInfo;
    }
}

