/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key;

import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmRenameKeys;
import org.apache.hadoop.ozone.om.request.OMClientRequestUtils;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"keyTable", "snapshotRenamedTable"})
public class OMKeysRenameResponse
extends OMClientResponse {
    private OmRenameKeys omRenameKeys;

    public OMKeysRenameResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, OmRenameKeys omRenameKeys) {
        super(omResponse);
        this.omRenameKeys = omRenameKeys;
    }

    @Override
    public void checkAndUpdateDB(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.OK || this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.PARTIAL_RENAME) {
            this.addToDBBatch(omMetadataManager, batchOperation);
        }
    }

    public OMKeysRenameResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        String volumeName = this.omRenameKeys.getVolume();
        String bucketName = this.omRenameKeys.getBucket();
        for (Map.Entry entry : this.omRenameKeys.getFromKeyAndToKeyInfo().entrySet()) {
            String fromKeyName = (String)entry.getKey();
            OmKeyInfo newKeyInfo = (OmKeyInfo)entry.getValue();
            String toKeyName = newKeyInfo.getKeyName();
            String fromDbKey = omMetadataManager.getOzoneKey(volumeName, bucketName, fromKeyName);
            omMetadataManager.getKeyTable(this.getBucketLayout()).deleteWithBatch(batchOperation, (Object)fromDbKey);
            omMetadataManager.getKeyTable(this.getBucketLayout()).putWithBatch(batchOperation, (Object)omMetadataManager.getOzoneKey(volumeName, bucketName, toKeyName), (Object)newKeyInfo);
            boolean isSnapshotBucket = OMClientRequestUtils.isSnapshotBucket(omMetadataManager, newKeyInfo);
            String renameDbKey = omMetadataManager.getRenameKey(newKeyInfo.getVolumeName(), newKeyInfo.getBucketName(), newKeyInfo.getObjectID());
            String renamedKey = (String)omMetadataManager.getSnapshotRenamedTable().get((Object)renameDbKey);
            if (!isSnapshotBucket || renamedKey != null) continue;
            omMetadataManager.getSnapshotRenamedTable().putWithBatch(batchOperation, (Object)renameDbKey, (Object)fromDbKey);
        }
    }
}

