/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.s3.multipart;

import java.io.IOException;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.key.OmKeyResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"openKeyTable", "keyTable", "deletedTable", "multipartInfoTable", "bucketTable"})
public class S3MultipartUploadCompleteResponse
extends OmKeyResponse {
    private String multipartKey;
    private String multipartOpenKey;
    private OmKeyInfo omKeyInfo;
    private List<OmKeyInfo> allKeyInfoToRemove;
    private OmBucketInfo omBucketInfo;

    public S3MultipartUploadCompleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull String multipartKey, @Nonnull String multipartOpenKey, @Nonnull OmKeyInfo omKeyInfo, @Nonnull List<OmKeyInfo> allKeyInfoToRemove, @Nonnull BucketLayout bucketLayout, @CheckForNull OmBucketInfo omBucketInfo) {
        super(omResponse, bucketLayout);
        this.allKeyInfoToRemove = allKeyInfoToRemove;
        this.multipartKey = multipartKey;
        this.multipartOpenKey = multipartOpenKey;
        this.omKeyInfo = omKeyInfo;
        this.omBucketInfo = omBucketInfo;
    }

    public S3MultipartUploadCompleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull BucketLayout bucketLayout) {
        super(omResponse, bucketLayout);
        this.checkStatusNotOK();
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        omMetadataManager.getOpenKeyTable(this.getBucketLayout()).deleteWithBatch(batchOperation, (Object)this.multipartOpenKey);
        omMetadataManager.getMultipartInfoTable().deleteWithBatch(batchOperation, (Object)this.multipartKey);
        this.addToKeyTable(omMetadataManager, batchOperation);
        if (!this.allKeyInfoToRemove.isEmpty()) {
            for (OmKeyInfo keyInfoToRemove : this.allKeyInfoToRemove) {
                String deleteKey = omMetadataManager.getOzoneDeletePathKey(keyInfoToRemove.getObjectID(), this.multipartKey);
                omMetadataManager.getDeletedTable().putWithBatch(batchOperation, (Object)deleteKey, (Object)new RepeatedOmKeyInfo(keyInfoToRemove));
            }
        }
        if (this.omBucketInfo != null) {
            omMetadataManager.getBucketTable().putWithBatch(batchOperation, (Object)omMetadataManager.getBucketKey(this.omBucketInfo.getVolumeName(), this.omBucketInfo.getBucketName()), (Object)this.omBucketInfo);
        }
    }

    protected String addToKeyTable(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        String ozoneKey = omMetadataManager.getOzoneKey(this.omKeyInfo.getVolumeName(), this.omKeyInfo.getBucketName(), this.omKeyInfo.getKeyName());
        omMetadataManager.getKeyTable(this.getBucketLayout()).putWithBatch(batchOperation, (Object)ozoneKey, (Object)this.omKeyInfo);
        return ozoneKey;
    }

    protected OmKeyInfo getOmKeyInfo() {
        return this.omKeyInfo;
    }
}

