/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.s3.security;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.S3SecretManager;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"s3SecretTable"})
public class S3GetSecretResponse
extends OMClientResponse {
    private final S3SecretValue s3SecretValue;
    private final S3SecretManager s3SecretManager;

    public S3GetSecretResponse(@Nullable S3SecretValue s3SecretValue, @Nonnull S3SecretManager secretManager, @Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.s3SecretManager = secretManager;
        this.s3SecretValue = s3SecretValue;
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        boolean isOk;
        boolean bl = isOk = this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.OK;
        if (this.s3SecretValue != null && isOk) {
            if (this.s3SecretManager.isBatchSupported()) {
                this.s3SecretManager.batcher().addWithBatch((AutoCloseable)batchOperation, this.s3SecretValue.getKerberosID(), this.s3SecretValue);
            } else {
                this.s3SecretManager.storeSecret(this.s3SecretValue.getKerberosID(), this.s3SecretValue);
            }
        }
    }

    @VisibleForTesting
    public S3SecretValue getS3SecretValue() {
        return this.s3SecretValue;
    }
}

