/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.s3.tenant;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"metaTable"})
public class OMSetRangerServiceVersionResponse
extends OMClientResponse {
    private String serviceVersionKey;
    private String serviceVersionValueStr;

    public OMSetRangerServiceVersionResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull String dbKey, @Nonnull String versionStr) {
        super(omResponse);
        this.serviceVersionKey = dbKey;
        this.serviceVersionValueStr = versionStr;
    }

    public OMSetRangerServiceVersionResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        omMetadataManager.getMetaTable().putWithBatch(batchOperation, (Object)this.serviceVersionKey, (Object)this.serviceVersionValueStr);
    }

    @VisibleForTesting
    public String getNewServiceVersion() {
        return this.serviceVersionValueStr;
    }
}

