/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.security;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;

@CleanupTableInfo(cleanupTables={"dTokenTable"})
public class OMCancelDelegationTokenResponse
extends OMClientResponse {
    private OzoneTokenIdentifier ozoneTokenIdentifier;

    public OMCancelDelegationTokenResponse(@Nullable OzoneTokenIdentifier ozoneTokenIdentifier, @Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.ozoneTokenIdentifier = ozoneTokenIdentifier;
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        Table table = omMetadataManager.getDelegationTokenTable();
        if (this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.OK) {
            table.deleteWithBatch(batchOperation, (Object)this.ozoneTokenIdentifier);
        }
    }
}

