/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.snapshot;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.RDBStore;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CleanupTableInfo(cleanupTables={"snapshotInfoTable"})
public class OMSnapshotPurgeResponse
extends OMClientResponse {
    private static final Logger LOG = LoggerFactory.getLogger(OMSnapshotPurgeResponse.class);
    private final List<String> snapshotDbKeys;
    private final Map<String, SnapshotInfo> updatedSnapInfos;
    private final Map<String, SnapshotInfo> updatedPreviousAndGlobalSnapInfos;

    public OMSnapshotPurgeResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull List<String> snapshotDbKeys, Map<String, SnapshotInfo> updatedSnapInfos, Map<String, SnapshotInfo> updatedPreviousAndGlobalSnapInfos) {
        super(omResponse);
        this.snapshotDbKeys = snapshotDbKeys;
        this.updatedSnapInfos = updatedSnapInfos;
        this.updatedPreviousAndGlobalSnapInfos = updatedPreviousAndGlobalSnapInfos;
    }

    public OMSnapshotPurgeResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
        this.snapshotDbKeys = null;
        this.updatedSnapInfos = null;
        this.updatedPreviousAndGlobalSnapInfos = null;
    }

    @Override
    protected void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        OmMetadataManagerImpl metadataManager = (OmMetadataManagerImpl)omMetadataManager;
        this.updateSnapInfo(metadataManager, batchOperation, this.updatedSnapInfos);
        this.updateSnapInfo(metadataManager, batchOperation, this.updatedPreviousAndGlobalSnapInfos);
        for (String dbKey : this.snapshotDbKeys) {
            SnapshotInfo snapshotInfo = (SnapshotInfo)omMetadataManager.getSnapshotInfoTable().get((Object)dbKey);
            if (snapshotInfo == null) continue;
            this.deleteCheckpointDirectory(omMetadataManager, snapshotInfo);
            omMetadataManager.getSnapshotInfoTable().deleteWithBatch(batchOperation, (Object)dbKey);
        }
    }

    private void updateSnapInfo(OmMetadataManagerImpl metadataManager, BatchOperation batchOp, Map<String, SnapshotInfo> snapshotInfos) throws IOException {
        for (Map.Entry<String, SnapshotInfo> entry : snapshotInfos.entrySet()) {
            metadataManager.getSnapshotInfoTable().putWithBatch(batchOp, (Object)entry.getKey(), (Object)entry.getValue());
        }
    }

    private void deleteCheckpointDirectory(OMMetadataManager omMetadataManager, SnapshotInfo snapshotInfo) {
        RDBStore store = (RDBStore)omMetadataManager.getStore();
        String checkpointPrefix = store.getDbLocation().getName();
        Path snapshotDirPath = Paths.get(store.getSnapshotsParentDir(), String.valueOf(checkpointPrefix) + snapshotInfo.getCheckpointDir());
        try {
            FileUtils.deleteDirectory((File)snapshotDirPath.toFile());
        }
        catch (IOException ex) {
            LOG.error("Failed to delete snapshot directory {} for snapshot {}", new Object[]{snapshotDirPath, snapshotInfo.getTableKey(), ex});
        }
    }
}

