/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.service;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.utils.BackgroundTask;
import org.apache.hadoop.hdds.utils.BackgroundTaskQueue;
import org.apache.hadoop.hdds.utils.BackgroundTaskResult;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.om.IOmMetadataReader;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OmSnapshot;
import org.apache.hadoop.ozone.om.OmSnapshotManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.service.AbstractKeyDeletingService;
import org.apache.hadoop.ozone.om.snapshot.ReferenceCounted;
import org.apache.hadoop.ozone.om.snapshot.SnapshotCache;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.util.Time;
import org.apache.ratis.protocol.ClientId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryDeletingService
extends AbstractKeyDeletingService {
    public static final Logger LOG = LoggerFactory.getLogger(DirectoryDeletingService.class);
    private static ClientId clientId = ClientId.randomId();
    private static final int DIR_DELETING_CORE_POOL_SIZE = 1;
    private static final int MIN_ERR_LIMIT_PER_TASK = 1000;
    private final long pathLimitPerTask;
    private final int ratisByteLimit;
    private final AtomicBoolean suspended;

    public DirectoryDeletingService(long interval, TimeUnit unit, long serviceTimeout, OzoneManager ozoneManager, OzoneConfiguration configuration) {
        super(DirectoryDeletingService.class.getSimpleName(), interval, unit, 1, serviceTimeout, ozoneManager, null);
        this.pathLimitPerTask = configuration.getInt("ozone.path.deleting.limit.per.task", 6000);
        int limit = (int)configuration.getStorageSize("ozone.om.ratis.log.appender.queue.byte-limit", "32MB", StorageUnit.BYTES);
        this.ratisByteLimit = (int)((double)limit * 0.9);
        this.suspended = new AtomicBoolean(false);
    }

    private boolean shouldRun() {
        if (this.getOzoneManager() == null) {
            return true;
        }
        return this.getOzoneManager().isLeaderReady() && !this.suspended.get();
    }

    @VisibleForTesting
    public void suspend() {
        this.suspended.set(true);
    }

    @VisibleForTesting
    public void resume() {
        this.suspended.set(false);
    }

    public BackgroundTaskQueue getTasks() {
        BackgroundTaskQueue queue = new BackgroundTaskQueue();
        queue.add((BackgroundTask)new DirDeletingTask());
        return queue;
    }

    private class DirDeletingTask
    implements BackgroundTask {
        private DirDeletingTask() {
        }

        public int getPriority() {
            return 0;
        }

        public BackgroundTaskResult call() {
            block20: {
                if (DirectoryDeletingService.this.shouldRun()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Running DirectoryDeletingService");
                    }
                    DirectoryDeletingService.this.getRunCount().incrementAndGet();
                    long dirNum = 0L;
                    long subDirNum = 0L;
                    long subFileNum = 0L;
                    long remainNum = DirectoryDeletingService.this.pathLimitPerTask;
                    int consumedSize = 0;
                    ArrayList<OzoneManagerProtocolProtos.PurgePathRequest> purgePathRequestList = new ArrayList<OzoneManagerProtocolProtos.PurgePathRequest>();
                    ArrayList<Pair<String, OmKeyInfo>> allSubDirList = new ArrayList<Pair<String, OmKeyInfo>>((int)remainNum);
                    DirectoryDeletingService.this.getOzoneManager().getMetadataManager().getTableLock("deletedDirectoryTable").writeLock().lock();
                    try {
                        try {
                            Throwable throwable = null;
                            Object var14_11 = null;
                            try (TableIterator deleteTableIterator = DirectoryDeletingService.this.getOzoneManager().getMetadataManager().getDeletedDirTable().iterator();){
                                long startTime = Time.monotonicNow();
                                while (remainNum > 0L && deleteTableIterator.hasNext()) {
                                    Table.KeyValue pendingDeletedDirInfo = (Table.KeyValue)deleteTableIterator.next();
                                    if (this.previousSnapshotHasDir((Table.KeyValue<String, OmKeyInfo>)pendingDeletedDirInfo)) continue;
                                    OzoneManagerProtocolProtos.PurgePathRequest request = DirectoryDeletingService.this.prepareDeleteDirRequest(remainNum, (OmKeyInfo)pendingDeletedDirInfo.getValue(), (String)pendingDeletedDirInfo.getKey(), allSubDirList, DirectoryDeletingService.this.getOzoneManager().getKeyManager());
                                    if (DirectoryDeletingService.this.isBufferLimitCrossed(DirectoryDeletingService.this.ratisByteLimit, consumedSize, request.getSerializedSize())) {
                                        if (purgePathRequestList.size() != 0) {
                                            remainNum = 0L;
                                            break;
                                        }
                                        remainNum = 1000L;
                                        request = DirectoryDeletingService.this.prepareDeleteDirRequest(remainNum, (OmKeyInfo)pendingDeletedDirInfo.getValue(), (String)pendingDeletedDirInfo.getKey(), allSubDirList, DirectoryDeletingService.this.getOzoneManager().getKeyManager());
                                    }
                                    consumedSize += request.getSerializedSize();
                                    purgePathRequestList.add(request);
                                    remainNum -= (long)request.getDeletedSubFilesCount();
                                    remainNum -= (long)request.getMarkDeletedSubDirsCount();
                                    if (request.getDeletedDir() != null && !request.getDeletedDir().isEmpty()) {
                                        ++dirNum;
                                    }
                                    subDirNum += (long)request.getMarkDeletedSubDirsCount();
                                    subFileNum += (long)request.getDeletedSubFilesCount();
                                }
                                DirectoryDeletingService.this.optimizeDirDeletesAndSubmitRequest(remainNum, dirNum, subDirNum, subFileNum, allSubDirList, purgePathRequestList, null, startTime, DirectoryDeletingService.this.ratisByteLimit - consumedSize, DirectoryDeletingService.this.getOzoneManager().getKeyManager());
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException e) {
                            LOG.error("Error while running delete directories and files background task. Will retry at next run.", (Throwable)e);
                            DirectoryDeletingService.this.getOzoneManager().getMetadataManager().getTableLock("deletedDirectoryTable").writeLock().unlock();
                            break block20;
                        }
                    }
                    catch (Throwable throwable) {
                        DirectoryDeletingService.this.getOzoneManager().getMetadataManager().getTableLock("deletedDirectoryTable").writeLock().unlock();
                        throw throwable;
                    }
                    DirectoryDeletingService.this.getOzoneManager().getMetadataManager().getTableLock("deletedDirectoryTable").writeLock().unlock();
                }
            }
            return BackgroundTaskResult.EmptyTaskResult.newResult();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean previousSnapshotHasDir(Table.KeyValue<String, OmKeyInfo> pendingDeletedDirInfo) throws IOException {
            String key = (String)pendingDeletedDirInfo.getKey();
            OmKeyInfo deletedDirInfo = (OmKeyInfo)pendingDeletedDirInfo.getValue();
            OmSnapshotManager omSnapshotManager = DirectoryDeletingService.this.getOzoneManager().getOmSnapshotManager();
            OmMetadataManagerImpl metadataManager = (OmMetadataManagerImpl)DirectoryDeletingService.this.getOzoneManager().getMetadataManager();
            Throwable throwable = null;
            Object var7_8 = null;
            try (ReferenceCounted<IOmMetadataReader, SnapshotCache> rcLatestSnapshot = metadataManager.getLatestActiveSnapshot(deletedDirInfo.getVolumeName(), deletedDirInfo.getBucketName(), omSnapshotManager);){
                boolean bl;
                if (rcLatestSnapshot == null) return false;
                String dbRenameKey = metadataManager.getRenameKey(deletedDirInfo.getVolumeName(), deletedDirInfo.getBucketName(), deletedDirInfo.getObjectID());
                Table prevDirTable = ((OmSnapshot)rcLatestSnapshot.get()).getMetadataManager().getDirectoryTable();
                Table prevDeletedDirTable = ((OmSnapshot)rcLatestSnapshot.get()).getMetadataManager().getDeletedDirTable();
                OmKeyInfo prevDeletedDirInfo = (OmKeyInfo)prevDeletedDirTable.get((Object)key);
                if (prevDeletedDirInfo != null) {
                    return true;
                }
                String prevDirTableDBKey = (String)metadataManager.getSnapshotRenamedTable().get((Object)dbRenameKey);
                String prevDbKey = prevDirTableDBKey == null ? metadataManager.getOzoneDeletePathDirKey(key) : prevDirTableDBKey;
                OmDirectoryInfo prevDirInfo = (OmDirectoryInfo)prevDirTable.get((Object)prevDbKey);
                if (prevDirInfo != null && prevDirInfo.getObjectID() == deletedDirInfo.getObjectID()) {
                    bl = true;
                    return bl;
                }
                bl = false;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
    }
}

