/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocol;
import org.apache.hadoop.hdds.utils.BackgroundTask;
import org.apache.hadoop.hdds.utils.BackgroundTaskQueue;
import org.apache.hadoop.hdds.utils.BackgroundTaskResult;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.common.BlockGroup;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.PendingKeysDeletion;
import org.apache.hadoop.ozone.om.helpers.OMRatisHelper;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.ratis.OzoneManagerRatisServer;
import org.apache.hadoop.ozone.om.service.AbstractKeyDeletingService;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyDeletingService
extends AbstractKeyDeletingService {
    private static final Logger LOG = LoggerFactory.getLogger(KeyDeletingService.class);
    private static final int KEY_DELETING_CORE_POOL_SIZE = 1;
    private final KeyManager manager;
    private int keyLimitPerTask;
    private final AtomicLong deletedKeyCount;
    private final AtomicBoolean suspended;
    private final Map<String, Long> exclusiveSizeMap;
    private final Map<String, Long> exclusiveReplicatedSizeMap;
    private final Set<String> completedExclusiveSizeSet;

    public KeyDeletingService(OzoneManager ozoneManager, ScmBlockLocationProtocol scmClient, KeyManager manager, long serviceInterval, long serviceTimeout, ConfigurationSource conf) {
        super(KeyDeletingService.class.getSimpleName(), serviceInterval, TimeUnit.MILLISECONDS, 1, serviceTimeout, ozoneManager, scmClient);
        this.manager = manager;
        this.keyLimitPerTask = conf.getInt("ozone.key.deleting.limit.per.task", 20000);
        Preconditions.checkArgument((this.keyLimitPerTask >= 0 ? 1 : 0) != 0, (Object)"ozone.key.deleting.limit.per.task cannot be negative.");
        this.deletedKeyCount = new AtomicLong(0L);
        this.suspended = new AtomicBoolean(false);
        this.exclusiveSizeMap = new HashMap<String, Long>();
        this.exclusiveReplicatedSizeMap = new HashMap<String, Long>();
        this.completedExclusiveSizeSet = new HashSet<String>();
    }

    @VisibleForTesting
    public AtomicLong getDeletedKeyCount() {
        return this.deletedKeyCount;
    }

    public BackgroundTaskQueue getTasks() {
        BackgroundTaskQueue queue = new BackgroundTaskQueue();
        queue.add((BackgroundTask)new KeyDeletingTask());
        return queue;
    }

    private boolean shouldRun() {
        if (this.getOzoneManager() == null) {
            return true;
        }
        return !this.suspended.get() && this.getOzoneManager().isLeaderReady();
    }

    @VisibleForTesting
    public void suspend() {
        this.suspended.set(true);
    }

    @VisibleForTesting
    public void resume() {
        this.suspended.set(false);
    }

    public int getKeyLimitPerTask() {
        return this.keyLimitPerTask;
    }

    public void setKeyLimitPerTask(int keyLimitPerTask) {
        this.keyLimitPerTask = keyLimitPerTask;
    }

    private class KeyDeletingTask
    implements BackgroundTask {
        private KeyDeletingTask() {
        }

        public int getPriority() {
            return 0;
        }

        public BackgroundTaskResult call() {
            if (KeyDeletingService.this.shouldRun()) {
                int delCount;
                block10: {
                    long run = KeyDeletingService.this.getRunCount().incrementAndGet();
                    LOG.debug("Running KeyDeletingService {}", (Object)run);
                    KeyDeletingService.this.manager.getMetadataManager().getTableLock("deletedTable").writeLock().lock();
                    delCount = 0;
                    try {
                        try {
                            PendingKeysDeletion pendingKeysDeletion = KeyDeletingService.this.manager.getPendingDeletionKeys(KeyDeletingService.this.getKeyLimitPerTask());
                            List<BlockGroup> keyBlocksList = pendingKeysDeletion.getKeyBlocksList();
                            if (keyBlocksList != null && !keyBlocksList.isEmpty()) {
                                delCount = KeyDeletingService.this.processKeyDeletes(keyBlocksList, KeyDeletingService.this.getOzoneManager().getKeyManager(), pendingKeysDeletion.getKeysToModify(), null);
                                KeyDeletingService.this.deletedKeyCount.addAndGet(delCount);
                            }
                        }
                        catch (IOException e) {
                            LOG.error("Error while running delete keys background task. Will retry at next run.", (Throwable)e);
                            KeyDeletingService.this.manager.getMetadataManager().getTableLock("deletedTable").writeLock().unlock();
                            break block10;
                        }
                    }
                    catch (Throwable throwable) {
                        KeyDeletingService.this.manager.getMetadataManager().getTableLock("deletedTable").writeLock().unlock();
                        throw throwable;
                    }
                    KeyDeletingService.this.manager.getMetadataManager().getTableLock("deletedTable").writeLock().unlock();
                }
                try {
                    if (delCount < KeyDeletingService.this.keyLimitPerTask) {
                        this.processSnapshotDeepClean(delCount);
                    }
                }
                catch (Exception e) {
                    LOG.error("Error while running deep clean on snapshots. Will retry at next run.", (Throwable)e);
                }
            }
            return BackgroundTaskResult.EmptyTaskResult.newResult();
        }

        /*
         * Exception decompiling
         */
        private void processSnapshotDeepClean(int delCount) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [17[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void calculateExclusiveSize(SnapshotInfo previousSnapshot, SnapshotInfo previousToPrevSnapshot, OmKeyInfo keyInfo, OmBucketInfo bucketInfo, long volumeId, Table<String, String> snapRenamedTable, Table<String, OmKeyInfo> previousKeyTable, Table<String, String> prevRenamedTable, Table<String, OmKeyInfo> previousToPrevKeyTable) throws IOException {
            String prevSnapKey = previousSnapshot.getTableKey();
            long exclusiveReplicatedSize = KeyDeletingService.this.exclusiveReplicatedSizeMap.getOrDefault(prevSnapKey, 0L) + keyInfo.getReplicatedSize();
            long exclusiveSize = KeyDeletingService.this.exclusiveSizeMap.getOrDefault(prevSnapKey, 0L) + keyInfo.getDataSize();
            if (previousToPrevSnapshot == null) {
                KeyDeletingService.this.exclusiveSizeMap.put(prevSnapKey, exclusiveSize);
                KeyDeletingService.this.exclusiveReplicatedSizeMap.put(prevSnapKey, exclusiveReplicatedSize);
            } else {
                OmKeyInfo keyInfoPrevSnapshot = this.getPreviousSnapshotKeyName(keyInfo, bucketInfo, volumeId, snapRenamedTable, previousKeyTable);
                OmKeyInfo keyInfoPrevToPrevSnapshot = this.getPreviousSnapshotKeyName(keyInfoPrevSnapshot, bucketInfo, volumeId, prevRenamedTable, previousToPrevKeyTable);
                if (keyInfoPrevToPrevSnapshot == null) {
                    KeyDeletingService.this.exclusiveSizeMap.put(prevSnapKey, exclusiveSize);
                    KeyDeletingService.this.exclusiveReplicatedSizeMap.put(prevSnapKey, exclusiveReplicatedSize);
                }
            }
        }

        private OmKeyInfo getPreviousSnapshotKeyName(OmKeyInfo keyInfo, OmBucketInfo bucketInfo, long volumeId, Table<String, String> snapRenamedTable, Table<String, OmKeyInfo> previousKeyTable) throws IOException {
            if (keyInfo == null) {
                return null;
            }
            String dbKeyPrevSnap = bucketInfo.getBucketLayout().isFileSystemOptimized() ? KeyDeletingService.this.getOzoneManager().getMetadataManager().getOzonePathKey(volumeId, bucketInfo.getObjectID(), keyInfo.getParentObjectID(), keyInfo.getFileName()) : KeyDeletingService.this.getOzoneManager().getMetadataManager().getOzoneKey(keyInfo.getVolumeName(), keyInfo.getBucketName(), keyInfo.getKeyName());
            String dbRenameKey = KeyDeletingService.this.getOzoneManager().getMetadataManager().getRenameKey(keyInfo.getVolumeName(), keyInfo.getBucketName(), keyInfo.getObjectID());
            String renamedKey = (String)snapRenamedTable.getIfExist((Object)dbRenameKey);
            dbKeyPrevSnap = renamedKey != null ? renamedKey : dbKeyPrevSnap;
            return (OmKeyInfo)previousKeyTable.get((Object)dbKeyPrevSnap);
        }

        private void updateSnapshotExclusiveSize() {
            if (KeyDeletingService.this.completedExclusiveSizeSet.isEmpty()) {
                return;
            }
            Iterator completedSnapshotIterator = KeyDeletingService.this.completedExclusiveSizeSet.iterator();
            while (completedSnapshotIterator.hasNext()) {
                ClientId clientId = ClientId.randomId();
                String dbKey = (String)completedSnapshotIterator.next();
                OzoneManagerProtocolProtos.SnapshotProperty snapshotProperty = OzoneManagerProtocolProtos.SnapshotProperty.newBuilder().setSnapshotKey(dbKey).setExclusiveSize(((Long)KeyDeletingService.this.exclusiveSizeMap.get(dbKey)).longValue()).setExclusiveReplicatedSize(((Long)KeyDeletingService.this.exclusiveReplicatedSizeMap.get(dbKey)).longValue()).build();
                OzoneManagerProtocolProtos.SetSnapshotPropertyRequest setSnapshotPropertyRequest = OzoneManagerProtocolProtos.SetSnapshotPropertyRequest.newBuilder().setSnapshotProperty(snapshotProperty).build();
                OzoneManagerProtocolProtos.OMRequest omRequest = OzoneManagerProtocolProtos.OMRequest.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.SetSnapshotProperty).setSetSnapshotPropertyRequest(setSnapshotPropertyRequest).setClientId(clientId.toString()).build();
                this.submitRequest(omRequest, clientId);
                KeyDeletingService.this.exclusiveSizeMap.remove(dbKey);
                KeyDeletingService.this.exclusiveReplicatedSizeMap.remove(dbKey);
                completedSnapshotIterator.remove();
            }
        }

        private void updateDeepCleanedSnapshots(List<String> deepCleanedSnapshots) {
            if (!deepCleanedSnapshots.isEmpty()) {
                ClientId clientId = ClientId.randomId();
                OzoneManagerProtocolProtos.SnapshotPurgeRequest snapshotPurgeRequest = OzoneManagerProtocolProtos.SnapshotPurgeRequest.newBuilder().addAllUpdatedSnapshotDBKey(deepCleanedSnapshots).build();
                OzoneManagerProtocolProtos.OMRequest omRequest = OzoneManagerProtocolProtos.OMRequest.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.SnapshotPurge).setSnapshotPurgeRequest(snapshotPurgeRequest).setClientId(clientId.toString()).build();
                this.submitRequest(omRequest, clientId);
            }
        }

        public void submitRequest(OzoneManagerProtocolProtos.OMRequest omRequest, ClientId clientId) {
            try {
                if (KeyDeletingService.this.isRatisEnabled()) {
                    OzoneManagerRatisServer server = KeyDeletingService.this.getOzoneManager().getOmRatisServer();
                    RaftClientRequest raftClientRequest = RaftClientRequest.newBuilder().setClientId(clientId).setServerId(server.getRaftPeerId()).setGroupId(server.getRaftGroupId()).setCallId(KeyDeletingService.this.getRunCount().get()).setMessage(Message.valueOf((ByteString)OMRatisHelper.convertRequestToByteString((OzoneManagerProtocolProtos.OMRequest)omRequest))).setType(RaftClientRequest.writeRequestType()).build();
                    server.submitRequest(omRequest, raftClientRequest);
                } else {
                    KeyDeletingService.this.getOzoneManager().getOmServerProtocol().submitRequest(null, omRequest);
                }
            }
            catch (ServiceException e) {
                LOG.error("Snapshot deep cleaning request failed. Will retry at next run.", (Throwable)e);
            }
        }
    }
}

