/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.service;

import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.lock.OMLockDetails;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuotaRepairTask {
    private static final Logger LOG = LoggerFactory.getLogger(QuotaRepairTask.class);
    private static final int BATCH_SIZE = 5000;
    private static final int TASK_THREAD_CNT = 3;
    public static final long EPOCH_DEFAULT = -1L;
    private final OMMetadataManager metadataManager;
    private final Map<String, OmBucketInfo> nameBucketInfoMap = new HashMap<String, OmBucketInfo>();
    private final Map<String, OmBucketInfo> idBucketInfoMap = new HashMap<String, OmBucketInfo>();
    private ExecutorService executor;
    private final Map<String, CountPair> keyCountMap = new ConcurrentHashMap<String, CountPair>();
    private final Map<String, CountPair> fileCountMap = new ConcurrentHashMap<String, CountPair>();
    private final Map<String, CountPair> directoryCountMap = new ConcurrentHashMap<String, CountPair>();
    private final Map<String, String> oldVolumeKeyNameMap = new HashMap<String, String>();

    public QuotaRepairTask(OMMetadataManager metadataManager) {
        this.metadataManager = metadataManager;
    }

    public void repair() throws Exception {
        LOG.info("Starting quota repair task");
        this.prepareAllVolumeBucketInfo();
        IOzoneManagerLock lock = this.metadataManager.getLock();
        this.executor = Executors.newFixedThreadPool(12);
        try {
            this.nameBucketInfoMap.values().stream().forEach(e -> {
                OMLockDetails oMLockDetails = lock.acquireReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{e.getVolumeName(), e.getBucketName()});
            });
            this.repairCount();
        }
        catch (Throwable throwable) {
            this.nameBucketInfoMap.values().stream().forEach(e -> {
                OMLockDetails oMLockDetails = lock.releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{e.getVolumeName(), e.getBucketName()});
            });
            this.executor.shutdown();
            LOG.info("Completed quota repair task");
            throw throwable;
        }
        this.nameBucketInfoMap.values().stream().forEach(e -> {
            OMLockDetails oMLockDetails = lock.releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{e.getVolumeName(), e.getBucketName()});
        });
        this.executor.shutdown();
        LOG.info("Completed quota repair task");
        this.updateOldVolumeQuotaSupport();
        ArrayList<Long> epochs = new ArrayList<Long>();
        epochs.add(-1L);
        this.metadataManager.getBucketTable().cleanupCache(epochs);
        this.metadataManager.getVolumeTable().cleanupCache(epochs);
    }

    private void prepareAllVolumeBucketInfo() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TableIterator iterator = this.metadataManager.getVolumeTable().iterator();){
            while (iterator.hasNext()) {
                Table.KeyValue entry = (Table.KeyValue)iterator.next();
                OmVolumeArgs omVolumeArgs = (OmVolumeArgs)entry.getValue();
                this.getAllBuckets(omVolumeArgs.getVolume(), omVolumeArgs.getObjectID());
                if (omVolumeArgs.getQuotaInBytes() != -2L && omVolumeArgs.getQuotaInNamespace() != -2L) continue;
                this.oldVolumeKeyNameMap.put((String)entry.getKey(), ((OmVolumeArgs)entry.getValue()).getVolume());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void updateOldVolumeQuotaSupport() throws IOException {
        LOG.info("Starting volume quota support update");
        IOzoneManagerLock lock = this.metadataManager.getLock();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BatchOperation batchOperation = this.metadataManager.getStore().initBatchOperation();){
            for (Map.Entry<String, String> volEntry : this.oldVolumeKeyNameMap.entrySet()) {
                lock.acquireReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volEntry.getValue()});
                try {
                    OmVolumeArgs omVolumeArgs = (OmVolumeArgs)this.metadataManager.getVolumeTable().get((Object)volEntry.getKey());
                    boolean isQuotaReset = false;
                    if (omVolumeArgs.getQuotaInBytes() == -2L) {
                        omVolumeArgs.setQuotaInBytes(-1L);
                        isQuotaReset = true;
                    }
                    if (omVolumeArgs.getQuotaInNamespace() == -2L) {
                        omVolumeArgs.setQuotaInNamespace(-1L);
                        isQuotaReset = true;
                    }
                    if (isQuotaReset) {
                        this.metadataManager.getVolumeTable().addCacheEntry(new CacheKey((Object)volEntry.getKey()), CacheValue.get((long)-1L, (Object)omVolumeArgs));
                        this.metadataManager.getVolumeTable().putWithBatch(batchOperation, (Object)volEntry.getKey(), (Object)omVolumeArgs);
                    }
                }
                catch (Throwable throwable2) {
                    lock.releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volEntry.getValue()});
                    throw throwable2;
                }
                lock.releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volEntry.getValue()});
            }
            this.metadataManager.getStore().commitBatchOperation(batchOperation);
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        LOG.info("Completed volume quota support update");
    }

    private void getAllBuckets(String volumeName, long volumeId) throws IOException {
        List bucketList = this.metadataManager.listBuckets(volumeName, null, null, Integer.MAX_VALUE, false);
        for (OmBucketInfo bucketInfo : bucketList) {
            bucketInfo.incrUsedNamespace(-bucketInfo.getUsedNamespace());
            bucketInfo.incrUsedBytes(-bucketInfo.getUsedBytes());
            this.nameBucketInfoMap.put(this.buildNamePath(volumeName, bucketInfo.getBucketName()), bucketInfo);
            this.idBucketInfoMap.put(this.buildIdPath(volumeId, bucketInfo.getObjectID()), bucketInfo);
        }
    }

    private String buildNamePath(String volumeName, String bucketName) {
        StringBuilder builder = new StringBuilder();
        builder.append("/").append(volumeName).append("/").append(bucketName).append("/");
        return builder.toString();
    }

    private String buildIdPath(long volumeId, long bucketId) {
        StringBuilder builder = new StringBuilder();
        builder.append("/").append(volumeId).append("/").append(bucketId).append("/");
        return builder.toString();
    }

    private void repairCount() throws Exception {
        LOG.info("Starting quota repair for all keys, files and directories");
        try {
            this.nameBucketInfoMap.keySet().stream().forEach(e -> {
                CountPair countPair = this.keyCountMap.put((String)e, new CountPair());
            });
            this.idBucketInfoMap.keySet().stream().forEach(e -> {
                CountPair countPair = this.fileCountMap.put((String)e, new CountPair());
            });
            this.idBucketInfoMap.keySet().stream().forEach(e -> {
                CountPair countPair = this.directoryCountMap.put((String)e, new CountPair());
            });
            ArrayList tasks = new ArrayList();
            tasks.add(this.executor.submit(() -> this.recalculateUsages(this.metadataManager.getKeyTable(BucketLayout.OBJECT_STORE), this.keyCountMap, "Key usages", true)));
            tasks.add(this.executor.submit(() -> this.recalculateUsages(this.metadataManager.getKeyTable(BucketLayout.FILE_SYSTEM_OPTIMIZED), this.fileCountMap, "File usages", true)));
            tasks.add(this.executor.submit(() -> this.recalculateUsages(this.metadataManager.getDirectoryTable(), this.directoryCountMap, "Directory usages", false)));
            for (Future future : tasks) {
                future.get();
            }
        }
        catch (UncheckedIOException ex) {
            LOG.error("quota repair failure", (Throwable)ex.getCause());
            throw ex.getCause();
        }
        catch (UncheckedExecutionException ex) {
            LOG.error("quota repair failure", ex.getCause());
            throw new Exception(ex.getCause());
        }
        this.updateCountToBucketInfo(this.nameBucketInfoMap, this.keyCountMap);
        this.updateCountToBucketInfo(this.idBucketInfoMap, this.fileCountMap);
        this.updateCountToBucketInfo(this.idBucketInfoMap, this.directoryCountMap);
        this.updateOldBucketQuotaSupport();
        Throwable throwable = null;
        Object throwable2 = null;
        try (BatchOperation batchOperation = this.metadataManager.getStore().initBatchOperation();){
            for (Map.Entry<String, OmBucketInfo> entry : this.nameBucketInfoMap.entrySet()) {
                String bucketKey = this.metadataManager.getBucketKey(entry.getValue().getVolumeName(), entry.getValue().getBucketName());
                this.metadataManager.getBucketTable().putWithBatch(batchOperation, (Object)bucketKey, (Object)entry.getValue());
            }
            this.metadataManager.getStore().commitBatchOperation(batchOperation);
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        LOG.info("Completed quota repair for all keys, files and directories");
    }

    private void updateOldBucketQuotaSupport() {
        for (Map.Entry<String, OmBucketInfo> entry : this.nameBucketInfoMap.entrySet()) {
            if (entry.getValue().getQuotaInBytes() != -2L && entry.getValue().getQuotaInNamespace() != -2L) continue;
            OmBucketInfo.Builder builder = entry.getValue().toBuilder();
            if (entry.getValue().getQuotaInBytes() == -2L) {
                builder.setQuotaInBytes(-1L);
            }
            if (entry.getValue().getQuotaInNamespace() == -2L) {
                builder.setQuotaInNamespace(-1L);
            }
            OmBucketInfo bucketInfo = builder.build();
            entry.setValue(bucketInfo);
            String bucketKey = this.metadataManager.getBucketKey(bucketInfo.getVolumeName(), bucketInfo.getBucketName());
            this.metadataManager.getBucketTable().addCacheEntry(new CacheKey((Object)bucketKey), CacheValue.get((long)-1L, (Object)bucketInfo));
        }
    }

    private <VALUE> void recalculateUsages(Table<String, VALUE> table, Map<String, CountPair> prefixUsageMap, String strType, boolean haveValue) throws UncheckedIOException, UncheckedExecutionException {
        LOG.info("Starting recalculate {}", (Object)strType);
        ArrayList<Table.KeyValue> kvList = new ArrayList<Table.KeyValue>(5000);
        ArrayBlockingQueue<ArrayList<Table.KeyValue>> q = new ArrayBlockingQueue<ArrayList<Table.KeyValue>>(3);
        ArrayList tasks = new ArrayList();
        AtomicBoolean isRunning = new AtomicBoolean(true);
        int i = 0;
        while (i < 3) {
            tasks.add(this.executor.submit(() -> this.captureCount(prefixUsageMap, q, isRunning, haveValue)));
            ++i;
        }
        int count = 0;
        long startTime = System.currentTimeMillis();
        try {
            Throwable throwable = null;
            Object var13_15 = null;
            try (TableIterator keyIter = table.iterator();){
                while (keyIter.hasNext()) {
                    ++count;
                    kvList.add((Table.KeyValue)keyIter.next());
                    if (kvList.size() != 5000) continue;
                    q.put(kvList);
                    kvList = new ArrayList(5000);
                }
                q.put(kvList);
                isRunning.set(false);
                for (Future future : tasks) {
                    future.get();
                }
                LOG.info("Recalculate {} completed, count {} time {}ms", new Object[]{strType, count, System.currentTimeMillis() - startTime});
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException ex) {
            throw new UncheckedExecutionException((Throwable)ex);
        }
    }

    private <VALUE> void captureCount(Map<String, CountPair> prefixUsageMap, BlockingQueue<List<Table.KeyValue<String, VALUE>>> q, AtomicBoolean isRunning, boolean haveValue) throws UncheckedIOException {
        try {
            while (isRunning.get() || !q.isEmpty()) {
                List<Table.KeyValue<String, VALUE>> kvList = q.poll(100L, TimeUnit.MILLISECONDS);
                if (kvList == null) continue;
                for (Table.KeyValue<String, VALUE> kv : kvList) {
                    this.extractCount(kv, prefixUsageMap, haveValue);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private <VALUE> void extractCount(Table.KeyValue<String, VALUE> kv, Map<String, CountPair> prefixUsageMap, boolean haveValue) {
        try {
            Object value;
            String prefix = this.getVolumeBucketPrefix((String)kv.getKey());
            CountPair usage = prefixUsageMap.get(prefix);
            if (usage == null) {
                return;
            }
            usage.incrNamespace(1L);
            if (haveValue && (value = kv.getValue()) instanceof OmKeyInfo) {
                usage.incrSpace(((OmKeyInfo)value).getReplicatedSize());
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private synchronized void updateCountToBucketInfo(Map<String, OmBucketInfo> bucketInfoMap, Map<String, CountPair> prefixUsageMap) {
        for (Map.Entry<String, CountPair> entry : prefixUsageMap.entrySet()) {
            OmBucketInfo omBucketInfo = bucketInfoMap.get(entry.getKey());
            if (omBucketInfo == null) continue;
            omBucketInfo.incrUsedBytes(entry.getValue().getSpace());
            omBucketInfo.incrUsedNamespace(entry.getValue().getNamespace());
        }
    }

    private String getVolumeBucketPrefix(String key) {
        String prefix = key;
        int idx = key.indexOf("/", 1);
        if (idx != -1 && (idx = key.indexOf("/", idx + 1)) != -1) {
            prefix = key.substring(0, idx + 1);
        }
        return prefix;
    }

    private static class CountPair {
        private AtomicLong space = new AtomicLong();
        private AtomicLong namespace = new AtomicLong();

        private CountPair() {
        }

        public void incrSpace(long val) {
            this.space.getAndAdd(val);
        }

        public void incrNamespace(long val) {
            this.namespace.getAndAdd(val);
        }

        public long getSpace() {
            return this.space.get();
        }

        public long getNamespace() {
            return this.namespace.get();
        }
    }
}

