/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocol;
import org.apache.hadoop.hdds.utils.BackgroundTask;
import org.apache.hadoop.hdds.utils.BackgroundTaskQueue;
import org.apache.hadoop.hdds.utils.BackgroundTaskResult;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.ClientVersion;
import org.apache.hadoop.ozone.common.BlockGroup;
import org.apache.hadoop.ozone.lock.BootstrapStateHandler;
import org.apache.hadoop.ozone.om.IOmMetadataReader;
import org.apache.hadoop.ozone.om.KeyManagerImpl;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OmSnapshot;
import org.apache.hadoop.ozone.om.OmSnapshotManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.SnapshotChainManager;
import org.apache.hadoop.ozone.om.helpers.OMRatisHelper;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.ratis.OzoneManagerRatisServer;
import org.apache.hadoop.ozone.om.service.AbstractKeyDeletingService;
import org.apache.hadoop.ozone.om.snapshot.ReferenceCounted;
import org.apache.hadoop.ozone.om.snapshot.SnapshotCache;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.util.Time;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotDeletingService
extends AbstractKeyDeletingService {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotDeletingService.class);
    private static final int SNAPSHOT_DELETING_CORE_POOL_SIZE = 1;
    private static final int MIN_ERR_LIMIT_PER_TASK = 1000;
    private final ClientId clientId = ClientId.randomId();
    private final OzoneManager ozoneManager;
    private final OmSnapshotManager omSnapshotManager;
    private final SnapshotChainManager chainManager;
    private final AtomicBoolean suspended;
    private final OzoneConfiguration conf;
    private final AtomicLong successRunCount;
    private final long snapshotDeletionPerTask;
    private final int keyLimitPerSnapshot;
    private final int ratisByteLimit;

    public SnapshotDeletingService(long interval, long serviceTimeout, OzoneManager ozoneManager, ScmBlockLocationProtocol scmClient) throws IOException {
        super(SnapshotDeletingService.class.getSimpleName(), interval, TimeUnit.MILLISECONDS, 1, serviceTimeout, ozoneManager, scmClient);
        this.ozoneManager = ozoneManager;
        this.omSnapshotManager = ozoneManager.getOmSnapshotManager();
        OmMetadataManagerImpl omMetadataManager = (OmMetadataManagerImpl)ozoneManager.getMetadataManager();
        this.chainManager = omMetadataManager.getSnapshotChainManager();
        this.successRunCount = new AtomicLong(0L);
        this.suspended = new AtomicBoolean(false);
        this.conf = ozoneManager.getConfiguration();
        this.snapshotDeletionPerTask = this.conf.getLong("ozone.snapshot.deleting.limit.per.task", 10L);
        int limit = (int)this.conf.getStorageSize("ozone.om.ratis.log.appender.queue.byte-limit", "32MB", StorageUnit.BYTES);
        this.ratisByteLimit = (int)((double)limit * 0.9);
        this.keyLimitPerSnapshot = this.conf.getInt("ozone.snapshot.key.deleting.limit.per.task", 20000);
    }

    public static boolean shouldIgnoreSnapshot(SnapshotInfo snapInfo, boolean isSstFilteringServiceEnabled) {
        SnapshotInfo.SnapshotStatus snapshotStatus = snapInfo.getSnapshotStatus();
        return snapshotStatus != SnapshotInfo.SnapshotStatus.SNAPSHOT_DELETED || isSstFilteringServiceEnabled && !snapInfo.isSstFiltered();
    }

    public static boolean isBlockLocationInfoSame(OmKeyInfo prevKeyInfo, OmKeyInfo deletedKeyInfo) {
        if (prevKeyInfo == null && deletedKeyInfo == null) {
            LOG.debug("Both prevKeyInfo and deletedKeyInfo are null.");
            return true;
        }
        if (prevKeyInfo == null || deletedKeyInfo == null) {
            LOG.debug("prevKeyInfo: '{}' or deletedKeyInfo: '{}' is null.", (Object)prevKeyInfo, (Object)deletedKeyInfo);
            return false;
        }
        if (prevKeyInfo.isHsync() && deletedKeyInfo.isHsync()) {
            return true;
        }
        if (prevKeyInfo.getKeyLocationVersions().size() != deletedKeyInfo.getKeyLocationVersions().size()) {
            return false;
        }
        OmKeyLocationInfoGroup deletedOmKeyLocation = deletedKeyInfo.getLatestVersionLocations();
        OmKeyLocationInfoGroup prevOmKeyLocation = prevKeyInfo.getLatestVersionLocations();
        if (deletedOmKeyLocation == null || prevOmKeyLocation == null) {
            return false;
        }
        List deletedLocationList = deletedOmKeyLocation.getLocationList();
        List prevLocationList = prevOmKeyLocation.getLocationList();
        if (deletedLocationList.size() != prevLocationList.size()) {
            return false;
        }
        int idx = 0;
        while (idx < deletedLocationList.size()) {
            OmKeyLocationInfo prevLocationInfo;
            OmKeyLocationInfo deletedLocationInfo = (OmKeyLocationInfo)deletedLocationList.get(idx);
            if (!deletedLocationInfo.hasSameBlockAs((Object)(prevLocationInfo = (OmKeyLocationInfo)prevLocationList.get(idx)))) {
                return false;
            }
            ++idx;
        }
        return true;
    }

    public BackgroundTaskQueue getTasks() {
        BackgroundTaskQueue queue = new BackgroundTaskQueue();
        queue.add((BackgroundTask)new SnapshotDeletingTask());
        return queue;
    }

    private boolean shouldRun() {
        return !this.suspended.get() && this.ozoneManager.isLeaderReady();
    }

    @VisibleForTesting
    public void suspend() {
        this.suspended.set(true);
    }

    @VisibleForTesting
    public void resume() {
        this.suspended.set(false);
    }

    public long getSuccessfulRunCount() {
        return this.successRunCount.get();
    }

    @VisibleForTesting
    public void setSuccessRunCount(long num) {
        this.successRunCount.getAndSet(num);
    }

    private class SnapshotDeletingTask
    implements BackgroundTask {
        private SnapshotDeletingTask() {
        }

        public BackgroundTaskResult call() throws InterruptedException {
            ArrayList<String> purgeSnapshotKeys;
            block43: {
                if (!SnapshotDeletingService.this.shouldRun()) {
                    return BackgroundTaskResult.EmptyTaskResult.newResult();
                }
                SnapshotDeletingService.this.getRunCount().incrementAndGet();
                ReferenceCounted<IOmMetadataReader, SnapshotCache> rcOmSnapshot = null;
                ReferenceCounted<IOmMetadataReader, SnapshotCache> rcOmPreviousSnapshot = null;
                Table snapshotInfoTable = SnapshotDeletingService.this.ozoneManager.getMetadataManager().getSnapshotInfoTable();
                purgeSnapshotKeys = new ArrayList<String>();
                try {
                    try {
                        Throwable throwable = null;
                        Object var6_8 = null;
                        try (TableIterator iterator = snapshotInfoTable.iterator();){
                            long snapshotLimit = SnapshotDeletingService.this.snapshotDeletionPerTask;
                            while (iterator.hasNext() && snapshotLimit > 0L) {
                                String dbBucketKeyForDir;
                                boolean isSstFilteringServiceEnabled;
                                SnapshotInfo snapInfo = (SnapshotInfo)((Table.KeyValue)iterator.next()).getValue();
                                if (SnapshotDeletingService.shouldIgnoreSnapshot(snapInfo, isSstFilteringServiceEnabled = ((KeyManagerImpl)SnapshotDeletingService.this.ozoneManager.getKeyManager()).isSstFilteringSvcEnabled())) continue;
                                rcOmSnapshot = SnapshotDeletingService.this.omSnapshotManager.checkForSnapshot(snapInfo.getVolumeName(), snapInfo.getBucketName(), OmSnapshotManager.getSnapshotPrefix(snapInfo.getName()), true);
                                OmSnapshot omSnapshot = (OmSnapshot)rcOmSnapshot.get();
                                Table snapshotDeletedTable = omSnapshot.getMetadataManager().getDeletedTable();
                                Table snapshotDeletedDirTable = omSnapshot.getMetadataManager().getDeletedDirTable();
                                Table renamedTable = omSnapshot.getMetadataManager().getSnapshotRenamedTable();
                                long volumeId = SnapshotDeletingService.this.ozoneManager.getMetadataManager().getVolumeId(snapInfo.getVolumeName());
                                String dbBucketKey = SnapshotDeletingService.this.ozoneManager.getMetadataManager().getBucketKey(snapInfo.getVolumeName(), snapInfo.getBucketName());
                                OmBucketInfo bucketInfo = (OmBucketInfo)SnapshotDeletingService.this.ozoneManager.getMetadataManager().getBucketTable().get((Object)dbBucketKey);
                                if (bucketInfo == null) {
                                    rcOmSnapshot.close();
                                    rcOmSnapshot = null;
                                    throw new IllegalStateException("Bucket /" + snapInfo.getVolumeName() + "/" + snapInfo.getBucketName() + " is not found. BucketInfo should not be null for snapshotted" + " bucket. The OM is in unexpected state.");
                                }
                                String snapshotBucketKey = String.valueOf(dbBucketKey) + "/";
                                if (this.isSnapshotReclaimable((Table<String, RepeatedOmKeyInfo>)snapshotDeletedTable, (Table<String, OmKeyInfo>)snapshotDeletedDirTable, snapshotBucketKey, dbBucketKeyForDir = String.valueOf(SnapshotDeletingService.this.ozoneManager.getMetadataManager().getBucketKey(Long.toString(volumeId), Long.toString(bucketInfo.getObjectID()))) + "/")) {
                                    purgeSnapshotKeys.add(snapInfo.getTableKey());
                                    rcOmSnapshot.close();
                                    rcOmSnapshot = null;
                                    continue;
                                }
                                SnapshotInfo previousSnapshot = SnapshotDeletingService.this.getPreviousActiveSnapshot(snapInfo, SnapshotDeletingService.this.chainManager, SnapshotDeletingService.this.omSnapshotManager);
                                Table previousKeyTable = null;
                                Table previousDirTable = null;
                                OmSnapshot omPreviousSnapshot = null;
                                if (previousSnapshot != null) {
                                    rcOmPreviousSnapshot = SnapshotDeletingService.this.omSnapshotManager.checkForSnapshot(previousSnapshot.getVolumeName(), previousSnapshot.getBucketName(), OmSnapshotManager.getSnapshotPrefix(previousSnapshot.getName()), true);
                                    omPreviousSnapshot = (OmSnapshot)rcOmPreviousSnapshot.get();
                                    previousKeyTable = omPreviousSnapshot.getMetadataManager().getKeyTable(bucketInfo.getBucketLayout());
                                    previousDirTable = omPreviousSnapshot.getMetadataManager().getDirectoryTable();
                                }
                                ArrayList<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos> toReclaimList = new ArrayList<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos>();
                                ArrayList<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos> toNextDBList = new ArrayList<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos>();
                                ArrayList<HddsProtos.KeyValue> renamedList = new ArrayList<HddsProtos.KeyValue>();
                                ArrayList<String> dirsToMove = new ArrayList<String>();
                                long remainNum = this.handleDirectoryCleanUp((Table<String, OmKeyInfo>)snapshotDeletedDirTable, previousDirTable, (Table<String, String>)renamedTable, dbBucketKeyForDir, snapInfo, omSnapshot, dirsToMove, renamedList);
                                int deletionCount = 0;
                                try {
                                    Throwable throwable2 = null;
                                    Object var34_36 = null;
                                    try (TableIterator deletedIterator = snapshotDeletedTable.iterator();){
                                        ArrayList<BlockGroup> keysToPurge = new ArrayList<BlockGroup>();
                                        deletedIterator.seek((Object)snapshotBucketKey);
                                        while (deletedIterator.hasNext() && (long)deletionCount < remainNum) {
                                            Table.KeyValue deletedKeyValue = (Table.KeyValue)deletedIterator.next();
                                            String deletedKey = (String)deletedKeyValue.getKey();
                                            if (!deletedKey.startsWith(snapshotBucketKey)) break;
                                            RepeatedOmKeyInfo repeatedOmKeyInfo = (RepeatedOmKeyInfo)deletedKeyValue.getValue();
                                            OzoneManagerProtocolProtos.SnapshotMoveKeyInfos.Builder toReclaim = OzoneManagerProtocolProtos.SnapshotMoveKeyInfos.newBuilder().setKey(deletedKey);
                                            OzoneManagerProtocolProtos.SnapshotMoveKeyInfos.Builder toNextDb = OzoneManagerProtocolProtos.SnapshotMoveKeyInfos.newBuilder().setKey(deletedKey);
                                            HddsProtos.KeyValue.Builder renamedKey = HddsProtos.KeyValue.newBuilder();
                                            for (OmKeyInfo keyInfo : repeatedOmKeyInfo.getOmKeyInfoList()) {
                                                this.splitRepeatedOmKeyInfo(toReclaim, toNextDb, renamedKey, keyInfo, (Table<String, OmKeyInfo>)previousKeyTable, (Table<String, String>)renamedTable, bucketInfo, volumeId);
                                            }
                                            if (toReclaim.getKeyInfosCount() != repeatedOmKeyInfo.getOmKeyInfoList().size()) {
                                                toReclaimList.add(toReclaim.build());
                                                toNextDBList.add(toNextDb.build());
                                            } else {
                                                List blocksForKeyDelete = omSnapshot.getMetadataManager().getBlocksForKeyDelete(deletedKey);
                                                if (blocksForKeyDelete != null) {
                                                    keysToPurge.addAll(blocksForKeyDelete);
                                                }
                                            }
                                            if (renamedKey.hasKey() && renamedKey.hasValue()) {
                                                renamedList.add(renamedKey.build());
                                            }
                                            ++deletionCount;
                                        }
                                        SnapshotDeletingService.this.processKeyDeletes(keysToPurge, omSnapshot.getKeyManager(), null, snapInfo.getTableKey());
                                        SnapshotDeletingService.this.successRunCount.incrementAndGet();
                                    }
                                    catch (Throwable throwable3) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable3;
                                        } else if (throwable2 != throwable3) {
                                            throwable2.addSuppressed(throwable3);
                                        }
                                        throw throwable2;
                                    }
                                }
                                catch (IOException ex) {
                                    LOG.error("Error while running Snapshot Deleting Service for snapshot " + snapInfo.getTableKey() + " with snapshotId " + snapInfo.getSnapshotId() + ". Processed " + deletionCount + " keys and " + ((long)SnapshotDeletingService.this.keyLimitPerSnapshot - remainNum) + " directories and files", (Throwable)ex);
                                }
                                --snapshotLimit;
                                this.submitSnapshotMoveDeletedKeys(snapInfo, toReclaimList, toNextDBList, renamedList, dirsToMove);
                                if (rcOmPreviousSnapshot == null) continue;
                                rcOmPreviousSnapshot.close();
                                rcOmPreviousSnapshot = null;
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable == null) {
                                throwable = throwable4;
                            } else if (throwable != throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        LOG.error("Error while running Snapshot Deleting Service", (Throwable)e);
                        if (rcOmPreviousSnapshot != null) {
                            rcOmPreviousSnapshot.close();
                        }
                        if (rcOmSnapshot != null) {
                            rcOmSnapshot.close();
                        }
                        break block43;
                    }
                }
                catch (Throwable throwable) {
                    if (rcOmPreviousSnapshot != null) {
                        rcOmPreviousSnapshot.close();
                    }
                    if (rcOmSnapshot != null) {
                        rcOmSnapshot.close();
                    }
                    throw throwable;
                }
                if (rcOmPreviousSnapshot != null) {
                    rcOmPreviousSnapshot.close();
                }
                if (rcOmSnapshot != null) {
                    rcOmSnapshot.close();
                }
            }
            this.submitSnapshotPurgeRequest(purgeSnapshotKeys);
            return BackgroundTaskResult.EmptyTaskResult.newResult();
        }

        private boolean isSnapshotReclaimable(Table<String, RepeatedOmKeyInfo> snapshotDeletedTable, Table<String, OmKeyInfo> snapshotDeletedDirTable, String snapshotBucketKey, String dbBucketKeyForDir) throws IOException {
            TableIterator iterator;
            boolean isDirTableCleanedUp = false;
            boolean isKeyTableCleanedUp = false;
            Throwable throwable = null;
            Object var8_10 = null;
            try {
                iterator = snapshotDeletedTable.iterator();
                try {
                    iterator.seek((Object)snapshotBucketKey);
                    isKeyTableCleanedUp = !iterator.hasNext() || !((String)((Table.KeyValue)iterator.next()).getKey()).startsWith(snapshotBucketKey);
                }
                finally {
                    if (iterator != null) {
                        iterator.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            throwable = null;
            var8_10 = null;
            try {
                iterator = snapshotDeletedDirTable.iterator();
                try {
                    iterator.seek((Object)dbBucketKeyForDir);
                    isDirTableCleanedUp = !iterator.hasNext() || !((String)((Table.KeyValue)iterator.next()).getKey()).startsWith(dbBucketKeyForDir);
                }
                finally {
                    if (iterator != null) {
                        iterator.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            return !(!isDirTableCleanedUp && !snapshotDeletedDirTable.isEmpty() || !isKeyTableCleanedUp && !snapshotDeletedTable.isEmpty());
        }

        private long handleDirectoryCleanUp(Table<String, OmKeyInfo> snapshotDeletedDirTable, Table<String, OmDirectoryInfo> previousDirTable, Table<String, String> renamedTable, String dbBucketKeyForDir, SnapshotInfo snapInfo, OmSnapshot omSnapshot, List<String> dirsToMove, List<HddsProtos.KeyValue> renamedList) {
            long dirNum = 0L;
            long subDirNum = 0L;
            long subFileNum = 0L;
            long remainNum = SnapshotDeletingService.this.keyLimitPerSnapshot;
            int consumedSize = 0;
            ArrayList<OzoneManagerProtocolProtos.PurgePathRequest> purgePathRequestList = new ArrayList<OzoneManagerProtocolProtos.PurgePathRequest>();
            ArrayList<Pair<String, OmKeyInfo>> allSubDirList = new ArrayList<Pair<String, OmKeyInfo>>(SnapshotDeletingService.this.keyLimitPerSnapshot);
            try {
                Throwable throwable = null;
                Object var21_19 = null;
                try (TableIterator deletedDirIterator = snapshotDeletedDirTable.iterator();){
                    long startTime = Time.monotonicNow();
                    deletedDirIterator.seek((Object)dbBucketKeyForDir);
                    while (deletedDirIterator.hasNext()) {
                        Table.KeyValue deletedDir = (Table.KeyValue)deletedDirIterator.next();
                        String deletedDirKey = (String)deletedDir.getKey();
                        if (!deletedDirKey.startsWith(dbBucketKeyForDir)) break;
                        if (this.isDirReclaimable((Table.KeyValue<String, OmKeyInfo>)deletedDir, previousDirTable, renamedTable, renamedList)) {
                            OzoneManagerProtocolProtos.PurgePathRequest request = SnapshotDeletingService.this.prepareDeleteDirRequest(remainNum, (OmKeyInfo)deletedDir.getValue(), (String)deletedDir.getKey(), allSubDirList, omSnapshot.getKeyManager());
                            if (SnapshotDeletingService.this.isBufferLimitCrossed(SnapshotDeletingService.this.ratisByteLimit, consumedSize, request.getSerializedSize())) {
                                if (purgePathRequestList.size() != 0) {
                                    remainNum = 0L;
                                    break;
                                }
                                remainNum = 1000L;
                                request = SnapshotDeletingService.this.prepareDeleteDirRequest(remainNum, (OmKeyInfo)deletedDir.getValue(), (String)deletedDir.getKey(), allSubDirList, omSnapshot.getKeyManager());
                            }
                            consumedSize += request.getSerializedSize();
                            purgePathRequestList.add(request);
                            remainNum -= (long)request.getDeletedSubFilesCount();
                            remainNum -= (long)request.getMarkDeletedSubDirsCount();
                            if (request.getDeletedDir() != null && !request.getDeletedDir().isEmpty()) {
                                ++dirNum;
                            }
                            subDirNum += (long)request.getMarkDeletedSubDirsCount();
                            subFileNum += (long)request.getDeletedSubFilesCount();
                            continue;
                        }
                        dirsToMove.add((String)deletedDir.getKey());
                    }
                    remainNum = SnapshotDeletingService.this.optimizeDirDeletesAndSubmitRequest(remainNum, dirNum, subDirNum, subFileNum, allSubDirList, purgePathRequestList, snapInfo.getTableKey(), startTime, SnapshotDeletingService.this.ratisByteLimit - consumedSize, omSnapshot.getKeyManager());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOG.error("Error while running delete directories and files for snapshot " + snapInfo.getTableKey() + " in snapshot deleting " + "background task. Will retry at next run.", (Throwable)e);
            }
            return remainNum;
        }

        private void submitSnapshotPurgeRequest(List<String> purgeSnapshotKeys) {
            if (!purgeSnapshotKeys.isEmpty()) {
                OzoneManagerProtocolProtos.SnapshotPurgeRequest snapshotPurgeRequest = OzoneManagerProtocolProtos.SnapshotPurgeRequest.newBuilder().addAllSnapshotDBKeys(purgeSnapshotKeys).build();
                OzoneManagerProtocolProtos.OMRequest omRequest = OzoneManagerProtocolProtos.OMRequest.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.SnapshotPurge).setSnapshotPurgeRequest(snapshotPurgeRequest).setClientId(SnapshotDeletingService.this.clientId.toString()).build();
                this.submitRequest(omRequest);
            }
        }

        private void splitRepeatedOmKeyInfo(OzoneManagerProtocolProtos.SnapshotMoveKeyInfos.Builder toReclaim, OzoneManagerProtocolProtos.SnapshotMoveKeyInfos.Builder toNextDb, HddsProtos.KeyValue.Builder renamedKey, OmKeyInfo keyInfo, Table<String, OmKeyInfo> previousKeyTable, Table<String, String> renamedTable, OmBucketInfo bucketInfo, long volumeId) throws IOException {
            if (SnapshotDeletingService.this.isKeyReclaimable(previousKeyTable, renamedTable, keyInfo, bucketInfo, volumeId, renamedKey)) {
                toReclaim.addKeyInfos(keyInfo.getProtobuf(ClientVersion.CURRENT_VERSION));
            } else {
                toNextDb.addKeyInfos(keyInfo.getProtobuf(ClientVersion.CURRENT_VERSION));
            }
        }

        private boolean isDirReclaimable(Table.KeyValue<String, OmKeyInfo> deletedDir, Table<String, OmDirectoryInfo> previousDirTable, Table<String, String> renamedTable, List<HddsProtos.KeyValue> renamedList) throws IOException {
            if (previousDirTable == null) {
                return true;
            }
            String deletedDirDbKey = (String)deletedDir.getKey();
            OmKeyInfo deletedDirInfo = (OmKeyInfo)deletedDir.getValue();
            String dbRenameKey = SnapshotDeletingService.this.ozoneManager.getMetadataManager().getRenameKey(deletedDirInfo.getVolumeName(), deletedDirInfo.getBucketName(), deletedDirInfo.getObjectID());
            String dbKeyBeforeRename = (String)renamedTable.getIfExist((Object)dbRenameKey);
            String prevDbKey = null;
            if (dbKeyBeforeRename != null) {
                prevDbKey = dbKeyBeforeRename;
                HddsProtos.KeyValue renamedDir = HddsProtos.KeyValue.newBuilder().setKey(dbRenameKey).setValue(dbKeyBeforeRename).build();
                renamedList.add(renamedDir);
            } else {
                prevDbKey = SnapshotDeletingService.this.ozoneManager.getMetadataManager().getOzoneDeletePathDirKey(deletedDirDbKey);
            }
            OmDirectoryInfo prevDirectoryInfo = (OmDirectoryInfo)previousDirTable.get((Object)prevDbKey);
            if (prevDirectoryInfo == null) {
                return true;
            }
            return prevDirectoryInfo.getObjectID() != deletedDirInfo.getObjectID();
        }

        public void submitSnapshotMoveDeletedKeys(SnapshotInfo snapInfo, List<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos> toReclaimList, List<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos> toNextDBList, List<HddsProtos.KeyValue> renamedList, List<String> dirsToMove) throws InterruptedException {
            OzoneManagerProtocolProtos.SnapshotMoveDeletedKeysRequest.Builder moveDeletedKeysBuilder = OzoneManagerProtocolProtos.SnapshotMoveDeletedKeysRequest.newBuilder().setFromSnapshot(snapInfo.getProtobuf());
            OzoneManagerProtocolProtos.SnapshotMoveDeletedKeysRequest moveDeletedKeys = moveDeletedKeysBuilder.addAllReclaimKeys(toReclaimList).addAllNextDBKeys(toNextDBList).addAllRenamedKeys(renamedList).addAllDeletedDirsToMove(dirsToMove).build();
            OzoneManagerProtocolProtos.OMRequest omRequest = OzoneManagerProtocolProtos.OMRequest.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.SnapshotMoveDeletedKeys).setSnapshotMoveDeletedKeysRequest(moveDeletedKeys).setClientId(SnapshotDeletingService.this.clientId.toString()).build();
            Throwable throwable = null;
            Object var10_11 = null;
            try (BootstrapStateHandler.Lock lock = new BootstrapStateHandler.Lock();){
                this.submitRequest(omRequest);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        public void submitRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
            try {
                if (SnapshotDeletingService.this.isRatisEnabled()) {
                    OzoneManagerRatisServer server = SnapshotDeletingService.this.ozoneManager.getOmRatisServer();
                    RaftClientRequest raftClientRequest = RaftClientRequest.newBuilder().setClientId(SnapshotDeletingService.this.clientId).setServerId(server.getRaftPeerId()).setGroupId(server.getRaftGroupId()).setCallId(SnapshotDeletingService.this.getRunCount().get()).setMessage(Message.valueOf((ByteString)OMRatisHelper.convertRequestToByteString((OzoneManagerProtocolProtos.OMRequest)omRequest))).setType(RaftClientRequest.writeRequestType()).build();
                    server.submitRequest(omRequest, raftClientRequest);
                } else {
                    SnapshotDeletingService.this.ozoneManager.getOmServerProtocol().submitRequest(null, omRequest);
                }
            }
            catch (ServiceException e) {
                LOG.error("Snapshot Deleting request failed. Will retry at next run.", (Throwable)e);
            }
        }
    }
}

