/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.snapshot;

import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.snapshot.RequireSnapshotFeatureState;
import org.apache.hadoop.ozone.protocolPB.OzoneManagerRequestHandler;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class RequireSnapshotFeatureStateAspect {
    private static final Logger LOG = LoggerFactory.getLogger(RequireSnapshotFeatureStateAspect.class);

    @Before(value="@annotation(RequireSnapshotFeatureState) && execution(* *(..))")
    public void checkFeatureState(JoinPoint joinPoint) throws IOException {
        boolean isFeatureEnabled;
        boolean desiredFeatureState = ((MethodSignature)joinPoint.getSignature()).getMethod().getAnnotation(RequireSnapshotFeatureState.class).value();
        Object[] args = joinPoint.getArgs();
        if (LOG.isDebugEnabled()) {
            LOG.debug("joinPoint.getTarget() = {}", joinPoint.getTarget());
        }
        if (joinPoint.getTarget() instanceof OzoneManagerRequestHandler) {
            OzoneManager ozoneManager = ((OzoneManagerRequestHandler)joinPoint.getTarget()).getOzoneManager();
            isFeatureEnabled = ozoneManager.isFilesystemSnapshotEnabled();
        } else if (joinPoint.getTarget() instanceof OMClientRequest && joinPoint.toShortString().endsWith(".preExecute(..))")) {
            OzoneManager ozoneManager = (OzoneManager)args[0];
            isFeatureEnabled = ozoneManager.isFilesystemSnapshotEnabled();
        } else {
            try {
                Method method = joinPoint.getTarget().getClass().getMethod("isFilesystemSnapshotEnabled", new Class[0]);
                isFeatureEnabled = (Boolean)method.invoke(joinPoint.getTarget(), new Object[0]);
            }
            catch (Exception exception) {
                throw new NotImplementedException("Unhandled use case. Please implement.");
            }
        }
        this.checkIsAllowed(joinPoint.getSignature().toShortString(), isFeatureEnabled, desiredFeatureState);
    }

    private void checkIsAllowed(String operationName, boolean isFeatureEnabled, boolean desiredFeatureState) throws OMException {
        if (desiredFeatureState) {
            if (!isFeatureEnabled) {
                throw new OMException(String.format("Operation %s cannot be invoked because %s.", operationName, "Ozone snapshot feature is disabled"), OMException.ResultCodes.FEATURE_NOT_ENABLED);
            }
            return;
        }
        throw new NotImplementedException("Check not implemented for case: isFeatureEnabled=" + isFeatureEnabled + ", desiredFeatureState=" + desiredFeatureState);
    }

    public static RequireSnapshotFeatureStateAspect aspectOf() {
        return new RequireSnapshotFeatureStateAspect();
    }
}

