/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.snapshot;

import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.CodecRegistry;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksDB;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksIterator;
import org.apache.hadoop.ozone.om.snapshot.PersistentSet;
import org.apache.hadoop.util.ClosableIterator;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;

public class RocksDbPersistentSet<E>
implements PersistentSet<E> {
    private final ManagedRocksDB db;
    private final ColumnFamilyHandle columnFamilyHandle;
    private final CodecRegistry codecRegistry;
    private final Class<E> entryType;
    private final byte[] emptyByteArray = new byte[0];

    public RocksDbPersistentSet(ManagedRocksDB db, ColumnFamilyHandle columnFamilyHandle, CodecRegistry codecRegistry, Class<E> entryType) {
        this.db = db;
        this.columnFamilyHandle = columnFamilyHandle;
        this.codecRegistry = codecRegistry;
        this.entryType = entryType;
    }

    @Override
    public void add(E entry) {
        try {
            byte[] rawKey = this.codecRegistry.asRawData(entry);
            byte[] rawValue = this.codecRegistry.asRawData((Object)this.emptyByteArray);
            ((RocksDB)this.db.get()).put(this.columnFamilyHandle, rawKey, rawValue);
        }
        catch (IOException | RocksDBException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public ClosableIterator<E> iterator() {
        final ManagedRocksIterator managedRocksIterator = new ManagedRocksIterator(((RocksDB)this.db.get()).newIterator(this.columnFamilyHandle));
        ((RocksIterator)managedRocksIterator.get()).seekToFirst();
        return new ClosableIterator<E>(){

            public boolean hasNext() {
                return ((RocksIterator)managedRocksIterator.get()).isValid();
            }

            public E next() {
                byte[] rawKey = ((RocksIterator)managedRocksIterator.get()).key();
                ((RocksIterator)managedRocksIterator.get()).next();
                try {
                    return RocksDbPersistentSet.this.codecRegistry.asObject(rawKey, RocksDbPersistentSet.this.entryType);
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
            }

            public void close() {
                managedRocksIterator.close();
            }
        };
    }
}

