/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.snapshot;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.utils.NativeLibraryNotLoadedException;
import org.apache.hadoop.hdds.utils.db.CodecRegistry;
import org.apache.hadoop.hdds.utils.db.RDBStore;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.managed.ManagedColumnFamilyOptions;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksDB;
import org.apache.hadoop.hdds.utils.db.managed.ManagedSSTDumpTool;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.ozone.OFSPath;
import org.apache.hadoop.ozone.OzoneConsts;
import org.apache.hadoop.ozone.om.OMConfigKeys;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OmSnapshot;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.SnapshotDiffJob;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.helpers.WithObjectID;
import org.apache.hadoop.ozone.om.helpers.WithParentObjectId;
import org.apache.hadoop.ozone.om.service.SnapshotDeletingService;
import org.apache.hadoop.ozone.om.snapshot.FSODirectoryPathResolver;
import org.apache.hadoop.ozone.om.snapshot.PersistentList;
import org.apache.hadoop.ozone.om.snapshot.PersistentMap;
import org.apache.hadoop.ozone.om.snapshot.RocksDbPersistentList;
import org.apache.hadoop.ozone.om.snapshot.RocksDbPersistentMap;
import org.apache.hadoop.ozone.om.snapshot.SnapshotCache;
import org.apache.hadoop.ozone.om.snapshot.SnapshotUtils;
import org.apache.hadoop.ozone.snapshot.CancelSnapshotDiffResponse;
import org.apache.hadoop.ozone.snapshot.SnapshotDiffReportOzone;
import org.apache.hadoop.ozone.snapshot.SnapshotDiffResponse;
import org.apache.hadoop.util.ClosableIterator;
import org.apache.logging.log4j.util.Strings;
import org.apache.ozone.rocksdb.util.ManagedSstFileReader;
import org.apache.ozone.rocksdb.util.RdbUtil;
import org.apache.ozone.rocksdiff.DifferSnapshotInfo;
import org.apache.ozone.rocksdiff.RocksDBCheckpointDiffer;
import org.apache.ozone.rocksdiff.RocksDiffUtils;
import org.jetbrains.annotations.NotNull;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotDiffManager
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotDiffManager.class);
    private static final String FROM_SNAP_TABLE_SUFFIX = "-from-snap";
    private static final String TO_SNAP_TABLE_SUFFIX = "-to-snap";
    private static final String UNIQUE_IDS_TABLE_SUFFIX = "-unique-ids";
    private static final String DELETE_DIFF_TABLE_SUFFIX = "-delete-diff";
    private static final String RENAME_DIFF_TABLE_SUFFIX = "-rename-diff";
    private static final String CREATE_DIFF_TABLE_SUFFIX = "-create-diff";
    private static final String MODIFY_DIFF_TABLE_SUFFIX = "-modify-diff";
    private final ManagedRocksDB db;
    private final RocksDBCheckpointDiffer differ;
    private final OzoneManager ozoneManager;
    private final SnapshotCache snapshotCache;
    private final CodecRegistry codecRegistry;
    private final ManagedColumnFamilyOptions familyOptions;
    private final long defaultWaitTime;
    private final long maxAllowedKeyChangesForASnapDiff;
    private final PersistentMap<byte[], byte[]> snapDiffReportTable;
    private final PersistentMap<String, SnapshotDiffJob> snapDiffJobTable;
    private final ExecutorService snapDiffExecutor;
    private final String sstBackupDirForSnapDiffJobs;
    private final boolean snapshotForceFullDiff;
    private final boolean diffDisableNativeLibs;
    private final Optional<ManagedSSTDumpTool> sstDumpTool;
    private Optional<ExecutorService> sstDumpToolExecService;
    private final BiFunction<SnapshotInfo, SnapshotInfo, String> generateSnapDiffJobKey = (fromSnapshotInfo, toSnapshotInfo) -> fromSnapshotInfo.getSnapshotId() + "-" + toSnapshotInfo.getSnapshotId();

    public SnapshotDiffManager(ManagedRocksDB db, RocksDBCheckpointDiffer differ, OzoneManager ozoneManager, SnapshotCache snapshotCache, ColumnFamilyHandle snapDiffJobCfh, ColumnFamilyHandle snapDiffReportCfh, ManagedColumnFamilyOptions familyOptions, CodecRegistry codecRegistry) {
        this.db = db;
        this.differ = differ;
        this.ozoneManager = ozoneManager;
        this.snapshotCache = snapshotCache;
        this.familyOptions = familyOptions;
        this.codecRegistry = codecRegistry;
        this.defaultWaitTime = ozoneManager.getConfiguration().getTimeDuration("ozone.om.snapshot.diff.job.default.wait.time", OMConfigKeys.OZONE_OM_SNAPSHOT_DIFF_JOB_DEFAULT_WAIT_TIME_DEFAULT, TimeUnit.MILLISECONDS);
        this.snapshotForceFullDiff = ozoneManager.getConfiguration().getBoolean("ozone.om.snapshot.force.full.diff", false);
        this.diffDisableNativeLibs = ozoneManager.getConfiguration().getBoolean("ozone.om.snapshot.diff.disable.native.libs", false);
        this.maxAllowedKeyChangesForASnapDiff = ozoneManager.getConfiguration().getLong("ozone.om.snapshot.diff.max.allowed.keys.changed.per.job", 10000000L);
        int threadPoolSize = ozoneManager.getConfiguration().getInt("ozone.om.snapshot.diff.thread.pool.size", 10);
        this.snapDiffJobTable = new RocksDbPersistentMap<String, SnapshotDiffJob>(db, snapDiffJobCfh, codecRegistry, String.class, SnapshotDiffJob.class);
        this.snapDiffReportTable = new RocksDbPersistentMap<byte[], byte[]>(db, snapDiffReportCfh, codecRegistry, byte[].class, byte[].class);
        this.snapDiffExecutor = new ThreadPoolExecutor(threadPoolSize, threadPoolSize, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(threadPoolSize), new ThreadFactoryBuilder().setNameFormat(String.valueOf(ozoneManager.getThreadNamePrefix()) + "snapshot-diff-job-thread-id-%d").build());
        RDBStore rdbStore = (RDBStore)ozoneManager.getMetadataManager().getStore();
        Objects.requireNonNull(rdbStore, "DBStore can't be null.");
        Path path = Paths.get(rdbStore.getSnapshotMetadataDir(), "snapDiff");
        this.createEmptySnapDiffDir(path);
        this.sstBackupDirForSnapDiffJobs = path.toString();
        this.sstDumpTool = this.initSSTDumpTool(ozoneManager.getConfiguration());
        this.loadJobsOnStartUp();
    }

    @VisibleForTesting
    public PersistentMap<String, SnapshotDiffJob> getSnapDiffJobTable() {
        return this.snapDiffJobTable;
    }

    private Optional<ManagedSSTDumpTool> initSSTDumpTool(OzoneConfiguration conf) {
        if (conf.getBoolean("ozone.om.snapshot.load.native.lib", true)) {
            try {
                int threadPoolSize = conf.getInt("ozone.om.snapshot.sst_dumptool.pool.size", 1);
                int bufferSize = (int)conf.getStorageSize("ozone.om.snapshot.sst_dumptool.buffer.size", "8KB", StorageUnit.BYTES);
                this.sstDumpToolExecService = Optional.of(new ThreadPoolExecutor(0, threadPoolSize, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat(String.valueOf(this.ozoneManager.getThreadNamePrefix()) + "snapshot-diff-manager-sst-dump-tool-TID-%d").build(), new ThreadPoolExecutor.DiscardPolicy()));
                return Optional.of(new ManagedSSTDumpTool(this.sstDumpToolExecService.get(), bufferSize));
            }
            catch (NativeLibraryNotLoadedException nativeLibraryNotLoadedException) {
                this.sstDumpToolExecService.ifPresent(exec -> this.closeExecutorService((ExecutorService)exec, "SstDumpToolExecutor"));
            }
        }
        return Optional.empty();
    }

    private void createEmptySnapDiffDir(Path path) {
        try {
            if (Files.exists(path, new LinkOption[0])) {
                PathUtils.deleteDirectory((Path)path);
            }
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't delete existing or create new directory for:" + path, e);
        }
        Path readmePath = Paths.get(path.toString(), "_README.txt");
        File readmeFile = new File(readmePath.toString());
        if (!readmeFile.exists()) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (BufferedWriter bw = Files.newBufferedWriter(readmePath, StandardOpenOption.CREATE);){
                    bw.write("This directory is used to store SST files needed to generate snap diff report for a particular job.\n DO NOT add, change or delete any files in this directory unless you know what you are doing.\n");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void deleteDir(Path path) {
        if (path == null || Files.notExists(path, new LinkOption[0])) {
            return;
        }
        try {
            PathUtils.deleteDirectory((Path)path);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private DifferSnapshotInfo getDSIFromSI(SnapshotInfo snapshotInfo, OmSnapshot omSnapshot, String volumeName, String bucketName) throws IOException {
        OMMetadataManager snapshotOMMM = omSnapshot.getMetadataManager();
        String checkpointPath = snapshotOMMM.getStore().getDbLocation().getPath();
        UUID snapshotId = snapshotInfo.getSnapshotId();
        long dbTxSequenceNumber = snapshotInfo.getDbTxSequenceNumber();
        return new DifferSnapshotInfo(checkpointPath, snapshotId, dbTxSequenceNumber, SnapshotUtils.getColumnFamilyToKeyPrefixMap(snapshotOMMM, volumeName, bucketName), ((RDBStore)snapshotOMMM.getStore()).getDb().getManagedRocksDb());
    }

    @VisibleForTesting
    protected Set<String> getSSTFileListForSnapshot(OmSnapshot snapshot, List<String> tablesToLookUp) {
        return RdbUtil.getSSTFilesForComparison((ManagedRocksDB)((RDBStore)snapshot.getMetadataManager().getStore()).getDb().getManagedRocksDb(), tablesToLookUp);
    }

    static String getReportKeyForIndex(String jobId, long index) {
        return String.valueOf(jobId) + "-" + org.apache.commons.lang3.StringUtils.leftPad((String)String.valueOf(index), (int)20, (char)'0');
    }

    public CancelSnapshotDiffResponse cancelSnapshotDiff(String volumeName, String bucketName, String fromSnapshotName, String toSnapshotName) throws IOException {
        String reason;
        SnapshotInfo tsInfo;
        SnapshotInfo fsInfo = SnapshotUtils.getSnapshotInfo(this.ozoneManager, volumeName, bucketName, fromSnapshotName);
        String diffJobKey = this.generateSnapDiffJobKey.apply(fsInfo, tsInfo = SnapshotUtils.getSnapshotInfo(this.ozoneManager, volumeName, bucketName, toSnapshotName));
        SnapshotDiffJob diffJob = this.snapDiffJobTable.get(diffJobKey);
        if (diffJob == null) {
            return new CancelSnapshotDiffResponse(CancelSnapshotDiffResponse.CancelMessage.CANCEL_JOB_NOT_EXIST.getMessage());
        }
        switch (diffJob.getStatus()) {
            case IN_PROGRESS: {
                try {
                    this.updateJobStatus(diffJobKey, SnapshotDiffResponse.JobStatus.IN_PROGRESS, SnapshotDiffResponse.JobStatus.CANCELLED);
                    reason = CancelSnapshotDiffResponse.CancelMessage.CANCEL_SUCCEEDED.getMessage();
                }
                catch (IllegalStateException exception) {
                    LOG.warn("Failed to update the job status.", (Throwable)exception);
                    reason = CancelSnapshotDiffResponse.CancelMessage.CANCEL_FAILED.getMessage();
                }
                break;
            }
            case DONE: {
                reason = CancelSnapshotDiffResponse.CancelMessage.CANCEL_ALREADY_DONE_JOB.getMessage();
                break;
            }
            case CANCELLED: {
                reason = CancelSnapshotDiffResponse.CancelMessage.CANCEL_ALREADY_CANCELLED_JOB.getMessage();
                break;
            }
            case FAILED: {
                reason = CancelSnapshotDiffResponse.CancelMessage.CANCEL_ALREADY_FAILED_JOB.getMessage();
                break;
            }
            default: {
                reason = String.valueOf(CancelSnapshotDiffResponse.CancelMessage.CANCEL_NON_CANCELLABLE.getMessage()) + "Current status: " + diffJob.getStatus();
            }
        }
        return new CancelSnapshotDiffResponse(reason);
    }

    public List<SnapshotDiffJob> getSnapshotDiffJobList(String volumeName, String bucketName, String jobStatus, boolean listAll) throws IOException {
        ArrayList<SnapshotDiffJob> jobList = new ArrayList<SnapshotDiffJob>();
        Throwable throwable = null;
        Object var7_8 = null;
        try (ClosableIterator<Map.Entry<String, SnapshotDiffJob>> iterator = this.snapDiffJobTable.iterator();){
            while (iterator.hasNext()) {
                SnapshotDiffJob snapshotDiffJob = (SnapshotDiffJob)((Map.Entry)iterator.next()).getValue();
                if (!Objects.equals(snapshotDiffJob.getVolume(), volumeName) || !Objects.equals(snapshotDiffJob.getBucket(), bucketName)) continue;
                if (listAll) {
                    jobList.add(snapshotDiffJob);
                    continue;
                }
                if (!Objects.equals(snapshotDiffJob.getStatus(), this.getJobStatus(jobStatus))) continue;
                jobList.add(snapshotDiffJob);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return jobList;
    }

    private SnapshotDiffResponse.JobStatus getJobStatus(String jobStatus) throws IOException {
        try {
            return SnapshotDiffResponse.JobStatus.valueOf((String)jobStatus.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            LOG.info(ex.toString());
            throw new IOException("Invalid job status: " + jobStatus);
        }
    }

    public SnapshotDiffResponse getSnapshotDiffReport(String volumeName, String bucketName, String fromSnapshotName, String toSnapshotName, int index, int pageSize, boolean forceFullDiff, boolean disableNativeDiff) throws IOException {
        SnapshotInfo fsInfo = SnapshotUtils.getSnapshotInfo(this.ozoneManager, volumeName, bucketName, fromSnapshotName);
        SnapshotInfo tsInfo = SnapshotUtils.getSnapshotInfo(this.ozoneManager, volumeName, bucketName, toSnapshotName);
        String snapDiffJobKey = this.generateSnapDiffJobKey.apply(fsInfo, tsInfo);
        SnapshotDiffJob snapDiffJob = this.getSnapDiffReportStatus(snapDiffJobKey, volumeName, bucketName, fromSnapshotName, toSnapshotName, forceFullDiff, disableNativeDiff);
        OFSPath snapshotRoot = SnapshotDiffManager.getSnapshotRootPath(volumeName, bucketName);
        switch (snapDiffJob.getStatus()) {
            case QUEUED: {
                return this.submitSnapDiffJob(snapDiffJobKey, volumeName, bucketName, fromSnapshotName, toSnapshotName, index, pageSize, forceFullDiff, disableNativeDiff);
            }
            case IN_PROGRESS: {
                return new SnapshotDiffResponse(new SnapshotDiffReportOzone(snapshotRoot.toString(), volumeName, bucketName, fromSnapshotName, toSnapshotName, new ArrayList(), null), SnapshotDiffResponse.JobStatus.IN_PROGRESS, this.defaultWaitTime);
            }
            case FAILED: {
                return new SnapshotDiffResponse(new SnapshotDiffReportOzone(snapshotRoot.toString(), volumeName, bucketName, fromSnapshotName, toSnapshotName, new ArrayList(), null), SnapshotDiffResponse.JobStatus.FAILED, this.ozoneManager.getOmSnapshotManager().getDiffCleanupServiceInterval(), snapDiffJob.getReason());
            }
            case DONE: {
                SnapshotDiffReportOzone report = this.createPageResponse(snapDiffJob, volumeName, bucketName, fromSnapshotName, toSnapshotName, index, pageSize);
                return new SnapshotDiffResponse(report, SnapshotDiffResponse.JobStatus.DONE, 0L);
            }
            case REJECTED: {
                return new SnapshotDiffResponse(new SnapshotDiffReportOzone(snapshotRoot.toString(), volumeName, bucketName, fromSnapshotName, toSnapshotName, new ArrayList(), null), SnapshotDiffResponse.JobStatus.REJECTED, this.defaultWaitTime);
            }
            case CANCELLED: {
                return new SnapshotDiffResponse(new SnapshotDiffReportOzone(snapshotRoot.toString(), volumeName, bucketName, fromSnapshotName, toSnapshotName, new ArrayList(), null), SnapshotDiffResponse.JobStatus.CANCELLED, 0L);
            }
        }
        throw new IllegalStateException("Unknown snapshot job status: " + snapDiffJob.getStatus());
    }

    @NotNull
    public static OFSPath getSnapshotRootPath(String volume, String bucket) {
        org.apache.hadoop.fs.Path bucketPath = new org.apache.hadoop.fs.Path("/" + volume + "/" + bucket);
        return new OFSPath(bucketPath, new OzoneConfiguration());
    }

    @VisibleForTesting
    SnapshotDiffReportOzone createPageResponse(SnapshotDiffJob snapDiffJob, String volumeName, String bucketName, String fromSnapshotName, String toSnapshotName, int index, int pageSize) throws IOException {
        if (index < 0 || (long)index > snapDiffJob.getTotalDiffEntries() || pageSize <= 0) {
            throw new IOException(String.format("Index (given: %d) should be a number >= 0 and < totalDiffEntries: %d. Page size (given: %d) should be a positive number > 0.", index, snapDiffJob.getTotalDiffEntries(), pageSize));
        }
        OFSPath path = SnapshotDiffManager.getSnapshotRootPath(volumeName, bucketName);
        Pair<List<SnapshotDiffReport.DiffReportEntry>, String> pageResponse = this.createPageResponse(snapDiffJob, index, pageSize);
        List diffReportList = (List)pageResponse.getLeft();
        String tokenString = (String)pageResponse.getRight();
        return new SnapshotDiffReportOzone(path.toString(), volumeName, bucketName, fromSnapshotName, toSnapshotName, diffReportList, tokenString);
    }

    Pair<List<SnapshotDiffReport.DiffReportEntry>, String> createPageResponse(SnapshotDiffJob snapDiffJob, int index, int pageSize) throws IOException {
        ArrayList<SnapshotDiffReport.DiffReportEntry> diffReportList = new ArrayList<SnapshotDiffReport.DiffReportEntry>();
        boolean hasMoreEntries = true;
        byte[] lowerIndex = this.codecRegistry.asRawData((Object)SnapshotDiffManager.getReportKeyForIndex(snapDiffJob.getJobId(), index));
        byte[] upperIndex = this.codecRegistry.asRawData((Object)SnapshotDiffManager.getReportKeyForIndex(snapDiffJob.getJobId(), index + pageSize));
        int idx = index;
        Throwable throwable = null;
        Object var10_11 = null;
        try (ClosableIterator<Map.Entry<byte[], byte[]>> iterator = this.snapDiffReportTable.iterator(Optional.of(lowerIndex), Optional.of(upperIndex));){
            int itemsFetched = 0;
            while (iterator.hasNext() && itemsFetched < pageSize) {
                Map.Entry entry = (Map.Entry)iterator.next();
                byte[] bytes = (byte[])entry.getValue();
                diffReportList.add((SnapshotDiffReport.DiffReportEntry)this.codecRegistry.asObject(bytes, SnapshotDiffReport.DiffReportEntry.class));
                ++idx;
                ++itemsFetched;
            }
            if (diffReportList.size() < pageSize) {
                hasMoreEntries = false;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String nextTokenString = hasMoreEntries ? String.valueOf(idx) : null;
        this.checkReportsIntegrity(snapDiffJob, index, diffReportList.size());
        return Pair.of(diffReportList, (Object)nextTokenString);
    }

    @VisibleForTesting
    void checkReportsIntegrity(SnapshotDiffJob diffJob, int pageStartIdx, int numberOfEntriesInPage) throws IOException {
        if ((long)pageStartIdx >= diffJob.getTotalDiffEntries() && numberOfEntriesInPage != 0 || (long)pageStartIdx < diffJob.getTotalDiffEntries() && numberOfEntriesInPage == 0) {
            LOG.error("Expected TotalDiffEntries: {} but found TotalDiffEntries: {}", (Object)diffJob.getTotalDiffEntries(), (Object)(pageStartIdx + numberOfEntriesInPage));
            this.updateJobStatus(diffJob.getJobId(), SnapshotDiffResponse.JobStatus.DONE, SnapshotDiffResponse.JobStatus.FAILED);
            throw new IOException("Report integrity check failed. Retry after: " + this.ozoneManager.getOmSnapshotManager().getDiffCleanupServiceInterval());
        }
    }

    private synchronized SnapshotDiffResponse submitSnapDiffJob(String jobKey, String volume, String bucket, String fromSnapshot, String toSnapshot, int index, int pageSize, boolean forceFullDiff, boolean disableNativeDiff) throws IOException {
        SnapshotDiffJob snapDiffJob = this.snapDiffJobTable.get(jobKey);
        OFSPath snapshotRoot = SnapshotDiffManager.getSnapshotRootPath(volume, bucket);
        if (snapDiffJob == null) {
            LOG.info("Snap diff job has been removed for volume: {}, bucket: {}, fromSnapshot: {} and toSnapshot: {}.", new Object[]{volume, bucket, fromSnapshot, toSnapshot});
            return new SnapshotDiffResponse(new SnapshotDiffReportOzone(snapshotRoot.toString(), volume, bucket, fromSnapshot, toSnapshot, new ArrayList(), null), SnapshotDiffResponse.JobStatus.REJECTED, this.defaultWaitTime);
        }
        if (snapDiffJob.getStatus() != SnapshotDiffResponse.JobStatus.QUEUED) {
            if (snapDiffJob.getStatus() == SnapshotDiffResponse.JobStatus.DONE) {
                SnapshotDiffReportOzone report = this.createPageResponse(snapDiffJob, volume, bucket, fromSnapshot, toSnapshot, index, pageSize);
                return new SnapshotDiffResponse(report, SnapshotDiffResponse.JobStatus.DONE, 0L);
            }
            return new SnapshotDiffResponse(new SnapshotDiffReportOzone(snapshotRoot.toString(), volume, bucket, fromSnapshot, toSnapshot, new ArrayList(), null), snapDiffJob.getStatus(), this.defaultWaitTime);
        }
        return this.submitSnapDiffJob(jobKey, snapDiffJob.getJobId(), volume, bucket, fromSnapshot, toSnapshot, forceFullDiff, disableNativeDiff);
    }

    private synchronized SnapshotDiffResponse submitSnapDiffJob(String jobKey, String jobId, String volumeName, String bucketName, String fromSnapshotName, String toSnapshotName, boolean forceFullDiff, boolean disableNativeDiff) {
        LOG.info("Submitting snap diff report generation request for volume: {}, bucket: {}, fromSnapshot: {} and toSnapshot: {}", new Object[]{volumeName, bucketName, fromSnapshotName, toSnapshotName});
        OFSPath snapshotRoot = SnapshotDiffManager.getSnapshotRootPath(volumeName, bucketName);
        try {
            this.snapDiffExecutor.execute(() -> this.generateSnapshotDiffReport(jobKey, jobId, volumeName, bucketName, fromSnapshotName, toSnapshotName, forceFullDiff, disableNativeDiff));
            this.updateJobStatus(jobKey, SnapshotDiffResponse.JobStatus.QUEUED, SnapshotDiffResponse.JobStatus.IN_PROGRESS);
            return new SnapshotDiffResponse(new SnapshotDiffReportOzone(snapshotRoot.toString(), volumeName, bucketName, fromSnapshotName, toSnapshotName, new ArrayList(), null), SnapshotDiffResponse.JobStatus.IN_PROGRESS, this.defaultWaitTime);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.snapDiffJobTable.remove(jobKey);
            LOG.info("Exceeded the snapDiff parallel requests progressing limit. Removed the jobKey: {}. Please retry after {}.", (Object)jobKey, (Object)this.defaultWaitTime);
            return new SnapshotDiffResponse(new SnapshotDiffReportOzone(snapshotRoot.toString(), volumeName, bucketName, fromSnapshotName, toSnapshotName, new ArrayList(), null), SnapshotDiffResponse.JobStatus.REJECTED, this.defaultWaitTime);
        }
        catch (Exception exception) {
            this.snapDiffJobTable.remove(jobKey);
            LOG.error("Failure in job submission to the executor. Removed the jobKey: {}.", (Object)jobKey, (Object)exception);
            return new SnapshotDiffResponse(new SnapshotDiffReportOzone(snapshotRoot.toString(), volumeName, bucketName, fromSnapshotName, toSnapshotName, new ArrayList(), null), SnapshotDiffResponse.JobStatus.FAILED, this.defaultWaitTime);
        }
    }

    private synchronized SnapshotDiffJob getSnapDiffReportStatus(String jobKey, String volumeName, String bucketName, String fromSnapshotName, String toSnapshotName, boolean forceFullDiff, boolean disableNativeDiff) {
        SnapshotDiffJob snapDiffJob = this.snapDiffJobTable.get(jobKey);
        if (snapDiffJob == null) {
            String jobId = UUID.randomUUID().toString();
            snapDiffJob = new SnapshotDiffJob(System.currentTimeMillis(), jobId, SnapshotDiffResponse.JobStatus.QUEUED, volumeName, bucketName, fromSnapshotName, toSnapshotName, forceFullDiff, disableNativeDiff, 0L);
            this.snapDiffJobTable.put(jobKey, snapDiffJob);
        }
        return snapDiffJob;
    }

    @VisibleForTesting
    boolean areDiffJobAndSnapshotsActive(String volumeName, String bucketName, String fromSnapshotName, String toSnapshotName) throws IOException {
        SnapshotInfo toSnapInfo;
        SnapshotInfo fromSnapInfo = SnapshotUtils.getSnapshotInfo(this.ozoneManager, volumeName, bucketName, fromSnapshotName);
        String jobKey = this.generateSnapDiffJobKey.apply(fromSnapInfo, toSnapInfo = SnapshotUtils.getSnapshotInfo(this.ozoneManager, volumeName, bucketName, toSnapshotName));
        SnapshotDiffJob diffJob = this.snapDiffJobTable.get(jobKey);
        if (diffJob == null || diffJob.getStatus() == SnapshotDiffResponse.JobStatus.CANCELLED) {
            return false;
        }
        SnapshotUtils.checkSnapshotActive(fromSnapInfo, false);
        SnapshotUtils.checkSnapshotActive(toSnapInfo, false);
        return true;
    }

    /*
     * Exception decompiling
     */
    @VisibleForTesting
    void generateSnapshotDiffReport(String jobKey, String jobId, String volumeName, String bucketName, String fromSnapshotName, String toSnapshotName, boolean forceFullDiff, boolean disableNativeDiff) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 8[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void getDeltaFilesAndDiffKeysToObjectIdToKeyMap(Table<String, ? extends WithParentObjectId> fsTable, Table<String, ? extends WithParentObjectId> tsTable, OmSnapshot fromSnapshot, OmSnapshot toSnapshot, SnapshotInfo fsInfo, SnapshotInfo tsInfo, boolean useFullDiff, boolean skipNativeDiff, Map<String, String> tablePrefixes, PersistentMap<byte[], byte[]> oldObjIdToKeyMap, PersistentMap<byte[], byte[]> newObjIdToKeyMap, PersistentMap<byte[], Boolean> objectIdToIsDirMap, Optional<Set<Long>> oldParentIds, Optional<Set<Long>> newParentIds, String diffDir) throws IOException, RocksDBException {
        List<String> tablesToLookUp = Collections.singletonList(fsTable.getName());
        Set<String> deltaFiles = this.getDeltaFiles(fromSnapshot, toSnapshot, tablesToLookUp, fsInfo, tsInfo, useFullDiff, tablePrefixes, diffDir);
        if (skipNativeDiff || !this.sstDumpTool.isPresent()) {
            deltaFiles.addAll(this.getSSTFileListForSnapshot(fromSnapshot, tablesToLookUp));
        }
        this.addToObjectIdMap(fsTable, tsTable, deltaFiles, !skipNativeDiff && this.sstDumpTool.isPresent(), oldObjIdToKeyMap, newObjIdToKeyMap, objectIdToIsDirMap, oldParentIds, newParentIds, tablePrefixes);
    }

    @VisibleForTesting
    void addToObjectIdMap(Table<String, ? extends WithParentObjectId> fsTable, Table<String, ? extends WithParentObjectId> tsTable, Set<String> deltaFiles, boolean nativeRocksToolsLoaded, PersistentMap<byte[], byte[]> oldObjIdToKeyMap, PersistentMap<byte[], byte[]> newObjIdToKeyMap, PersistentMap<byte[], Boolean> objectIdToIsDirMap, Optional<Set<Long>> oldParentIds, Optional<Set<Long>> newParentIds, Map<String, String> tablePrefixes) throws IOException, RocksDBException {
        Object upperBoundCharArray;
        if (deltaFiles.isEmpty()) {
            return;
        }
        String tablePrefix = this.getTablePrefix(tablePrefixes, fsTable.getName());
        boolean isDirectoryTable = fsTable.getName().equals("directoryTable");
        ManagedSstFileReader sstFileReader = new ManagedSstFileReader(deltaFiles);
        this.validateEstimatedKeyChangesAreInLimits(sstFileReader);
        String sstFileReaderLowerBound = tablePrefix;
        String sstFileReaderUpperBound = null;
        if (Strings.isNotEmpty((CharSequence)tablePrefix)) {
            upperBoundCharArray = tablePrefix.toCharArray();
            int n = ((char[])upperBoundCharArray).length - 1;
            upperBoundCharArray[n] = (char)(upperBoundCharArray[n] + '\u0001');
            sstFileReaderUpperBound = String.valueOf((char[])upperBoundCharArray);
        }
        try {
            upperBoundCharArray = null;
            Object var17_19 = null;
            try (Stream keysToCheck = nativeRocksToolsLoaded && this.sstDumpTool.isPresent() ? sstFileReader.getKeyStreamWithTombstone(this.sstDumpTool.get(), sstFileReaderLowerBound, sstFileReaderUpperBound) : sstFileReader.getKeyStream(sstFileReaderLowerBound, sstFileReaderUpperBound);){
                keysToCheck.forEach(key -> {
                    try {
                        byte[] rawValue;
                        byte[] rawObjId;
                        WithParentObjectId fromObjectId = (WithParentObjectId)fsTable.get(key);
                        WithParentObjectId toObjectId = (WithParentObjectId)tsTable.get(key);
                        if (this.areKeysEqual((WithObjectID)fromObjectId, (WithObjectID)toObjectId) || !this.isKeyInBucket((String)key, tablePrefixes, fsTable.getName())) {
                            return;
                        }
                        if (fromObjectId != null) {
                            rawObjId = this.codecRegistry.asRawData((Object)fromObjectId.getObjectID());
                            rawValue = this.codecRegistry.asRawData((Object)key.substring(tablePrefix.length()));
                            oldObjIdToKeyMap.put(rawObjId, rawValue);
                            objectIdToIsDirMap.put(rawObjId, isDirectoryTable);
                            oldParentIds.ifPresent(set -> {
                                boolean bl = set.add(fromObjectId.getParentObjectID());
                            });
                        }
                        if (toObjectId != null) {
                            rawObjId = this.codecRegistry.asRawData((Object)toObjectId.getObjectID());
                            rawValue = this.codecRegistry.asRawData((Object)key.substring(tablePrefix.length()));
                            newObjIdToKeyMap.put(rawObjId, rawValue);
                            objectIdToIsDirMap.put(rawObjId, isDirectoryTable);
                            newParentIds.ifPresent(set -> {
                                boolean bl = set.add(toObjectId.getParentObjectID());
                            });
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (Throwable throwable) {
                if (upperBoundCharArray == null) {
                    upperBoundCharArray = throwable;
                } else if (upperBoundCharArray != throwable) {
                    ((Throwable)upperBoundCharArray).addSuppressed(throwable);
                }
                throw upperBoundCharArray;
            }
        }
        catch (RocksDBException rocksDBException) {
            throw new RuntimeException(rocksDBException);
        }
    }

    @VisibleForTesting
    Set<String> getDeltaFiles(OmSnapshot fromSnapshot, OmSnapshot toSnapshot, List<String> tablesToLookUp, SnapshotInfo fsInfo, SnapshotInfo tsInfo, boolean useFullDiff, Map<String, String> tablePrefixes, String diffDir) throws IOException {
        HashSet<String> deltaFiles = new HashSet<String>();
        if (this.differ != null && fsInfo != null && tsInfo != null && !useFullDiff) {
            String volume = fsInfo.getVolumeName();
            String bucket = fsInfo.getBucketName();
            DifferSnapshotInfo fromDSI = this.getDSIFromSI(fsInfo, fromSnapshot, volume, bucket);
            DifferSnapshotInfo toDSI = this.getDSIFromSI(tsInfo, toSnapshot, volume, bucket);
            LOG.debug("Calling RocksDBCheckpointDiffer");
            try {
                List sstDiffList = this.differ.getSSTDiffListWithFullPath(toDSI, fromDSI, diffDir);
                deltaFiles.addAll(sstDiffList);
            }
            catch (Exception exception) {
                LOG.warn("Failed to get SST diff file using RocksDBCheckpointDiffer. It will fallback to full diff now.", (Throwable)exception);
            }
        }
        if (useFullDiff || deltaFiles.isEmpty()) {
            if (!useFullDiff) {
                LOG.warn("RocksDBCheckpointDiffer is not available, falling back to slow path");
            }
            Set fromSnapshotFiles = RdbUtil.getSSTFilesForComparison((ManagedRocksDB)((RDBStore)fromSnapshot.getMetadataManager().getStore()).getDb().getManagedRocksDb(), tablesToLookUp);
            Set toSnapshotFiles = RdbUtil.getSSTFilesForComparison((ManagedRocksDB)((RDBStore)toSnapshot.getMetadataManager().getStore()).getDb().getManagedRocksDb(), tablesToLookUp);
            deltaFiles.addAll(fromSnapshotFiles);
            deltaFiles.addAll(toSnapshotFiles);
            RocksDiffUtils.filterRelevantSstFiles(deltaFiles, tablePrefixes);
        }
        return deltaFiles;
    }

    private void validateEstimatedKeyChangesAreInLimits(ManagedSstFileReader sstFileReader) throws RocksDBException, IOException {
        if (sstFileReader.getEstimatedTotalKeys() > this.maxAllowedKeyChangesForASnapDiff) {
            throw new IOException(String.format("Expected diff contains more than max allowed key changes for a snapDiff job. EstimatedTotalKeys: %s, AllowMaxTotalKeys: %s.", sstFileReader.getEstimatedTotalKeys(), this.maxAllowedKeyChangesForASnapDiff));
        }
    }

    private String resolveBucketRelativePath(boolean isFSOBucket, Optional<Map<Long, Path>> parentIdMap, byte[] keyVal, boolean skipUnresolvedObjIds) throws IOException {
        String key = (String)this.codecRegistry.asObject(keyVal, String.class);
        if (isFSOBucket) {
            String[] splitKey = key.split("/", 2);
            Long parentId = Long.valueOf(splitKey[0]);
            if (parentIdMap.map(m -> !m.containsKey(parentId)).orElse(true).booleanValue()) {
                if (skipUnresolvedObjIds) {
                    return null;
                }
                throw new IllegalStateException(String.format("Cannot resolve path for key: %s with parent Id: %d", key, parentId));
            }
            return parentIdMap.map(m -> ((Path)m.get(parentId)).resolve(splitKey[1])).get().toString().substring(1);
        }
        return OzoneConsts.ROOT_PATH.resolve(key).toString().substring(1);
    }

    /*
     * Exception decompiling
     */
    long generateDiffReport(String jobId, Table<String, OmKeyInfo> fsTable, Table<String, OmKeyInfo> tsTable, Table<String, OmDirectoryInfo> fsDirTable, Table<String, OmDirectoryInfo> tsDirTable, PersistentMap<byte[], Boolean> objectIdToIsDirMap, PersistentMap<byte[], byte[]> oldObjIdToKeyMap, PersistentMap<byte[], byte[]> newObjIdToKeyMap, String volumeName, String bucketName, String fromSnapshotName, String toSnapshotName, boolean isFSOBucket, Optional<Map<Long, Path>> oldParentIdPathMap, Optional<Map<Long, Path>> newParentIdPathMap, Map<String, String> tablePrefix) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 11[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isKeyModified(OmKeyInfo fromKey, OmKeyInfo toKey) {
        return !fromKey.isKeyInfoSame(toKey, false, false, false, false) || !SnapshotDeletingService.isBlockLocationInfoSame(fromKey, toKey);
    }

    private boolean isObjectModified(String fromObjectName, String toObjectName, Table<String, ? extends WithObjectID> fromSnapshotTable, Table<String, ? extends WithObjectID> toSnapshotTable) throws IOException {
        Objects.requireNonNull(fromObjectName, "fromObjectName is null.");
        Objects.requireNonNull(toObjectName, "toObjectName is null.");
        WithObjectID fromObject = (WithObjectID)fromSnapshotTable.get((Object)fromObjectName);
        WithObjectID toObject = (WithObjectID)toSnapshotTable.get((Object)toObjectName);
        if (fromObject instanceof OmKeyInfo && toObject instanceof OmKeyInfo) {
            return this.isKeyModified((OmKeyInfo)fromObject, (OmKeyInfo)toObject);
        }
        if (fromObject instanceof OmDirectoryInfo && toObject instanceof OmDirectoryInfo) {
            return !this.areAclsSame((OmDirectoryInfo)fromObject, (OmDirectoryInfo)toObject);
        }
        throw new IllegalStateException("fromObject or toObject is not of the expected type. fromObject type : " + fromObject.getClass().getName() + "toObject type: " + toObject.getClass().getName());
    }

    private boolean areAclsSame(OmDirectoryInfo fromObject, OmDirectoryInfo toObject) {
        return fromObject.getAcls().equals(toObject.getAcls());
    }

    private boolean isBlockLocationSame(String fromObjectName, String toObjectName, Table<String, ? extends WithObjectID> fromSnapshotTable, Table<String, ? extends WithObjectID> toSnapshotTable) throws IOException {
        Objects.requireNonNull(fromObjectName, "fromObjectName is null.");
        Objects.requireNonNull(toObjectName, "toObjectName is null.");
        WithObjectID fromObject = (WithObjectID)fromSnapshotTable.get((Object)fromObjectName);
        WithObjectID toObject = (WithObjectID)toSnapshotTable.get((Object)toObjectName);
        if (!(fromObject instanceof OmKeyInfo) || !(toObject instanceof OmKeyInfo)) {
            throw new IllegalStateException("fromObject or toObject is not of OmKeyInfo");
        }
        return SnapshotDeletingService.isBlockLocationInfoSame((OmKeyInfo)fromObject, (OmKeyInfo)toObject);
    }

    private PersistentList<byte[]> createDiffReportPersistentList(ColumnFamilyHandle columnFamilyHandle) {
        return new RocksDbPersistentList<byte[]>(this.db, columnFamilyHandle, this.codecRegistry, byte[].class);
    }

    private ColumnFamilyHandle createColumnFamily(String columnFamilyName) throws RocksDBException {
        return ((RocksDB)this.db.get()).createColumnFamily(new ColumnFamilyDescriptor(StringUtils.string2Bytes((String)columnFamilyName), (ColumnFamilyOptions)this.familyOptions));
    }

    private long addToReport(String jobId, long index, PersistentList<byte[]> diffReportEntries) throws IOException {
        Throwable throwable = null;
        Object var6_6 = null;
        try (ClosableIterator<byte[]> diffReportIterator = diffReportEntries.iterator();){
            while (diffReportIterator.hasNext()) {
                this.snapDiffReportTable.put(this.codecRegistry.asRawData((Object)SnapshotDiffManager.getReportKeyForIndex(jobId, index)), (byte[])diffReportIterator.next());
                ++index;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return index;
    }

    private void dropAndCloseColumnFamilyHandle(ColumnFamilyHandle columnFamilyHandle) {
        if (columnFamilyHandle == null) {
            return;
        }
        SnapshotUtils.dropColumnFamilyHandle(this.db, columnFamilyHandle);
        columnFamilyHandle.close();
    }

    private synchronized void updateJobStatus(String jobKey, SnapshotDiffResponse.JobStatus oldStatus, SnapshotDiffResponse.JobStatus newStatus) {
        SnapshotDiffJob snapshotDiffJob = this.snapDiffJobTable.get(jobKey);
        if (snapshotDiffJob.getStatus() != oldStatus) {
            throw new IllegalStateException("Invalid job status for jobID: " + snapshotDiffJob.getJobId() + ". Job's current status is '" + snapshotDiffJob.getStatus() + "', while '" + oldStatus + "' is expected.");
        }
        snapshotDiffJob.setStatus(newStatus);
        this.snapDiffJobTable.put(jobKey, snapshotDiffJob);
    }

    private synchronized void updateJobStatusToFailed(String jobKey, String reason) {
        SnapshotDiffJob snapshotDiffJob = this.snapDiffJobTable.get(jobKey);
        if (snapshotDiffJob.getStatus() != SnapshotDiffResponse.JobStatus.IN_PROGRESS) {
            throw new IllegalStateException("Invalid job status for jobID: " + snapshotDiffJob.getJobId() + ". Job's current status is '" + snapshotDiffJob.getStatus() + "', while '" + SnapshotDiffResponse.JobStatus.IN_PROGRESS + "' is expected.");
        }
        snapshotDiffJob.setStatus(SnapshotDiffResponse.JobStatus.FAILED);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reason)) {
            snapshotDiffJob.setReason(reason);
        } else {
            snapshotDiffJob.setReason("Job failed due to unknown reason.");
        }
        this.ozoneManager.getMetrics().incNumSnapshotDiffJobFails();
        this.snapDiffJobTable.put(jobKey, snapshotDiffJob);
    }

    private synchronized void updateJobStatusToDone(String jobKey, long totalNumberOfEntries) {
        SnapshotDiffJob snapshotDiffJob = this.snapDiffJobTable.get(jobKey);
        if (snapshotDiffJob.getStatus() != SnapshotDiffResponse.JobStatus.IN_PROGRESS) {
            throw new IllegalStateException("Invalid job status for jobID: " + snapshotDiffJob.getJobId() + ". Job's current status is '" + snapshotDiffJob.getStatus() + "', while '" + SnapshotDiffResponse.JobStatus.IN_PROGRESS + "' is expected.");
        }
        snapshotDiffJob.setStatus(SnapshotDiffResponse.JobStatus.DONE);
        snapshotDiffJob.setTotalDiffEntries(totalNumberOfEntries);
        this.snapDiffJobTable.put(jobKey, snapshotDiffJob);
    }

    @VisibleForTesting
    protected BucketLayout getBucketLayout(String volume, String bucket, OMMetadataManager mManager) throws IOException {
        String bucketTableKey = mManager.getBucketKey(volume, bucket);
        return ((OmBucketInfo)mManager.getBucketTable().get((Object)bucketTableKey)).getBucketLayout();
    }

    private boolean areKeysEqual(WithObjectID oldKey, WithObjectID newKey) {
        if (oldKey == null && newKey == null) {
            return true;
        }
        if (oldKey != null) {
            return oldKey.equals(newKey);
        }
        return false;
    }

    private String getTablePrefix(Map<String, String> tablePrefixes, String tableName) {
        if (tableName.equals("directoryTable") || tableName.equals("fileTable")) {
            return tablePrefixes.get("directoryTable");
        }
        return tablePrefixes.get("keyTable");
    }

    boolean isKeyInBucket(String key, Map<String, String> tablePrefixes, String tableName) {
        return key.startsWith(this.getTablePrefix(tablePrefixes, tableName));
    }

    @VisibleForTesting
    void loadJobsOnStartUp() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ClosableIterator<Map.Entry<String, SnapshotDiffJob>> iterator = this.snapDiffJobTable.iterator();){
            while (iterator.hasNext()) {
                Map.Entry next = (Map.Entry)iterator.next();
                String jobKey = (String)next.getKey();
                SnapshotDiffJob snapshotDiffJob = (SnapshotDiffJob)next.getValue();
                if (snapshotDiffJob.getStatus() != SnapshotDiffResponse.JobStatus.IN_PROGRESS) continue;
                this.updateJobStatus(jobKey, SnapshotDiffResponse.JobStatus.IN_PROGRESS, SnapshotDiffResponse.JobStatus.QUEUED);
                this.submitSnapDiffJob(jobKey, snapshotDiffJob.getJobId(), snapshotDiffJob.getVolume(), snapshotDiffJob.getBucket(), snapshotDiffJob.getFromSnapshot(), snapshotDiffJob.getToSnapshot(), snapshotDiffJob.isForceFullDiff(), snapshotDiffJob.isNativeDiffDisabled());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void close() {
        if (this.snapDiffExecutor != null) {
            this.closeExecutorService(this.snapDiffExecutor, "SnapDiffExecutor");
        }
        this.sstDumpToolExecService.ifPresent(exec -> this.closeExecutorService((ExecutorService)exec, "SstDumpToolExecutor"));
    }

    private void closeExecutorService(ExecutorService executorService, String serviceName) {
        if (executorService != null) {
            LOG.info("Shutting down executorService: '{}'", (Object)serviceName);
            executorService.shutdownNow();
            try {
                if (!executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    executorService.shutdownNow();
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                executorService.shutdownNow();
            }
        }
    }

    private /* synthetic */ Object lambda$3(Table table, Table table2, OmSnapshot omSnapshot, OmSnapshot omSnapshot2, SnapshotInfo snapshotInfo, SnapshotInfo snapshotInfo2, boolean bl, boolean bl2, Map map, PersistentMap persistentMap, PersistentMap persistentMap2, PersistentMap persistentMap3, Optional optional, Optional optional2, Path path) throws Exception {
        this.getDeltaFilesAndDiffKeysToObjectIdToKeyMap((Table<String, ? extends WithParentObjectId>)table, (Table<String, ? extends WithParentObjectId>)table2, omSnapshot, omSnapshot2, snapshotInfo, snapshotInfo2, bl, bl2, map, persistentMap, persistentMap2, persistentMap3, optional, optional2, path.toString());
        return null;
    }

    private /* synthetic */ Object lambda$4(BucketLayout bucketLayout, Table table, Table table2, OmSnapshot omSnapshot, OmSnapshot omSnapshot2, SnapshotInfo snapshotInfo, SnapshotInfo snapshotInfo2, boolean bl, boolean bl2, Map map, PersistentMap persistentMap, PersistentMap persistentMap2, PersistentMap persistentMap3, Optional optional, Optional optional2, Path path) throws Exception {
        if (bucketLayout.isFileSystemOptimized()) {
            this.getDeltaFilesAndDiffKeysToObjectIdToKeyMap((Table<String, ? extends WithParentObjectId>)table, (Table<String, ? extends WithParentObjectId>)table2, omSnapshot, omSnapshot2, snapshotInfo, snapshotInfo2, bl, bl2, map, persistentMap, persistentMap2, persistentMap3, optional, optional2, path.toString());
        }
        return null;
    }

    private /* synthetic */ Object lambda$5(BucketLayout bucketLayout, OmSnapshot omSnapshot, String string, String string2, Map map, OmSnapshot omSnapshot2, Optional optional, Optional optional2, Optional optional3, Optional optional4) throws Exception {
        if (bucketLayout.isFileSystemOptimized()) {
            long bucketId = omSnapshot.getMetadataManager().getBucketId(string, string2);
            String tablePrefix = this.getTablePrefix(map, omSnapshot2.getMetadataManager().getDirectoryTable().getName());
            ((Map)optional.get()).putAll(new FSODirectoryPathResolver(tablePrefix, bucketId, (Table<String, OmDirectoryInfo>)omSnapshot2.getMetadataManager().getDirectoryTable()).getAbsolutePathForObjectIDs(optional2));
            ((Map)optional3.get()).putAll(new FSODirectoryPathResolver(tablePrefix, bucketId, (Table<String, OmDirectoryInfo>)omSnapshot.getMetadataManager().getDirectoryTable()).getAbsolutePathForObjectIDs(optional4, true));
        }
        return null;
    }

    private /* synthetic */ Object lambda$6(String string, Table table, Table table2, Table table3, Table table4, PersistentMap persistentMap, PersistentMap persistentMap2, PersistentMap persistentMap3, String string2, String string3, String string4, String string5, BucketLayout bucketLayout, Optional optional, Optional optional2, Map map, String string6) throws Exception {
        long totalDiffEntries = this.generateDiffReport(string, (Table<String, OmKeyInfo>)table, (Table<String, OmKeyInfo>)table2, (Table<String, OmDirectoryInfo>)table3, (Table<String, OmDirectoryInfo>)table4, persistentMap, persistentMap2, persistentMap3, string2, string3, string4, string5, bucketLayout.isFileSystemOptimized(), optional, optional2, map);
        if (totalDiffEntries >= 0L && this.areDiffJobAndSnapshotsActive(string2, string3, string4, string5)) {
            this.updateJobStatusToDone(string6, totalDiffEntries);
        }
        return null;
    }
}

