/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import com.google.common.base.Preconditions;
import com.google.protobuf.MessageLite;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CodecRegistry;
import org.apache.hadoop.hdds.utils.db.DBColumnFamilyDefinition;
import org.apache.hadoop.hdds.utils.db.DBConfigFromFile;
import org.apache.hadoop.hdds.utils.db.DBDefinition;
import org.apache.hadoop.hdds.utils.db.DBProfile;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.Proto2Codec;
import org.apache.hadoop.hdds.utils.db.RDBStore;
import org.apache.hadoop.hdds.utils.db.RocksDBConfiguration;
import org.apache.hadoop.hdds.utils.db.TableConfig;
import org.apache.hadoop.hdds.utils.db.managed.ManagedColumnFamilyOptions;
import org.apache.hadoop.hdds.utils.db.managed.ManagedDBOptions;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksDB;
import org.apache.hadoop.hdds.utils.db.managed.ManagedStatistics;
import org.apache.hadoop.hdds.utils.db.managed.ManagedWriteOptions;
import org.eclipse.jetty.util.StringUtil;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.DBOptions;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.RocksDB;
import org.rocksdb.Statistics;
import org.rocksdb.StatsLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DBStoreBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DBStoreBuilder.class);
    public static final Logger ROCKS_DB_LOGGER = LoggerFactory.getLogger((Class)ManagedRocksDB.ORIGINAL_CLASS);
    public static final String DEFAULT_COLUMN_FAMILY_NAME = StringUtils.bytes2String((byte[])RocksDB.DEFAULT_COLUMN_FAMILY);
    public static final DBProfile HDDS_DEFAULT_DB_PROFILE = DBProfile.DISK;
    private ManagedDBOptions rocksDBOption;
    private ManagedColumnFamilyOptions defaultCfOptions;
    private String dbname;
    private Path dbPath;
    private String dbJmxBeanNameName;
    private Map<String, ManagedColumnFamilyOptions> cfOptions;
    private ConfigurationSource configuration;
    private final CodecRegistry.Builder registry = CodecRegistry.newBuilder();
    private String rocksDbStat;
    private long rocksDbCfWriteBufferSize;
    private RocksDBConfiguration rocksDBConfiguration;
    private boolean openReadOnly = false;
    private int maxFSSnapshots = 0;
    private final DBProfile defaultCfProfile;
    private boolean enableCompactionDag;
    private boolean createCheckpointDirs = true;
    private long maxDbUpdatesSizeThreshold;
    private Integer maxNumberOfOpenFiles = null;
    private String threadNamePrefix = "";

    public static DBStore createDBStore(ConfigurationSource configuration, DBDefinition definition) throws IOException {
        return DBStoreBuilder.newBuilder(configuration, definition).build();
    }

    public static DBStoreBuilder newBuilder(ConfigurationSource configuration, DBDefinition definition) {
        DBStoreBuilder builder = DBStoreBuilder.newBuilder(configuration);
        builder.applyDBDefinition(definition);
        return builder;
    }

    public static DBStoreBuilder newBuilder(ConfigurationSource configuration) {
        return DBStoreBuilder.newBuilder(configuration, (RocksDBConfiguration)configuration.getObject(RocksDBConfiguration.class));
    }

    public static DBStoreBuilder newBuilder(ConfigurationSource configuration, RocksDBConfiguration rocksDBConfiguration) {
        return new DBStoreBuilder(configuration, rocksDBConfiguration);
    }

    private DBStoreBuilder(ConfigurationSource configuration, RocksDBConfiguration rocksDBConfiguration) {
        this.cfOptions = new HashMap<String, ManagedColumnFamilyOptions>();
        this.configuration = configuration;
        this.rocksDbStat = configuration.getTrimmed("ozone.metastore.rocksdb.statistics", "OFF");
        this.rocksDbCfWriteBufferSize = (long)configuration.getStorageSize("ozone.metastore.rocksdb.cf.write.buffer.size", "128MB", StorageUnit.BYTES);
        this.rocksDBConfiguration = rocksDBConfiguration;
        this.defaultCfProfile = (DBProfile)this.configuration.getEnum("hdds.db.profile", (Enum)HDDS_DEFAULT_DB_PROFILE);
        LOG.debug("Default DB profile:{}", (Object)this.defaultCfProfile);
        this.maxDbUpdatesSizeThreshold = (long)configuration.getStorageSize("ozone.om.delta.update.data.size.max.limit", "1024MB", StorageUnit.BYTES);
    }

    private void applyDBDefinition(DBDefinition definition) {
        File metadataDir = definition.getDBLocation(this.configuration);
        if (metadataDir == null) {
            LOG.warn("{} is not configured. We recommend adding this setting. Falling back to {} instead.", (Object)definition.getLocationConfigKey(), (Object)"ozone.metadata.dirs");
            metadataDir = ServerUtils.getOzoneMetaDirPath((ConfigurationSource)this.configuration);
        }
        this.setName(definition.getName());
        this.setPath(Paths.get(metadataDir.getPath(), new String[0]));
        for (DBColumnFamilyDefinition<?, ?> columnFamily : definition.getColumnFamilies()) {
            this.addTable(columnFamily.getName(), columnFamily.getCfOptions());
            this.addCodec(columnFamily.getKeyType(), columnFamily.getKeyCodec());
            this.addCodec(columnFamily.getValueType(), columnFamily.getValueCodec());
        }
    }

    private void setDBOptionsProps(ManagedDBOptions dbOptions) {
        if (this.maxNumberOfOpenFiles != null) {
            dbOptions.setMaxOpenFiles(this.maxNumberOfOpenFiles.intValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBStore build() throws IOException {
        if (StringUtil.isBlank((String)this.dbname) || this.dbPath == null) {
            LOG.error("Required Parameter missing.");
            throw new IOException("Required parameter is missing. Please make sure Path and DB name is provided.");
        }
        Set<TableConfig> tableConfigs = this.makeTableConfigs();
        try {
            if (this.rocksDBOption == null) {
                this.rocksDBOption = this.getDefaultDBOptions(tableConfigs);
            }
            this.setDBOptionsProps(this.rocksDBOption);
            ManagedWriteOptions writeOptions = new ManagedWriteOptions();
            writeOptions.setSync(this.rocksDBConfiguration.getSyncOption());
            File dbFile = this.getDBFile();
            if (!dbFile.getParentFile().exists()) {
                throw new IOException("The DB destination directory should exist.");
            }
            RDBStore rDBStore = new RDBStore(dbFile, this.rocksDBOption, writeOptions, tableConfigs, this.registry.build(), this.openReadOnly, this.maxFSSnapshots, this.dbJmxBeanNameName, this.enableCompactionDag, this.maxDbUpdatesSizeThreshold, this.createCheckpointDirs, this.configuration, this.threadNamePrefix);
            return rDBStore;
        }
        finally {
            tableConfigs.forEach(TableConfig::close);
        }
    }

    public DBStoreBuilder setMaxFSSnapshots(int maxFSSnapshots) {
        this.maxFSSnapshots = maxFSSnapshots;
        return this;
    }

    public DBStoreBuilder setName(String name) {
        this.dbname = name;
        return this;
    }

    public DBStoreBuilder setDBJmxBeanNameName(String name) {
        this.dbJmxBeanNameName = name;
        return this;
    }

    public DBStoreBuilder addTable(String tableName) {
        return this.addTable(tableName, null);
    }

    public DBStoreBuilder addTable(String tableName, ManagedColumnFamilyOptions options) {
        this.cfOptions.put(tableName, options);
        return this;
    }

    public <T> DBStoreBuilder addCodec(Class<T> type, Codec<T> codec) {
        this.registry.addCodec(type, codec);
        return this;
    }

    public <T extends MessageLite> DBStoreBuilder addProto2Codec(T type) {
        return this.addCodec(type.getClass(), Proto2Codec.get(type));
    }

    public DBStoreBuilder setDBOptions(ManagedDBOptions option) {
        this.rocksDBOption = option;
        return this;
    }

    public DBStoreBuilder setDefaultCFOptions(ManagedColumnFamilyOptions options) {
        this.defaultCfOptions = options;
        return this;
    }

    public DBStoreBuilder setPath(Path path) {
        Preconditions.checkNotNull((Object)path);
        this.dbPath = path;
        return this;
    }

    public DBStoreBuilder setOpenReadOnly(boolean readOnly) {
        this.openReadOnly = readOnly;
        return this;
    }

    public DBStoreBuilder setEnableCompactionDag(boolean enableCompactionDag) {
        this.enableCompactionDag = enableCompactionDag;
        return this;
    }

    public DBStoreBuilder setCreateCheckpointDirs(boolean createCheckpointDirs) {
        this.createCheckpointDirs = createCheckpointDirs;
        return this;
    }

    public DBStoreBuilder setProfile(DBProfile prof) {
        this.setDBOptions(prof.getDBOptions());
        this.setDefaultCFOptions(prof.getColumnFamilyOptions());
        return this;
    }

    public DBStoreBuilder setMaxNumberOfOpenFiles(Integer maxNumberOfOpenFiles) {
        this.maxNumberOfOpenFiles = maxNumberOfOpenFiles;
        return this;
    }

    public DBStoreBuilder setThreadNamePrefix(String prefix) {
        this.threadNamePrefix = prefix;
        return this;
    }

    private Set<TableConfig> makeTableConfigs() {
        HashSet<TableConfig> tableConfigs = new HashSet<TableConfig>();
        this.cfOptions.putIfAbsent(DEFAULT_COLUMN_FAMILY_NAME, this.getCfOptions(this.rocksDbCfWriteBufferSize));
        for (Map.Entry<String, ManagedColumnFamilyOptions> entry : this.cfOptions.entrySet()) {
            String name = entry.getKey();
            ManagedColumnFamilyOptions options = entry.getValue();
            if (options == null) {
                LOG.debug("using default column family options for table: {}", (Object)name);
                tableConfigs.add(new TableConfig(name, this.getCfOptions(this.rocksDbCfWriteBufferSize)));
                continue;
            }
            tableConfigs.add(new TableConfig(name, options));
        }
        return tableConfigs;
    }

    private ManagedColumnFamilyOptions getDefaultCfOptions() {
        return Optional.ofNullable(this.defaultCfOptions).orElseGet(this.defaultCfProfile::getColumnFamilyOptions);
    }

    public DBStoreBuilder disableDefaultCFAutoCompaction(boolean defaultCFAutoCompaction) {
        ManagedColumnFamilyOptions defaultCFOptions = this.getDefaultCfOptions();
        defaultCFOptions.setDisableAutoCompactions(defaultCFAutoCompaction);
        this.setDefaultCFOptions(defaultCFOptions);
        return this;
    }

    private ManagedColumnFamilyOptions getCfOptions(long writeBufferSize) {
        ManagedColumnFamilyOptions cfOpts = this.getDefaultCfOptions();
        cfOpts.setWriteBufferSize(writeBufferSize);
        return cfOpts;
    }

    private ManagedDBOptions getDefaultDBOptions(Collection<TableConfig> tableConfigs) {
        ManagedDBOptions dbOptions = this.getDBOptionsFromFile(tableConfigs);
        if (dbOptions == null) {
            dbOptions = this.defaultCfProfile.getDBOptions();
            LOG.debug("Using RocksDB DBOptions from default profile.");
        }
        if (this.rocksDBConfiguration.isRocksdbLoggingEnabled()) {
            org.rocksdb.Logger logger = new org.rocksdb.Logger((DBOptions)dbOptions){

                protected void log(InfoLogLevel infoLogLevel, String s) {
                    ROCKS_DB_LOGGER.info(s);
                }
            };
            InfoLogLevel level = InfoLogLevel.valueOf((String)(this.rocksDBConfiguration.getRocksdbLogLevel() + "_LEVEL"));
            logger.setInfoLogLevel(level);
            dbOptions.setLogger(logger);
        }
        dbOptions.setWalTtlSeconds(this.rocksDBConfiguration.getWalTTL());
        dbOptions.setWalSizeLimitMB(this.rocksDBConfiguration.getWalSizeLimit());
        if (!this.rocksDbStat.equals("OFF")) {
            ManagedStatistics statistics = new ManagedStatistics();
            statistics.setStatsLevel(StatsLevel.valueOf((String)this.rocksDbStat));
            dbOptions.setStatistics((Statistics)statistics);
        }
        return dbOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManagedDBOptions getDBOptionsFromFile(Collection<TableConfig> tableConfigs) {
        ManagedDBOptions option = null;
        ArrayList<ColumnFamilyDescriptor> columnFamilyDescriptors = new ArrayList<ColumnFamilyDescriptor>();
        if (StringUtil.isNotBlank((String)this.dbname)) {
            for (TableConfig tc : tableConfigs) {
                columnFamilyDescriptors.add(tc.getDescriptor());
            }
            if (columnFamilyDescriptors.size() > 0) {
                try {
                    option = DBConfigFromFile.readFromFile(this.dbname, columnFamilyDescriptors);
                    if (option != null) {
                        LOG.info("Using RocksDB DBOptions from {}.ini file", (Object)this.dbname);
                    }
                }
                catch (IOException ex) {
                    LOG.info("Unable to read RocksDB DBOptions from {}", (Object)this.dbname, (Object)ex);
                }
                finally {
                    columnFamilyDescriptors.forEach(d -> d.getOptions().close());
                }
            }
        }
        return option;
    }

    private File getDBFile() throws IOException {
        if (this.dbPath == null) {
            LOG.error("DB path is required.");
            throw new IOException("A Path to for DB file is needed.");
        }
        if (StringUtil.isBlank((String)this.dbname)) {
            LOG.error("DBName is a required.");
            throw new IOException("A valid DB name is required.");
        }
        return Paths.get(this.dbPath.toString(), this.dbname).toFile();
    }
}

