/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db.cache;

import com.google.common.annotations.VisibleForTesting;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheResult;
import org.apache.hadoop.hdds.utils.db.cache.CacheStats;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public interface TableCache<KEY, VALUE> {
    public CacheValue<VALUE> get(CacheKey<KEY> var1);

    public void loadInitial(CacheKey<KEY> var1, CacheValue<VALUE> var2);

    public void put(CacheKey<KEY> var1, CacheValue<VALUE> var2);

    public void cleanup(List<Long> var1);

    @VisibleForTesting
    public void evictCache(List<Long> var1);

    public int size();

    public Iterator<Map.Entry<CacheKey<KEY>, CacheValue<VALUE>>> iterator();

    public CacheResult<VALUE> lookup(CacheKey<KEY> var1);

    @VisibleForTesting
    public NavigableMap<Long, Set<CacheKey<KEY>>> getEpochEntries();

    public CacheStats getStats();

    public CacheType getCacheType();

    public static enum CacheType {
        FULL_CACHE,
        PARTIAL_CACHE;

    }
}

