/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.model;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxICell;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class mxCell
implements mxICell,
Cloneable,
Serializable {
    private static final long serialVersionUID = 910211337632342672L;
    protected String id;
    protected Object value;
    protected mxGeometry geometry;
    protected String style;
    protected boolean vertex = false;
    protected boolean edge = false;
    protected boolean connectable = true;
    protected boolean visible = true;
    protected boolean collapsed = false;
    protected mxICell parent;
    protected mxICell source;
    protected mxICell target;
    protected List<Object> children;
    protected List<Object> edges;

    public mxCell() {
        this(null);
    }

    public mxCell(Object value) {
        this(value, null, null);
    }

    public mxCell(Object value, mxGeometry geometry, String style) {
        this.setValue(value);
        this.setGeometry(geometry);
        this.setStyle(style);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public mxGeometry getGeometry() {
        return this.geometry;
    }

    public void setGeometry(mxGeometry geometry) {
        this.geometry = geometry;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public boolean isVertex() {
        return this.vertex;
    }

    public void setVertex(boolean vertex) {
        this.vertex = vertex;
    }

    public boolean isEdge() {
        return this.edge;
    }

    public void setEdge(boolean edge) {
        this.edge = edge;
    }

    public boolean isConnectable() {
        return this.connectable;
    }

    public void setConnectable(boolean connectable) {
        this.connectable = connectable;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean collapsed) {
        this.collapsed = collapsed;
    }

    public mxICell getParent() {
        return this.parent;
    }

    public void setParent(mxICell parent) {
        this.parent = parent;
    }

    public mxICell getSource() {
        return this.source;
    }

    public void setSource(mxICell source) {
        this.source = source;
    }

    public mxICell getTarget() {
        return this.target;
    }

    public void setTarget(mxICell target) {
        this.target = target;
    }

    public mxICell getTerminal(boolean source) {
        return source ? this.getSource() : this.getTarget();
    }

    public mxICell setTerminal(mxICell terminal, boolean isSource) {
        if (isSource) {
            this.setSource(terminal);
        } else {
            this.setTarget(terminal);
        }
        return terminal;
    }

    public int getChildCount() {
        return this.children != null ? this.children.size() : 0;
    }

    public int getIndex(mxICell child) {
        return this.children != null ? this.children.indexOf(child) : -1;
    }

    public mxICell getChildAt(int index) {
        return this.children != null ? (mxICell)this.children.get(index) : null;
    }

    public mxICell insert(mxICell child) {
        int index = this.getChildCount();
        if (child.getParent() == this) {
            --index;
        }
        return this.insert(child, index);
    }

    public mxICell insert(mxICell child, int index) {
        if (child != null) {
            child.removeFromParent();
            child.setParent(this);
            if (this.children == null) {
                this.children = new ArrayList<Object>();
                this.children.add(child);
            } else {
                this.children.add(index, child);
            }
        }
        return child;
    }

    public mxICell remove(int index) {
        mxICell child = null;
        if (this.children != null && index >= 0) {
            child = this.getChildAt(index);
            this.remove(child);
        }
        return child;
    }

    public mxICell remove(mxICell child) {
        if (child != null && this.children != null) {
            this.children.remove(child);
            child.setParent(null);
        }
        return child;
    }

    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    public int getEdgeCount() {
        return this.edges != null ? this.edges.size() : 0;
    }

    public int getEdgeIndex(mxICell edge) {
        return this.edges != null ? this.edges.indexOf(edge) : -1;
    }

    public mxICell getEdgeAt(int index) {
        return this.edges != null ? (mxICell)this.edges.get(index) : null;
    }

    public mxICell insertEdge(mxICell edge, boolean isOutgoing) {
        if (edge != null) {
            edge.removeFromTerminal(isOutgoing);
            edge.setTerminal(this, isOutgoing);
            if (this.edges == null || edge.getTerminal(!isOutgoing) != this || !this.edges.contains(edge)) {
                if (this.edges == null) {
                    this.edges = new ArrayList<Object>();
                }
                this.edges.add(edge);
            }
        }
        return edge;
    }

    public mxICell removeEdge(mxICell edge, boolean isOutgoing) {
        if (edge != null) {
            if (edge.getTerminal(!isOutgoing) != this && this.edges != null) {
                this.edges.remove(edge);
            }
            edge.setTerminal(null, isOutgoing);
        }
        return edge;
    }

    public void removeFromTerminal(boolean isSource) {
        mxICell terminal = this.getTerminal(isSource);
        if (terminal != null) {
            terminal.removeEdge(this, isSource);
        }
    }

    public String getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    public String getAttribute(String name, String defaultValue) {
        Object userObject = this.getValue();
        String val = null;
        if (userObject instanceof Element) {
            Element element = (Element)userObject;
            val = element.getAttribute(name);
        }
        if (val == null) {
            val = defaultValue;
        }
        return val;
    }

    public void setAttribute(String name, String value) {
        Object userObject = this.getValue();
        if (userObject instanceof Element) {
            Element element = (Element)userObject;
            element.setAttribute(name, value);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        mxCell clone = (mxCell)super.clone();
        clone.setValue(this.cloneValue());
        clone.setStyle(this.getStyle());
        clone.setCollapsed(this.isCollapsed());
        clone.setConnectable(this.isConnectable());
        clone.setEdge(this.isEdge());
        clone.setVertex(this.isVertex());
        clone.setVisible(this.isVisible());
        clone.setParent(null);
        clone.setSource(null);
        clone.setTarget(null);
        clone.children = null;
        clone.edges = null;
        mxGeometry geometry = this.getGeometry();
        if (geometry != null) {
            clone.setGeometry((mxGeometry)geometry.clone());
        }
        return clone;
    }

    protected Object cloneValue() {
        Object value = this.getValue();
        if (value instanceof Node) {
            value = ((Node)value).cloneNode(true);
        }
        return value;
    }
}

