/*
 * Decompiled with CFR 0.152.
 */
package org.hadoop.ozone.recon.codegen;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.io.File;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.apache.hadoop.util.Time;
import org.hadoop.ozone.recon.codegen.ReconSchemaGenerationModule;
import org.hadoop.ozone.recon.codegen.SqlDbUtils;
import org.hadoop.ozone.recon.schema.ReconSchemaDefinition;
import org.jooq.codegen.GenerationTool;
import org.jooq.meta.jaxb.Configuration;
import org.jooq.meta.jaxb.Database;
import org.jooq.meta.jaxb.Generate;
import org.jooq.meta.jaxb.Generator;
import org.jooq.meta.jaxb.Jdbc;
import org.jooq.meta.jaxb.Logging;
import org.jooq.meta.jaxb.Strategy;
import org.jooq.meta.jaxb.Target;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JooqCodeGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(JooqCodeGenerator.class);
    private static final String DB = Paths.get(System.getProperty("java.io.tmpdir"), "recon-generated-schema-" + Time.monotonicNow()).toString();
    public static final String RECON_SCHEMA_NAME = "RECON";
    private static final String JDBC_URL = "jdbc:derby:" + DB;
    private final Set<ReconSchemaDefinition> allDefinitions;

    @Inject
    public JooqCodeGenerator(Set<ReconSchemaDefinition> allDefinitions) {
        this.allDefinitions = allDefinitions;
    }

    private void initializeSchema() throws SQLException {
        for (ReconSchemaDefinition definition : this.allDefinitions) {
            definition.initializeSchema();
        }
    }

    private void generateSourceCode(String outputDir) throws Exception {
        Configuration configuration = new Configuration().withJdbc(new Jdbc().withDriver("org.apache.derby.jdbc.EmbeddedDriver").withUrl(JDBC_URL)).withGenerator(new Generator().withDatabase(new Database().withName("org.jooq.meta.derby.DerbyDatabase").withOutputSchemaToDefault(Boolean.valueOf(true)).withIncludeTables(Boolean.valueOf(true)).withIncludePrimaryKeys(Boolean.valueOf(true)).withInputSchema(RECON_SCHEMA_NAME)).withGenerate(new Generate().withDaos(Boolean.valueOf(true)).withEmptyCatalogs(Boolean.valueOf(true))).withStrategy(new Strategy().withName("org.hadoop.ozone.recon.codegen.TableNamingStrategy")).withTarget(new Target().withPackageName("org.hadoop.ozone.recon.schema").withClean(Boolean.valueOf(true)).withDirectory(outputDir))).withLogging(Logging.WARN);
        GenerationTool.generate((Configuration)configuration);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            throw new IllegalArgumentException("Missing required arguments: Need an output directory for generated code.\nUsage: org.apache.hadoop.ozone.recon.persistence.JooqCodeGenerator <outputDirectory>.");
        }
        String outputDir = args[0];
        Injector injector = Guice.createInjector((Module[])new Module[]{new ReconSchemaGenerationModule(), new AbstractModule(){

            protected void configure() {
                System.setProperty("org.jooq.no-logo", "true");
                this.bind(DataSource.class).toProvider((Provider)new LocalDataSourceProvider());
                this.bind(JooqCodeGenerator.class);
            }
        }});
        JooqCodeGenerator codeGenerator = (JooqCodeGenerator)injector.getInstance(JooqCodeGenerator.class);
        try {
            codeGenerator.initializeSchema();
        }
        catch (SQLException e) {
            LOG.error("Unable to initialize schema.", (Throwable)e);
            throw new ExceptionInInitializerError(e);
        }
        try {
            codeGenerator.generateSourceCode(outputDir);
        }
        catch (Exception e) {
            LOG.error("Code generation failed. Aborting build.", (Throwable)e);
            throw new ExceptionInInitializerError(e);
        }
        LocalDataSourceProvider.cleanup();
    }

    static class LocalDataSourceProvider
    implements Provider<DataSource> {
        private static EmbeddedDataSource dataSource;

        LocalDataSourceProvider() {
        }

        public DataSource get() {
            return dataSource;
        }

        static void cleanup() {
            FileUtils.deleteQuietly((File)new File(DB));
        }

        static {
            try {
                SqlDbUtils.createNewDerbyDatabase(JDBC_URL, JooqCodeGenerator.RECON_SCHEMA_NAME);
            }
            catch (Exception e) {
                LOG.error("Error creating Recon Derby DB.", (Throwable)e);
            }
            dataSource = new EmbeddedDataSource();
            dataSource.setDatabaseName(DB);
            dataSource.setUser(JooqCodeGenerator.RECON_SCHEMA_NAME);
        }
    }
}

