/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.scm;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.hdds.scm.container.common.helpers.DeletedBlocksTransactionInfoWrapper;
import picocli.CommandLine;

@CommandLine.Command(name="reset", description={"Reset the retry count of failed DeletedBlocksTransaction"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class ResetDeletedBlockRetryCountSubcommand
extends ScmSubcommand {
    @CommandLine.ArgGroup(multiplicity="1")
    private TransactionsOption group;

    public void execute(ScmClient client) throws IOException {
        int count;
        if (this.group.resetAll) {
            count = client.resetDeletedBlockRetryCount(new ArrayList());
        } else if (this.group.fileName != null) {
            List txIDs;
            Gson gson = new Gson();
            try (FileInputStream in = new FileInputStream(this.group.fileName);
                 InputStreamReader fileReader = new InputStreamReader((InputStream)in, StandardCharsets.UTF_8);){
                DeletedBlocksTransactionInfoWrapper[] txns = (DeletedBlocksTransactionInfoWrapper[])gson.fromJson((Reader)fileReader, DeletedBlocksTransactionInfoWrapper[].class);
                txIDs = Arrays.stream(txns).map(DeletedBlocksTransactionInfoWrapper::getTxID).sorted().distinct().collect(Collectors.toList());
                System.out.println("Num of loaded txIDs: " + txIDs.size());
                if (!txIDs.isEmpty()) {
                    System.out.println("The first loaded txID: " + txIDs.get(0));
                    System.out.println("The last loaded txID: " + txIDs.get(txIDs.size() - 1));
                }
            }
            catch (JsonIOException | JsonSyntaxException | IOException ex) {
                System.out.println("Cannot parse the file " + this.group.fileName);
                throw new IOException(ex);
            }
            count = client.resetDeletedBlockRetryCount(txIDs);
        } else {
            if (this.group.txList == null || this.group.txList.isEmpty()) {
                System.out.println("TransactionId list should not be empty");
                return;
            }
            count = client.resetDeletedBlockRetryCount(this.group.txList);
        }
        System.out.println("Reset " + count + " deleted block transactions in SCM.");
    }

    static class TransactionsOption {
        @CommandLine.Option(names={"-a", "--all"}, description={"Reset all expired deleted block transaction retry count from -1 to 0."})
        private boolean resetAll;
        @CommandLine.Option(names={"-l", "--list"}, split=",", paramLabel="txID", description={"Reset the only given deletedBlock transaction ID list. Example: 100,101,102.(Separated by ',')"})
        private List<Long> txList;
        @CommandLine.Option(names={"-i", "--in"}, description={"Use file as input, need to be JSON Array format and contains multi \"txID\" key. Example: [{\"txID\":1},{\"txID\":2}]"})
        private String fileName;

        TransactionsOption() {
        }
    }
}

