/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.ozone.container.common.helpers.DatanodeIdYaml;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import org.apache.ratis.util.Preconditions;
import picocli.CommandLine;

public class BaseAppendLogGenerator
extends BaseFreonGenerator {
    @CommandLine.Option(names={"-r", "--raft-peer"}, description={"Set the UUID of the raft peer managed by the datanode."}, defaultValue="")
    protected String serverId;
    @CommandLine.Option(names={"-c", "--server-address"}, description={"Host:port of the Ratis server"}, defaultValue="localhost:9858")
    protected String serverAddress = "localhost:9858";
    @CommandLine.Option(names={"--inflight-limit"}, description={"Maximum in-flight messages"}, defaultValue="10")
    protected int inflightLimit;
    protected BlockingQueue<Long> inFlightMessages;

    protected void setServerIdFromFile(OzoneConfiguration conf) throws IOException {
        File idFile = new File(HddsServerUtil.getDatanodeIdFilePath((ConfigurationSource)conf));
        if ((this.serverId == null || this.serverId.equals("")) && idFile.exists()) {
            DatanodeDetails datanodeDetails = DatanodeIdYaml.readDatanodeIdFile((File)idFile);
            this.serverId = datanodeDetails.getUuidString();
        }
        Preconditions.assertTrue((!this.serverId.equals("") ? 1 : 0) != 0, (Object)("Server id is not specified and can't be read from " + idFile.getAbsolutePath()));
    }
}

