/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.segmentparser;

import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.ContainerStateMachine;
import org.apache.hadoop.ozone.segmentparser.BaseLogParser;
import org.apache.hadoop.ozone.segmentparser.RatisLogParser;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import picocli.CommandLine;

@CommandLine.Command(name="datanode", description={"dump datanode segment file"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class DatanodeRatisLogParser
extends BaseLogParser
implements Callable<Void> {
    @CommandLine.ParentCommand
    private RatisLogParser logParser;
    private static final RaftGroupId DUMMY_PIPELINE_ID = RaftGroupId.valueOf((ByteString)ByteString.copyFromUtf8((String)"ADummyRatisGroup"));

    public static String smToContainerLogString(RaftProtos.StateMachineLogEntryProto logEntryProto) {
        return ContainerStateMachine.smProtoToString((RaftGroupId)DUMMY_PIPELINE_ID, null, (RaftProtos.StateMachineLogEntryProto)logEntryProto);
    }

    @Override
    public Void call() throws Exception {
        System.out.println("Dumping Datanode Ratis Log");
        System.out.println("Using Dummy PipelineID:" + DUMMY_PIPELINE_ID + "\n\n");
        this.parseRatisLogs(DatanodeRatisLogParser::smToContainerLogString);
        return null;
    }
}

