/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.tenant;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.om.helpers.TenantUserInfoValue;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.tenant.TenantHandler;
import org.jooq.tools.StringUtils;
import picocli.CommandLine;

@CommandLine.Command(name="info", description={"Get tenant related information of a user"})
public class GetUserInfoHandler
extends TenantHandler {
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    @CommandLine.Parameters(description={"User name (principal)"}, arity="1..1")
    private String userPrincipal;
    @CommandLine.Option(names={"--json", "-j"}, description={"Print result in JSON"})
    private boolean printJson;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        if (StringUtils.isEmpty((String)this.userPrincipal)) {
            GenericCli.missingSubcommand((CommandLine.Model.CommandSpec)this.spec);
            return;
        }
        TenantUserInfoValue tenantUserInfo = client.getObjectStore().tenantGetUserInfo(this.userPrincipal);
        List accessIdInfoList = tenantUserInfo.getAccessIdInfoList();
        if (accessIdInfoList.size() == 0) {
            this.err().println("User '" + this.userPrincipal + "' is not assigned to any tenant.");
            return;
        }
        if (!this.printJson) {
            this.out().println("User '" + this.userPrincipal + "' is assigned to:");
            accessIdInfoList.forEach(accessIdInfo -> {
                String adminInfoString = accessIdInfo.getIsAdmin() ? (accessIdInfo.getIsDelegatedAdmin() ? " delegated admin" : " admin") : "";
                this.out().format("- Tenant '%s'%s with accessId '%s'%n", accessIdInfo.getTenantId(), adminInfoString, accessIdInfo.getAccessId());
            });
        } else {
            JsonObject resObj = new JsonObject();
            resObj.addProperty("user", this.userPrincipal);
            JsonArray arr = new JsonArray();
            accessIdInfoList.forEach(accessIdInfo -> {
                JsonObject tenantObj = new JsonObject();
                tenantObj.addProperty("accessId", accessIdInfo.getAccessId());
                tenantObj.addProperty("tenantId", accessIdInfo.getTenantId());
                tenantObj.addProperty("isAdmin", Boolean.valueOf(accessIdInfo.getIsAdmin()));
                tenantObj.addProperty("isDelegatedAdmin", Boolean.valueOf(accessIdInfo.getIsDelegatedAdmin()));
                arr.add((JsonElement)tenantObj);
            });
            resObj.add("tenants", (JsonElement)arr);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            this.out().println(gson.toJson((JsonElement)resObj));
        }
    }
}

