/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.tenant;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.tenant.TenantHandler;
import picocli.CommandLine;

@CommandLine.Command(name="assign-admin", aliases={"assignadmin"}, description={"Assign admin role to accessIds in a tenant"})
public class TenantAssignAdminHandler
extends TenantHandler {
    @CommandLine.Parameters(description={"Access ID"}, arity="1..1")
    private String accessId;
    @CommandLine.Option(names={"-t", "--tenant"}, description={"Tenant name"})
    private String tenantId;
    @CommandLine.Option(names={"-d", "--delegated"}, defaultValue="false", description={"Assign delegated admin. If unspecified, assign non-delegated admin (the default)"})
    private boolean delegated;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        client.getObjectStore().tenantAssignAdmin(this.accessId, this.tenantId, this.delegated);
        if (this.isVerbose()) {
            JsonObject obj = new JsonObject();
            obj.addProperty("accessId", this.accessId);
            obj.addProperty("tenantId", this.tenantId);
            obj.addProperty("isAdmin", Boolean.valueOf(true));
            obj.addProperty("isDelegatedAdmin", Boolean.valueOf(this.delegated));
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            this.out().println(gson.toJson((JsonElement)obj));
        }
    }
}

