/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine.commandhandler;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.ozone.container.common.statemachine.SCMConnectionManager;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.CommandHandler;
import org.apache.hadoop.ozone.container.common.transport.server.XceiverServerSpi;
import org.apache.hadoop.ozone.container.ozoneimpl.OzoneContainer;
import org.apache.hadoop.ozone.protocol.commands.ClosePipelineCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClosePipelineCommandHandler
implements CommandHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ClosePipelineCommandHandler.class);
    private final AtomicLong invocationCount = new AtomicLong(0L);
    private final AtomicInteger queuedCount = new AtomicInteger(0);
    private long totalTime;
    private final Executor executor;

    public ClosePipelineCommandHandler(Executor executor) {
        this.executor = executor;
    }

    @Override
    public void handle(SCMCommand command, OzoneContainer ozoneContainer, StateContext context, SCMConnectionManager connectionManager) {
        this.queuedCount.incrementAndGet();
        CompletableFuture.runAsync(() -> {
            this.invocationCount.incrementAndGet();
            long startTime = Time.monotonicNow();
            DatanodeDetails dn = context.getParent().getDatanodeDetails();
            ClosePipelineCommand closePipelineCommand = (ClosePipelineCommand)command;
            PipelineID pipelineID = closePipelineCommand.getPipelineID();
            HddsProtos.PipelineID pipelineIdProto = pipelineID.getProtobuf();
            try {
                XceiverServerSpi server = ozoneContainer.getWriteChannel();
                if (server.isExist(pipelineIdProto)) {
                    server.removeGroup(pipelineIdProto);
                    LOG.info("Close Pipeline {} command on datanode {}.", (Object)pipelineID, (Object)dn.getUuidString());
                } else {
                    LOG.debug("Ignoring close pipeline command for pipeline {} as it does not exist", (Object)pipelineID);
                }
            }
            catch (IOException e) {
                LOG.error("Can't close pipeline {}", (Object)pipelineID, (Object)e);
            }
            finally {
                long endTime = Time.monotonicNow();
                this.totalTime += endTime - startTime;
            }
        }, this.executor).whenComplete((v, e) -> this.queuedCount.decrementAndGet());
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type getCommandType() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.closePipelineCommand;
    }

    @Override
    public int getInvocationCount() {
        return (int)this.invocationCount.get();
    }

    @Override
    public long getAverageRunTime() {
        if (this.invocationCount.get() > 0L) {
            return this.totalTime / this.invocationCount.get();
        }
        return 0L;
    }

    @Override
    public long getTotalRunTime() {
        return this.totalTime;
    }

    @Override
    public int getQueuedCount() {
        return this.queuedCount.get();
    }
}

