/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine.commandhandler;

import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.ozone.container.common.statemachine.SCMConnectionManager;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.CommandHandler;
import org.apache.hadoop.ozone.container.ec.reconstruction.ECReconstructionCommandInfo;
import org.apache.hadoop.ozone.container.ec.reconstruction.ECReconstructionCoordinator;
import org.apache.hadoop.ozone.container.ec.reconstruction.ECReconstructionCoordinatorTask;
import org.apache.hadoop.ozone.container.ozoneimpl.OzoneContainer;
import org.apache.hadoop.ozone.container.replication.ReplicationSupervisor;
import org.apache.hadoop.ozone.protocol.commands.ReconstructECContainersCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;

public class ReconstructECContainersCommandHandler
implements CommandHandler {
    private final ReplicationSupervisor supervisor;
    private final ECReconstructionCoordinator coordinator;
    private final ConfigurationSource conf;

    public ReconstructECContainersCommandHandler(ConfigurationSource conf, ReplicationSupervisor supervisor, ECReconstructionCoordinator coordinator) {
        this.conf = conf;
        this.supervisor = supervisor;
        this.coordinator = coordinator;
    }

    @Override
    public void handle(SCMCommand command, OzoneContainer container, StateContext context, SCMConnectionManager connectionManager) {
        ReconstructECContainersCommand ecContainersCommand = (ReconstructECContainersCommand)command;
        ECReconstructionCommandInfo reconstructionCommandInfo = new ECReconstructionCommandInfo(ecContainersCommand);
        this.supervisor.addTask(new ECReconstructionCoordinatorTask(this.coordinator, reconstructionCommandInfo));
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type getCommandType() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.reconstructECContainersCommand;
    }

    @Override
    public int getInvocationCount() {
        return 0;
    }

    @Override
    public long getAverageRunTime() {
        return 0L;
    }

    @Override
    public long getTotalRunTime() {
        return 0L;
    }

    @Override
    public int getQueuedCount() {
        return this.supervisor.getInFlightReplications(ECReconstructionCoordinatorTask.class);
    }

    public ConfigurationSource getConf() {
        return this.conf;
    }
}

