/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.states.endpoint;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.ozone.container.common.DatanodeLayoutStorage;
import org.apache.hadoop.ozone.container.common.statemachine.EndpointStateMachine;
import org.apache.hadoop.ozone.container.common.utils.StorageVolumeUtil;
import org.apache.hadoop.ozone.container.common.volume.MutableVolumeSet;
import org.apache.hadoop.ozone.container.common.volume.StorageVolume;
import org.apache.hadoop.ozone.container.ozoneimpl.OzoneContainer;
import org.apache.hadoop.ozone.protocol.VersionResponse;
import org.apache.hadoop.util.DiskChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionEndpointTask
implements Callable<EndpointStateMachine.EndPointStates> {
    public static final Logger LOG = LoggerFactory.getLogger(VersionEndpointTask.class);
    private final EndpointStateMachine rpcEndPoint;
    private final ConfigurationSource configuration;
    private final OzoneContainer ozoneContainer;

    public VersionEndpointTask(EndpointStateMachine rpcEndPoint, ConfigurationSource conf, OzoneContainer container) {
        this.rpcEndPoint = rpcEndPoint;
        this.configuration = conf;
        this.ozoneContainer = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EndpointStateMachine.EndPointStates call() throws Exception {
        this.rpcEndPoint.lock();
        try {
            if (this.rpcEndPoint.getState().equals((Object)EndpointStateMachine.EndPointStates.GETVERSION)) {
                StorageContainerDatanodeProtocolProtos.SCMVersionResponseProto versionResponse = this.rpcEndPoint.getEndPoint().getVersion(null);
                VersionResponse response = VersionResponse.getFromProtobuf(versionResponse);
                this.rpcEndPoint.setVersion(response);
                if (!this.rpcEndPoint.isPassive()) {
                    String scmId = response.getValue("scmUuid");
                    String clusterId = response.getValue("clusterID");
                    DatanodeLayoutStorage layoutStorage = new DatanodeLayoutStorage(this.configuration);
                    layoutStorage.setClusterId(clusterId);
                    layoutStorage.persistCurrentState();
                    Preconditions.checkNotNull((Object)scmId, (Object)"Reply from SCM: scmId cannot be null");
                    Preconditions.checkNotNull((Object)clusterId, (Object)"Reply from SCM: clusterId cannot be null");
                    this.checkVolumeSet(this.ozoneContainer.getDbVolumeSet(), scmId, clusterId);
                    this.checkVolumeSet(this.ozoneContainer.getVolumeSet(), scmId, clusterId);
                    this.ozoneContainer.start(clusterId);
                }
                EndpointStateMachine.EndPointStates nextState = this.rpcEndPoint.getState().getNextState();
                this.rpcEndPoint.setState(nextState);
                this.rpcEndPoint.zeroMissedCount();
            } else {
                LOG.debug("Cannot execute GetVersion task as endpoint state machine is in {} state", (Object)this.rpcEndPoint.getState());
            }
        }
        catch (DiskChecker.DiskOutOfSpaceException ex) {
            this.rpcEndPoint.setState(EndpointStateMachine.EndPointStates.SHUTDOWN);
        }
        catch (IOException ex) {
            this.rpcEndPoint.logIfNeeded(ex);
        }
        finally {
            this.rpcEndPoint.unlock();
        }
        return this.rpcEndPoint.getState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkVolumeSet(MutableVolumeSet volumeSet, String scmId, String clusterId) throws DiskChecker.DiskOutOfSpaceException {
        if (volumeSet == null) {
            return;
        }
        volumeSet.writeLock();
        try {
            for (StorageVolume volume : volumeSet.getVolumeMap().values()) {
                boolean result = StorageVolumeUtil.checkVolume(volume, scmId, clusterId, this.configuration, LOG, this.ozoneContainer.getDbVolumeSet());
                if (result) continue;
                volumeSet.failVolume(volume.getStorageDir().getPath());
            }
            if (volumeSet.getVolumesList().size() == 0) {
                throw new DiskChecker.DiskOutOfSpaceException("All configured Volumes are in Inconsistent State");
            }
        }
        finally {
            volumeSet.writeUnlock();
        }
    }
}

