/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.volume;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.StorageSize;
import org.apache.hadoop.hdds.fs.SpaceUsageCheckFactory;
import org.apache.hadoop.hdds.fs.SpaceUsageCheckParams;
import org.apache.hadoop.ozone.container.common.volume.VolumeUsage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VolumeInfo {
    private static final Logger LOG = LoggerFactory.getLogger(VolumeInfo.class);
    private final String rootDir;
    private final StorageType storageType;
    private final VolumeUsage usage;
    private long configuredCapacity;
    private long reservedInBytes;

    private long getReserved(ConfigurationSource conf) {
        if (conf.isConfigured("hdds.datanode.dir.du.reserved.percent") && conf.isConfigured("hdds.datanode.dir.du.reserved")) {
            LOG.error("Both {} and {} are set. Set either one, not both. If the volume matches with volume parameter in former config, it is set as reserved space. If not it fall backs to the latter config.", (Object)"hdds.datanode.dir.du.reserved", (Object)"hdds.datanode.dir.du.reserved.percent");
        }
        Collection reserveList = conf.getTrimmedStringCollection("hdds.datanode.dir.du.reserved");
        for (String reserve : reserveList) {
            String[] words = reserve.split(":");
            if (words.length < 2) {
                LOG.error("Reserved space should config in pair, but current is {}", (Object)reserve);
                continue;
            }
            if (!words[0].trim().equals(this.rootDir)) continue;
            try {
                StorageSize size = StorageSize.parse((String)words[1].trim());
                return (long)size.getUnit().toBytes(size.getValue());
            }
            catch (Exception e) {
                LOG.error("Failed to parse StorageSize: {}", (Object)words[1].trim(), (Object)e);
                break;
            }
        }
        if (conf.isConfigured("hdds.datanode.dir.du.reserved.percent")) {
            float percentage = conf.getFloat("hdds.datanode.dir.du.reserved.percent", 0.0f);
            if (0.0f <= percentage && percentage <= 1.0f) {
                return (long)Math.ceil((float)this.usage.getCapacity() * percentage);
            }
            LOG.error("The value of {} should be between 0 to 1. Defaulting to 0.", (Object)"hdds.datanode.dir.du.reserved.percent");
        }
        return 0L;
    }

    private VolumeInfo(Builder b) throws IOException {
        boolean succeeded;
        this.rootDir = b.rootDir;
        File root = new File(this.rootDir);
        boolean bl = succeeded = root.isDirectory() || root.mkdirs();
        if (!succeeded) {
            LOG.error("Unable to create the volume root dir at : {}", (Object)root);
            throw new IOException("Unable to create the volume root dir at " + root);
        }
        this.storageType = b.storageType != null ? b.storageType : StorageType.DEFAULT;
        this.configuredCapacity = b.configuredCapacity != 0L ? b.configuredCapacity : -1L;
        SpaceUsageCheckFactory usageCheckFactory = b.usageCheckFactory;
        if (usageCheckFactory == null) {
            usageCheckFactory = SpaceUsageCheckFactory.create((ConfigurationSource)b.conf);
        }
        SpaceUsageCheckParams checkParams = usageCheckFactory.paramsFor(root);
        this.usage = new VolumeUsage(checkParams);
        this.reservedInBytes = this.getReserved(b.conf);
        this.usage.setReserved(this.reservedInBytes);
    }

    public long getCapacity() {
        if (this.configuredCapacity < 0L) {
            return Math.max(this.usage.getCapacity() - this.reservedInBytes, 0L);
        }
        return this.configuredCapacity;
    }

    public long getAvailable() {
        long avail = this.getCapacity() - this.usage.getUsedSpace();
        return Math.max(Math.min(avail, this.usage.getAvailable()), 0L);
    }

    public long getAvailable(VolumeUsage.PrecomputedVolumeSpace precomputedValues) {
        long avail = precomputedValues.getCapacity() - this.usage.getUsedSpace();
        return Math.max(Math.min(avail, this.usage.getAvailable(precomputedValues)), 0L);
    }

    public VolumeUsage.PrecomputedVolumeSpace getPrecomputedVolumeSpace() {
        return this.usage.getPrecomputedVolumeSpace();
    }

    public void incrementUsedSpace(long usedSpace) {
        this.usage.incrementUsedSpace(usedSpace);
    }

    public void decrementUsedSpace(long reclaimedSpace) {
        this.usage.decrementUsedSpace(reclaimedSpace);
    }

    public void refreshNow() {
        this.usage.refreshNow();
    }

    public long getScmUsed() {
        return this.usage.getUsedSpace();
    }

    void shutdownUsageThread() {
        this.usage.shutdown();
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    @VisibleForTesting
    public VolumeUsage getUsageForTesting() {
        return this.usage;
    }

    @VisibleForTesting
    public long getReservedInBytes() {
        return this.reservedInBytes;
    }

    public static class Builder {
        private final ConfigurationSource conf;
        private final String rootDir;
        private SpaceUsageCheckFactory usageCheckFactory;
        private StorageType storageType;
        private long configuredCapacity;

        public Builder(String root, ConfigurationSource config) {
            this.rootDir = root;
            this.conf = config;
        }

        public Builder storageType(StorageType st) {
            this.storageType = st;
            return this;
        }

        public Builder configuredCapacity(long capacity) {
            this.configuredCapacity = capacity;
            return this;
        }

        public Builder usageCheckFactory(SpaceUsageCheckFactory factory) {
            this.usageCheckFactory = factory;
            return this;
        }

        public VolumeInfo build() throws IOException {
            return new VolumeInfo(this);
        }
    }
}

