/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.volume;

import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.fs.CachingSpaceUsageSource;
import org.apache.hadoop.hdds.fs.SpaceUsageCheckParams;
import org.apache.hadoop.hdds.fs.SpaceUsageSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VolumeUsage
implements SpaceUsageSource {
    private final CachingSpaceUsageSource source;
    private boolean shutdownComplete;
    private long reservedInBytes;
    private static final Logger LOG = LoggerFactory.getLogger(VolumeUsage.class);

    VolumeUsage(SpaceUsageCheckParams checkParams) {
        this.source = new CachingSpaceUsageSource(checkParams);
        this.start();
    }

    public long getCapacity() {
        return Math.max(this.source.getCapacity(), 0L);
    }

    public long getAvailable() {
        return this.source.getAvailable() - this.getRemainingReserved();
    }

    public long getAvailable(PrecomputedVolumeSpace precomputedVolumeSpace) {
        long available = precomputedVolumeSpace.getAvailable();
        return available - this.getRemainingReserved(precomputedVolumeSpace);
    }

    public long getUsedSpace() {
        return this.source.getUsedSpace();
    }

    public void incrementUsedSpace(long usedSpace) {
        this.source.incrementUsedSpace(usedSpace);
    }

    public void decrementUsedSpace(long reclaimedSpace) {
        this.source.decrementUsedSpace(reclaimedSpace);
    }

    private long getOtherUsed() {
        long totalUsed = this.source.getCapacity() - this.source.getAvailable();
        return Math.max(totalUsed - this.source.getUsedSpace(), 0L);
    }

    private long getOtherUsed(PrecomputedVolumeSpace precomputedVolumeSpace) {
        long totalUsed = precomputedVolumeSpace.getCapacity() - precomputedVolumeSpace.getAvailable();
        return Math.max(totalUsed - this.source.getUsedSpace(), 0L);
    }

    private long getRemainingReserved() {
        return Math.max(this.reservedInBytes - this.getOtherUsed(), 0L);
    }

    private long getRemainingReserved(PrecomputedVolumeSpace precomputedVolumeSpace) {
        return Math.max(this.reservedInBytes - this.getOtherUsed(precomputedVolumeSpace), 0L);
    }

    public synchronized void start() {
        this.source.start();
    }

    public synchronized void shutdown() {
        if (!this.shutdownComplete) {
            this.source.shutdown();
            this.shutdownComplete = true;
        }
    }

    public void refreshNow() {
        this.source.refreshNow();
    }

    public void setReserved(long reserved) {
        this.reservedInBytes = reserved;
    }

    public static long getMinVolumeFreeSpace(ConfigurationSource conf, long capacity) {
        if (conf.isConfigured("hdds.datanode.volume.min.free.space") && conf.isConfigured("hdds.datanode.volume.min.free.space.percent")) {
            LOG.error("Both {} and {} are set. Set either one, not both. If both are set,it will use default value which is {} as min free space", new Object[]{"hdds.datanode.volume.min.free.space", "hdds.datanode.volume.min.free.space.percent", "5GB"});
        }
        if (conf.isConfigured("hdds.datanode.volume.min.free.space")) {
            return (long)conf.getStorageSize("hdds.datanode.volume.min.free.space", "5GB", StorageUnit.BYTES);
        }
        if (conf.isConfigured("hdds.datanode.volume.min.free.space.percent")) {
            float volumeMinFreeSpacePercent = Float.parseFloat(conf.get("hdds.datanode.volume.min.free.space.percent"));
            return (long)((float)capacity * volumeMinFreeSpacePercent);
        }
        return (long)conf.getStorageSize("hdds.datanode.volume.min.free.space", "5GB", StorageUnit.BYTES);
    }

    public PrecomputedVolumeSpace getPrecomputedVolumeSpace() {
        return new PrecomputedVolumeSpace(this.source.getCapacity(), this.source.getAvailable());
    }

    public static class PrecomputedVolumeSpace {
        private final long capacity;
        private final long available;

        public PrecomputedVolumeSpace(long capacity, long available) {
            this.capacity = capacity;
            this.available = available;
        }

        public long getCapacity() {
            return this.capacity;
        }

        public long getAvailable() {
            return this.available;
        }
    }
}

