/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdfs.util.Canceler;
import org.apache.hadoop.hdfs.util.DataTransferThrottler;
import org.apache.hadoop.ozone.common.Checksum;
import org.apache.hadoop.ozone.common.ChecksumData;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.helpers.ChunkInfo;
import org.apache.hadoop.ozone.container.common.helpers.ContainerUtils;
import org.apache.hadoop.ozone.container.common.impl.ContainerDataYaml;
import org.apache.hadoop.ozone.container.common.impl.ContainerLayoutVersion;
import org.apache.hadoop.ozone.container.common.interfaces.BlockIterator;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.interfaces.DBHandle;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainer;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.helpers.BlockUtils;
import org.apache.hadoop.ozone.container.keyvalue.helpers.ChunkUtils;
import org.apache.hadoop.ozone.container.keyvalue.helpers.KeyValueContainerLocationUtil;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueContainerCheck {
    private static final Logger LOG = LoggerFactory.getLogger(KeyValueContainerCheck.class);
    private long containerID;
    private KeyValueContainerData onDiskContainerData;
    private ConfigurationSource checkConfig;
    private String metadataPath;
    private HddsVolume volume;
    private KeyValueContainer container;

    public KeyValueContainerCheck(String metadataPath, ConfigurationSource conf, long containerID, HddsVolume volume, KeyValueContainer container) {
        Preconditions.checkArgument((metadataPath != null ? 1 : 0) != 0);
        this.checkConfig = conf;
        this.containerID = containerID;
        this.onDiskContainerData = null;
        this.metadataPath = metadataPath;
        this.volume = volume;
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Container.ScanResult fastCheck() throws InterruptedException {
        LOG.debug("Running basic checks for container {};", (Object)this.containerID);
        try {
            File containerDir = new File(this.metadataPath).getParentFile();
            if (!containerDir.exists()) {
                Container.ScanResult scanResult = Container.ScanResult.unhealthy(Container.ScanResult.FailureType.MISSING_CONTAINER_DIR, containerDir, new FileNotFoundException("Container directory " + containerDir + " not found."));
                return scanResult;
            }
            File metadataDir = new File(this.metadataPath);
            if (!metadataDir.exists()) {
                Container.ScanResult scanResult = Container.ScanResult.unhealthy(Container.ScanResult.FailureType.MISSING_METADATA_DIR, metadataDir, new FileNotFoundException("Metadata directory " + metadataDir + " not found."));
                return scanResult;
            }
            File containerFile = KeyValueContainer.getContainerFile(this.metadataPath, this.containerID);
            try {
                this.loadContainerData(containerFile);
            }
            catch (FileNotFoundException ex) {
                Container.ScanResult scanResult = Container.ScanResult.unhealthy(Container.ScanResult.FailureType.MISSING_CONTAINER_FILE, containerFile, ex);
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException("Metadata scan of container " + this.containerID + " interrupted.");
                }
                return scanResult;
            }
            catch (IOException ex) {
                Container.ScanResult scanResult;
                block16: {
                    scanResult = Container.ScanResult.unhealthy(Container.ScanResult.FailureType.CORRUPT_CONTAINER_FILE, containerFile, ex);
                    if (!Thread.currentThread().isInterrupted()) break block16;
                    throw new InterruptedException("Metadata scan of container " + this.containerID + " interrupted.");
                }
                return scanResult;
            }
            File chunksDir = new File(this.onDiskContainerData.getChunksPath());
            if (!chunksDir.exists()) {
                Container.ScanResult scanResult = Container.ScanResult.unhealthy(Container.ScanResult.FailureType.MISSING_CHUNKS_DIR, chunksDir, new FileNotFoundException("Chunks directory " + chunksDir + " not found."));
                return scanResult;
            }
            Container.ScanResult scanResult = this.checkContainerFile(containerFile);
            return scanResult;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("Metadata scan of container " + this.containerID + " interrupted.");
            }
        }
    }

    public Container.ScanResult fullCheck(DataTransferThrottler throttler, Canceler canceler) throws InterruptedException {
        Container.ScanResult result = this.fastCheck();
        if (result.isHealthy()) {
            result = this.scanData(throttler, canceler);
        }
        if (!result.isHealthy() && Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("Data scan of container " + this.containerID + " interrupted.");
        }
        return result;
    }

    private Container.ScanResult checkContainerFile(File containerFile) {
        Preconditions.checkState((this.onDiskContainerData != null ? 1 : 0) != 0, (Object)"Container File not loaded");
        try {
            ContainerUtils.verifyChecksum(this.onDiskContainerData, this.checkConfig);
        }
        catch (IOException ex) {
            return Container.ScanResult.unhealthy(Container.ScanResult.FailureType.CORRUPT_CONTAINER_FILE, containerFile, ex);
        }
        if (this.onDiskContainerData.getContainerType() != ContainerProtos.ContainerType.KeyValueContainer) {
            String errStr = "Bad Container type in Containerdata for " + this.containerID;
            return Container.ScanResult.unhealthy(Container.ScanResult.FailureType.CORRUPT_CONTAINER_FILE, containerFile, new IOException(errStr));
        }
        if (this.onDiskContainerData.getContainerID() != this.containerID) {
            String errStr = "Bad ContainerID field in Containerdata for " + this.containerID;
            return Container.ScanResult.unhealthy(Container.ScanResult.FailureType.CORRUPT_CONTAINER_FILE, containerFile, new IOException(errStr));
        }
        String dbType = this.onDiskContainerData.getContainerDBType();
        if (!dbType.equals("RocksDB")) {
            String errStr = "Unknown DBType [" + dbType + "] in Container File for  [" + this.containerID + "]";
            return Container.ScanResult.unhealthy(Container.ScanResult.FailureType.CORRUPT_CONTAINER_FILE, containerFile, new IOException(errStr));
        }
        KeyValueContainerData kvData = this.onDiskContainerData;
        if (!this.metadataPath.equals(kvData.getMetadataPath())) {
            String errStr = "Bad metadata path in Containerdata for " + this.containerID + "Expected [" + this.metadataPath + "] Got [" + kvData.getMetadataPath() + "]";
            return Container.ScanResult.unhealthy(Container.ScanResult.FailureType.CORRUPT_CONTAINER_FILE, containerFile, new IOException(errStr));
        }
        return Container.ScanResult.healthy();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Container.ScanResult scanData(DataTransferThrottler throttler, Canceler canceler) {
        Preconditions.checkState((this.onDiskContainerData != null ? 1 : 0) != 0, (Object)"invoke loadContainerData prior to calling this function");
        File dbFile = KeyValueContainerLocationUtil.getContainerDBFile(this.onDiskContainerData);
        if (!dbFile.exists() || !dbFile.canRead()) {
            String dbFileErrorMsg = "Unable to access DB File [" + dbFile.toString() + "] for Container [" + this.containerID + "] metadata path [" + this.metadataPath + "]";
            return Container.ScanResult.unhealthy(Container.ScanResult.FailureType.INACCESSIBLE_DB, dbFile, new IOException(dbFileErrorMsg));
        }
        this.onDiskContainerData.setDbFile(dbFile);
        try (DBHandle db = BlockUtils.getDB(this.onDiskContainerData, this.checkConfig);
             BlockIterator<BlockData> kvIter = db.getStore().getBlockIterator(this.onDiskContainerData.getContainerID(), this.onDiskContainerData.getUnprefixedKeyFilter());){
            while (kvIter.hasNext()) {
                BlockData block = kvIter.nextBlock();
                Container.ScanResult result = this.scanBlock(block, throttler, canceler);
                if (result.isHealthy()) continue;
                if (result.getFailureType() != Container.ScanResult.FailureType.MISSING_CHUNK_FILE) {
                    Container.ScanResult scanResult = result;
                    return scanResult;
                }
                if (this.getBlockDataFromDBWithLock(db, block) != null) {
                    Container.ScanResult scanResult = result;
                    return scanResult;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Scanned outdated blockData {} in container {}.", (Object)block, (Object)this.containerID);
            }
            return Container.ScanResult.healthy();
        }
        catch (IOException ex) {
            return Container.ScanResult.unhealthy(Container.ScanResult.FailureType.INACCESSIBLE_DB, dbFile, ex);
        }
    }

    private BlockData getBlockDataFromDB(DBHandle db, BlockData block) throws IOException {
        String blockKey = this.onDiskContainerData.getBlockKey(block.getBlockID().getLocalID());
        return (BlockData)db.getStore().getBlockDataTable().get((Object)blockKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockData getBlockDataFromDBWithLock(DBHandle db, BlockData block) throws IOException {
        this.container.readLock();
        try {
            BlockData blockData = this.getBlockDataFromDB(db, block);
            return blockData;
        }
        finally {
            this.container.readUnlock();
        }
    }

    private Container.ScanResult scanBlock(BlockData block, DataTransferThrottler throttler, Canceler canceler) {
        ContainerLayoutVersion layout = this.onDiskContainerData.getLayoutVersion();
        for (ContainerProtos.ChunkInfo chunk : block.getChunks()) {
            Container.ScanResult result;
            File chunkFile;
            try {
                chunkFile = layout.getChunkFile(this.onDiskContainerData, block.getBlockID(), ChunkInfo.getFromProtoBuf((ContainerProtos.ChunkInfo)chunk));
            }
            catch (IOException ex) {
                return Container.ScanResult.unhealthy(Container.ScanResult.FailureType.MISSING_CHUNK_FILE, new File(this.onDiskContainerData.getChunksPath()), ex);
            }
            if (!chunkFile.exists()) {
                if (block.getChunks().size() <= 0 || ((ContainerProtos.ChunkInfo)block.getChunks().get(0)).getLen() <= 0L) continue;
                return Container.ScanResult.unhealthy(Container.ScanResult.FailureType.MISSING_CHUNK_FILE, chunkFile, new IOException("Missing chunk file " + chunkFile.getAbsolutePath()));
            }
            if (chunk.getChecksumData().getType() == ContainerProtos.ChecksumType.NONE || (result = KeyValueContainerCheck.verifyChecksum(block, chunk, chunkFile, layout, throttler, canceler)).isHealthy()) continue;
            return result;
        }
        return Container.ScanResult.healthy();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Container.ScanResult verifyChecksum(BlockData block, ContainerProtos.ChunkInfo chunk, File chunkFile, ContainerLayoutVersion layout, DataTransferThrottler throttler, Canceler canceler) {
        ChecksumData checksumData = ChecksumData.getFromProtoBuf((ContainerProtos.ChecksumData)chunk.getChecksumData());
        int checksumCount = checksumData.getChecksums().size();
        int bytesPerChecksum = checksumData.getBytesPerChecksum();
        Checksum cal = new Checksum(checksumData.getChecksumType(), bytesPerChecksum);
        ByteBuffer buffer = ByteBuffer.allocate(bytesPerChecksum);
        long bytesRead = 0L;
        try (FileChannel channel = FileChannel.open(chunkFile.toPath(), ChunkUtils.READ_OPTIONS, ChunkUtils.NO_ATTRIBUTES);){
            int v;
            if (layout == ContainerLayoutVersion.FILE_PER_BLOCK) {
                channel.position(chunk.getOffset());
            }
            for (int i = 0; i < checksumCount; bytesRead += (long)v, ++i) {
                if (layout == ContainerLayoutVersion.FILE_PER_BLOCK && i == checksumCount - 1 && chunk.getLen() % (long)bytesPerChecksum != 0L) {
                    buffer.limit((int)(chunk.getLen() % (long)bytesPerChecksum));
                }
                if ((v = channel.read(buffer)) == -1) break;
                buffer.flip();
                throttler.throttle((long)v, canceler);
                ByteString expected = (ByteString)checksumData.getChecksums().get(i);
                ByteString actual = (ByteString)cal.computeChecksum(buffer).getChecksums().get(0);
                if (expected.equals((Object)actual)) continue;
                String message = String.format("Inconsistent read for chunk=%s checksum item %d expected checksum %s actual checksum %s for block %s", ChunkInfo.getFromProtoBuf((ContainerProtos.ChunkInfo)chunk), i, Arrays.toString(expected.toByteArray()), Arrays.toString(actual.toByteArray()), block.getBlockID());
                Container.ScanResult scanResult = Container.ScanResult.unhealthy(Container.ScanResult.FailureType.CORRUPT_CHUNK, chunkFile, new IOException(message));
                return scanResult;
            }
            if (bytesRead == chunk.getLen()) return Container.ScanResult.healthy();
            String message = String.format("Inconsistent read for chunk=%s expected length=%d actual length=%d for block %s", chunk.getChunkName(), chunk.getLen(), bytesRead, block.getBlockID());
            Container.ScanResult scanResult = Container.ScanResult.unhealthy(Container.ScanResult.FailureType.INCONSISTENT_CHUNK_LENGTH, chunkFile, new IOException(message));
            return scanResult;
        }
        catch (IOException ex) {
            return Container.ScanResult.unhealthy(Container.ScanResult.FailureType.MISSING_CHUNK_FILE, chunkFile, ex);
        }
    }

    private void loadContainerData(File containerFile) throws IOException {
        this.onDiskContainerData = (KeyValueContainerData)ContainerDataYaml.readContainerFile(containerFile);
        this.onDiskContainerData.setVolume(this.volume);
    }
}

