/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue.helpers;

import com.google.common.base.Preconditions;
import java.io.File;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;

public final class KeyValueContainerLocationUtil {
    private KeyValueContainerLocationUtil() {
    }

    public static File getContainerMetaDataPath(String hddsVolumeDir, String clusterId, long containerId) {
        return KeyValueContainerLocationUtil.getContainerMetaDataPath(KeyValueContainerLocationUtil.getBaseContainerLocation(hddsVolumeDir, clusterId, containerId));
    }

    public static File getContainerMetaDataPath(String containerBaseDir) {
        String containerMetaDataPath = containerBaseDir + File.separator + "metadata";
        return new File(containerMetaDataPath);
    }

    public static File getChunksLocationPath(String baseDir, String clusterId, long containerId) {
        return KeyValueContainerLocationUtil.getChunksLocationPath(KeyValueContainerLocationUtil.getBaseContainerLocation(baseDir, clusterId, containerId));
    }

    public static File getChunksLocationPath(String containerBaseDir) {
        String chunksPath = containerBaseDir + File.separator + "chunks";
        return new File(chunksPath);
    }

    public static String getBaseContainerLocation(String hddsVolumeDir, String clusterId, long containerId) {
        Preconditions.checkNotNull((Object)hddsVolumeDir, (Object)"Base Directory cannot be null");
        Preconditions.checkNotNull((Object)clusterId, (Object)"scmUuid cannot be null");
        Preconditions.checkState((containerId >= 0L ? 1 : 0) != 0, (Object)"Container Id cannot be negative.");
        String containerSubDirectory = KeyValueContainerLocationUtil.getContainerSubDirectory(containerId);
        String containerMetaDataPath = hddsVolumeDir + File.separator + clusterId + File.separator + "current" + File.separator + containerSubDirectory + File.separator + containerId;
        return containerMetaDataPath;
    }

    private static String getContainerSubDirectory(long containerId) {
        int directory = (int)(containerId >> 9 & 0xFFL);
        return "containerDir" + directory;
    }

    public static File getContainerDBFile(KeyValueContainerData containerData) {
        if (containerData.hasSchema("3")) {
            return new File(containerData.getVolume().getDbParentDir(), "container.db");
        }
        return KeyValueContainerLocationUtil.getContainerDBFile(containerData.getMetadataPath(), containerData);
    }

    public static File getContainerDBFile(String baseDir, KeyValueContainerData containerData) {
        return new File(baseDir, containerData.getContainerID() + "-dn-container.db");
    }
}

