/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue.statemachine.background;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.utils.BackgroundService;
import org.apache.hadoop.hdds.utils.BackgroundTask;
import org.apache.hadoop.hdds.utils.BackgroundTaskQueue;
import org.apache.hadoop.hdds.utils.BackgroundTaskResult;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaleRecoveringContainerScrubbingService
extends BackgroundService {
    private static final Logger LOG = LoggerFactory.getLogger(StaleRecoveringContainerScrubbingService.class);
    private final ContainerSet containerSet;

    public StaleRecoveringContainerScrubbingService(long interval, TimeUnit unit, int threadPoolSize, long serviceTimeout, ContainerSet containerSet) {
        super("StaleRecoveringContainerScrubbingService", interval, unit, threadPoolSize, serviceTimeout);
        this.containerSet = containerSet;
    }

    public BackgroundTaskQueue getTasks() {
        Map.Entry<Long, Long> entry;
        BackgroundTaskQueue backgroundTaskQueue = new BackgroundTaskQueue();
        long currentTime = this.containerSet.getCurrentTime();
        Iterator<Map.Entry<Long, Long>> it = this.containerSet.getRecoveringContainerIterator();
        while (it.hasNext() && currentTime >= (entry = it.next()).getKey()) {
            backgroundTaskQueue.add((BackgroundTask)new RecoveringContainerScrubbingTask(this.containerSet, entry.getValue()));
            it.remove();
        }
        return backgroundTaskQueue;
    }

    static class RecoveringContainerScrubbingTask
    implements BackgroundTask {
        private final ContainerSet containerSet;
        private final long containerID;

        RecoveringContainerScrubbingTask(ContainerSet containerSet, long containerID) {
            this.containerSet = containerSet;
            this.containerID = containerID;
        }

        public BackgroundTaskResult call() throws Exception {
            Container<?> con = this.containerSet.getContainer(this.containerID);
            if (null != con) {
                con.markContainerUnhealthy();
                LOG.info("Stale recovering container {} marked UNHEALTHY", (Object)this.containerID);
            }
            return new BackgroundTaskResult.EmptyTaskResult();
        }
    }
}

