/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.metadata;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.utils.CollectionUtils;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.DBColumnFamilyDefinition;
import org.apache.hadoop.hdds.utils.db.LongCodec;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.helpers.ChunkInfoList;
import org.apache.hadoop.ozone.container.metadata.AbstractDatanodeDBDefinition;
import org.apache.hadoop.ozone.container.metadata.SchemaOneChunkInfoListCodec;
import org.apache.hadoop.ozone.container.metadata.SchemaOneKeyCodec;
import org.rocksdb.RocksDB;

public class DatanodeSchemaOneDBDefinition
extends AbstractDatanodeDBDefinition {
    public static final DBColumnFamilyDefinition<String, BlockData> BLOCK_DATA = new DBColumnFamilyDefinition(StringUtils.bytes2String((byte[])RocksDB.DEFAULT_COLUMN_FAMILY), String.class, SchemaOneKeyCodec.get(), BlockData.class, BlockData.getCodec());
    public static final DBColumnFamilyDefinition<String, Long> METADATA = new DBColumnFamilyDefinition(StringUtils.bytes2String((byte[])RocksDB.DEFAULT_COLUMN_FAMILY), String.class, SchemaOneKeyCodec.get(), Long.class, (Codec)LongCodec.get());
    public static final DBColumnFamilyDefinition<String, ChunkInfoList> DELETED_BLOCKS = new DBColumnFamilyDefinition(StringUtils.bytes2String((byte[])RocksDB.DEFAULT_COLUMN_FAMILY), String.class, SchemaOneKeyCodec.get(), ChunkInfoList.class, SchemaOneChunkInfoListCodec.get());
    private static final Map<String, List<DBColumnFamilyDefinition<?, ?>>> COLUMN_FAMILIES = DBColumnFamilyDefinition.newUnmodifiableMultiMap((DBColumnFamilyDefinition[])new DBColumnFamilyDefinition[]{BLOCK_DATA, METADATA, DELETED_BLOCKS});

    public DatanodeSchemaOneDBDefinition(String dbPath, ConfigurationSource config) {
        super(dbPath, config);
    }

    @Override
    public DBColumnFamilyDefinition<String, BlockData> getBlockDataColumnFamily() {
        return BLOCK_DATA;
    }

    @Override
    public DBColumnFamilyDefinition<String, Long> getMetadataColumnFamily() {
        return METADATA;
    }

    @Override
    public DBColumnFamilyDefinition<String, ChunkInfoList> getDeletedBlocksColumnFamily() {
        return DELETED_BLOCKS;
    }

    public List<DBColumnFamilyDefinition<?, ?>> getColumnFamilies(String name) {
        return COLUMN_FAMILIES.get(name);
    }

    public Iterable<DBColumnFamilyDefinition<?, ?>> getColumnFamilies() {
        return () -> CollectionUtils.newIterator(COLUMN_FAMILIES.values());
    }
}

