/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.ozoneimpl;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.ozone.container.ozoneimpl.AbstractContainerScannerMetrics;

@InterfaceAudience.Private
@Metrics(about="DataNode container data scanner metrics", context="dfs")
public final class ContainerDataScannerMetrics
extends AbstractContainerScannerMetrics {
    @Metric(value={"disk bandwidth used by the container data scanner per volume"})
    private MutableRate numBytesScanned;

    public double getNumBytesScannedMean() {
        return this.numBytesScanned.lastStat().mean();
    }

    public long getNumBytesScannedSampleCount() {
        return this.numBytesScanned.lastStat().numSamples();
    }

    public double getNumBytesScannedStdDev() {
        return this.numBytesScanned.lastStat().stddev();
    }

    public void incNumBytesScanned(long bytes) {
        this.numBytesScanned.add(bytes);
    }

    private ContainerDataScannerMetrics(String name, MetricsSystem ms) {
        super(name, ms);
    }

    public static ContainerDataScannerMetrics create(String volumeName) {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        String name = "ContainerDataScannerMetrics-" + (volumeName.isEmpty() ? "UndefinedDataNodeVolume" + ThreadLocalRandom.current().nextInt() : volumeName.replace(':', '-'));
        return (ContainerDataScannerMetrics)ms.register(name, null, (Object)new ContainerDataScannerMetrics(name, ms));
    }
}

