/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.container.common.impl.ContainerDataYaml;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.interfaces.VolumeChoosingPolicy;
import org.apache.hadoop.ozone.container.common.utils.StorageVolumeUtil;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.MutableVolumeSet;
import org.apache.hadoop.ozone.container.common.volume.VolumeChoosingPolicyFactory;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.TarContainerPacker;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerController;
import org.apache.hadoop.ozone.container.replication.CopyContainerCompression;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerImporter {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerImporter.class);
    public static final String CONTAINER_COPY_DIR = "container-copy";
    private static final String CONTAINER_COPY_TMP_DIR = "tmp";
    private final ContainerSet containerSet;
    private final ContainerController controller;
    private final MutableVolumeSet volumeSet;
    private final VolumeChoosingPolicy volumeChoosingPolicy;
    private final long containerSize;
    private final Set<Long> importContainerProgress = Collections.synchronizedSet(new HashSet());

    public ContainerImporter(@NotNull ConfigurationSource conf, @NotNull ContainerSet containerSet, @NotNull ContainerController controller, @NotNull MutableVolumeSet volumeSet) {
        this.containerSet = containerSet;
        this.controller = controller;
        this.volumeSet = volumeSet;
        try {
            this.volumeChoosingPolicy = VolumeChoosingPolicyFactory.getPolicy(conf);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.containerSize = (long)conf.getStorageSize("ozone.scm.container.size", "5GB", StorageUnit.BYTES);
    }

    public boolean isAllowedContainerImport(long containerID) {
        return !this.importContainerProgress.contains(containerID) && this.containerSet.getContainer(containerID) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importContainer(long containerID, Path tarFilePath, HddsVolume hddsVolume, CopyContainerCompression compression) throws IOException {
        if (!this.importContainerProgress.add(containerID)) {
            ContainerImporter.deleteFileQuietely(tarFilePath);
            LOG.warn("Container import in progress with container Id {}", (Object)containerID);
            throw new StorageContainerException("Container import in progress with container Id " + containerID, ContainerProtos.Result.CONTAINER_EXISTS);
        }
        try {
            KeyValueContainerData containerData;
            if (this.containerSet.getContainer(containerID) != null) {
                LOG.warn("Container already exists with container Id {}", (Object)containerID);
                throw new StorageContainerException("Container already exists with container Id " + containerID, ContainerProtos.Result.CONTAINER_EXISTS);
            }
            HddsVolume targetVolume = hddsVolume;
            if (targetVolume == null) {
                targetVolume = this.chooseNextVolume();
            }
            TarContainerPacker packer = new TarContainerPacker(compression);
            try (FileInputStream input = new FileInputStream(tarFilePath.toFile());){
                byte[] containerDescriptorYaml = packer.unpackContainerDescriptor(input);
                containerData = (KeyValueContainerData)ContainerDataYaml.readContainer(containerDescriptorYaml);
            }
            containerData.setVolume(targetVolume);
            input = new FileInputStream(tarFilePath.toFile());
            var10_8 = null;
            try {
                Container container = this.controller.importContainer(containerData, input, packer);
                this.containerSet.addContainer(container);
            }
            catch (Throwable throwable) {
                var10_8 = throwable;
                throw throwable;
            }
            finally {
                if (input != null) {
                    if (var10_8 != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable) {
                            var10_8.addSuppressed(throwable);
                        }
                    } else {
                        input.close();
                    }
                }
            }
        }
        finally {
            this.importContainerProgress.remove(containerID);
            ContainerImporter.deleteFileQuietely(tarFilePath);
        }
    }

    private static void deleteFileQuietely(Path tarFilePath) {
        try {
            Files.delete(tarFilePath);
        }
        catch (Exception ex) {
            LOG.error("Got exception while deleting temporary container file: " + tarFilePath.toAbsolutePath(), (Throwable)ex);
        }
    }

    HddsVolume chooseNextVolume() throws IOException {
        return this.volumeChoosingPolicy.chooseVolume(StorageVolumeUtil.getHddsVolumesList(this.volumeSet.getVolumesList()), this.containerSize * 2L);
    }

    public static Path getUntarDirectory(HddsVolume hddsVolume) throws IOException {
        return Paths.get(hddsVolume.getVolumeRootDir(), new String[0]).resolve(CONTAINER_COPY_TMP_DIR).resolve(CONTAINER_COPY_DIR);
    }
}

