/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import com.lmax.disruptor.BlockingWaitStrategy;
import org.apache.commons.pool2.ObjectPool;
import org.apache.omid.metrics.MetricsRegistry;
import org.apache.omid.metrics.NullMetricsProvider;
import org.apache.omid.tso.Batch;
import org.apache.omid.tso.BatchPoolModule;
import org.apache.omid.tso.LowWatermarkWriter;
import org.apache.omid.tso.MonitoringContext;
import org.apache.omid.tso.MonitoringContextImpl;
import org.apache.omid.tso.Panicker;
import org.apache.omid.tso.ReplyProcessorImpl;
import org.apache.omid.tso.RuntimeExceptionPanicker;
import org.apache.omid.tso.TSOServerConfig;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.SettableFuture;
import org.jboss.netty.channel.Channel;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestReplyProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(TestReplyProcessor.class);
    private static final long ANY_DISRUPTOR_SEQUENCE = 1234L;
    public static final int BATCH_POOL_SIZE = 3;
    private static final long FIRST_ST = 0L;
    private static final long FIRST_CT = 1L;
    private static final long SECOND_ST = 2L;
    private static final long SECOND_CT = 3L;
    private static final long THIRD_ST = 4L;
    private static final long THIRD_CT = 5L;
    private static final long FOURTH_ST = 6L;
    private static final long FOURTH_CT = 7L;
    private static final long FIFTH_ST = 8L;
    private static final long FIFTH_CT = 9L;
    private static final long SIXTH_ST = 10L;
    private static final long SIXTH_CT = 11L;
    @Mock
    private Panicker panicker;
    @Mock
    private MonitoringContextImpl monCtx;
    private MetricsRegistry metrics;
    private ObjectPool<Batch> batchPool;
    private ReplyProcessorImpl replyProcessor;
    private LowWatermarkWriter lowWatermarkWriter;

    @BeforeMethod(alwaysRun=true, timeOut=30000L)
    public void initMocksAndComponents() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        TSOServerConfig tsoConfig = new TSOServerConfig();
        tsoConfig.setNumConcurrentCTWriters(3);
        this.metrics = new NullMetricsProvider();
        this.batchPool = (ObjectPool)Mockito.spy(new BatchPoolModule(tsoConfig).getBatchPool());
        this.lowWatermarkWriter = (LowWatermarkWriter)Mockito.mock(LowWatermarkWriter.class);
        SettableFuture f = SettableFuture.create();
        f.set(null);
        ((LowWatermarkWriter)Mockito.doReturn((Object)f).when((Object)this.lowWatermarkWriter)).persistLowWatermark((Long)Matchers.any(Long.class));
        this.replyProcessor = (ReplyProcessorImpl)Mockito.spy((Object)new ReplyProcessorImpl(new BlockingWaitStrategy(), this.metrics, this.panicker, this.batchPool, this.lowWatermarkWriter));
    }

    @AfterMethod
    void afterMethod() {
    }

    @Test(timeOut=10000L)
    public void testBadFormedPackageThrowsException() throws Exception {
        this.replyProcessor = (ReplyProcessorImpl)Mockito.spy((Object)new ReplyProcessorImpl(new BlockingWaitStrategy(), this.metrics, new RuntimeExceptionPanicker(), this.batchPool, this.lowWatermarkWriter));
        Batch batch = (Batch)this.batchPool.borrowObject();
        batch.addCommitRetry(0L, null, this.monCtx);
        ReplyProcessorImpl.ReplyBatchEvent e = ReplyProcessorImpl.ReplyBatchEvent.EVENT_FACTORY.newInstance();
        ReplyProcessorImpl.ReplyBatchEvent.makeReplyBatch(e, batch, 0L);
        Assert.assertEquals((long)this.replyProcessor.nextIDToHandle.get(), (long)0L);
        Assert.assertEquals((int)this.replyProcessor.futureEvents.size(), (int)0);
        Assert.assertEquals((int)this.batchPool.getNumActive(), (int)1);
        Assert.assertEquals((int)this.batchPool.getNumIdle(), (int)2);
        try {
            this.replyProcessor.onEvent(e, 1234L, false);
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((long)this.replyProcessor.nextIDToHandle.get(), (long)0L);
        Assert.assertEquals((int)this.replyProcessor.futureEvents.size(), (int)0);
        Assert.assertEquals((int)this.batchPool.getNumActive(), (int)1);
        Assert.assertEquals((int)this.batchPool.getNumIdle(), (int)2);
    }

    @Test(timeOut=10000L)
    public void testUnorderedBatchSequenceGetsSaved() throws Exception {
        long HIGH_SEQUENCE_NUMBER = 1234L;
        Batch batch = (Batch)this.batchPool.borrowObject();
        ReplyProcessorImpl.ReplyBatchEvent e = ReplyProcessorImpl.ReplyBatchEvent.EVENT_FACTORY.newInstance();
        ReplyProcessorImpl.ReplyBatchEvent.makeReplyBatch(e, batch, 1234L);
        Assert.assertEquals((long)this.replyProcessor.nextIDToHandle.get(), (long)0L);
        Assert.assertEquals((int)this.replyProcessor.futureEvents.size(), (int)0);
        Assert.assertEquals((int)this.batchPool.getNumActive(), (int)1);
        Assert.assertEquals((int)this.batchPool.getNumIdle(), (int)2);
        this.replyProcessor.onEvent(e, 1234L, false);
        Assert.assertEquals((long)this.replyProcessor.nextIDToHandle.get(), (long)0L);
        Assert.assertEquals((int)this.replyProcessor.futureEvents.size(), (int)1);
        Assert.assertEquals((int)this.batchPool.getNumActive(), (int)1);
        Assert.assertEquals((int)this.batchPool.getNumIdle(), (int)2);
        Assert.assertTrue((boolean)batch.isEmpty());
        ((ReplyProcessorImpl)Mockito.verify((Object)this.replyProcessor, (VerificationMode)Mockito.times((int)0))).handleReplyBatchEvent((ReplyProcessorImpl.ReplyBatchEvent)Matchers.any(ReplyProcessorImpl.ReplyBatchEvent.class));
    }

    @Test(timeOut=10000L)
    public void testProcessingOfEmptyBatchReplyEvent() throws Exception {
        Batch batch = (Batch)this.batchPool.borrowObject();
        ReplyProcessorImpl.ReplyBatchEvent e = ReplyProcessorImpl.ReplyBatchEvent.EVENT_FACTORY.newInstance();
        ReplyProcessorImpl.ReplyBatchEvent.makeReplyBatch(e, batch, 0L);
        Assert.assertEquals((long)this.replyProcessor.nextIDToHandle.get(), (long)0L);
        Assert.assertEquals((int)this.replyProcessor.futureEvents.size(), (int)0);
        Assert.assertEquals((int)this.batchPool.getNumActive(), (int)1);
        Assert.assertEquals((int)this.batchPool.getNumIdle(), (int)2);
        this.replyProcessor.onEvent(e, 1234L, false);
        Assert.assertEquals((long)this.replyProcessor.nextIDToHandle.get(), (long)1L);
        Assert.assertEquals((int)this.replyProcessor.futureEvents.size(), (int)0);
        Assert.assertEquals((int)this.batchPool.getNumActive(), (int)0);
        Assert.assertEquals((int)this.batchPool.getNumIdle(), (int)3);
        Assert.assertTrue((boolean)batch.isEmpty());
        ((ReplyProcessorImpl)Mockito.verify((Object)this.replyProcessor, (VerificationMode)Mockito.times((int)1))).handleReplyBatchEvent((ReplyProcessorImpl.ReplyBatchEvent)Matchers.eq((Object)e));
    }

    @Test(timeOut=10000L)
    public void testUnorderedSequenceOfBatchReplyEventsThatMustBeOrderedBeforeSendingReplies() throws Exception {
        Batch thirdBatch = (Batch)this.batchPool.borrowObject();
        thirdBatch.addTimestamp(0L, (Channel)Mockito.mock(Channel.class), this.monCtx);
        thirdBatch.addCommit(2L, 3L, (Channel)Mockito.mock(Channel.class), this.monCtx, (Optional<Long>)Optional.absent());
        ReplyProcessorImpl.ReplyBatchEvent thirdBatchEvent = ReplyProcessorImpl.ReplyBatchEvent.EVENT_FACTORY.newInstance();
        ReplyProcessorImpl.ReplyBatchEvent.makeReplyBatch(thirdBatchEvent, thirdBatch, 2L);
        Assert.assertEquals((long)this.replyProcessor.nextIDToHandle.get(), (long)0L);
        Assert.assertEquals((int)this.replyProcessor.futureEvents.size(), (int)0);
        Assert.assertEquals((int)this.batchPool.getNumActive(), (int)1);
        Assert.assertEquals((int)this.batchPool.getNumIdle(), (int)2);
        this.replyProcessor.onEvent(thirdBatchEvent, 1234L, false);
        Assert.assertEquals((long)this.replyProcessor.nextIDToHandle.get(), (long)0L);
        Assert.assertEquals((int)this.replyProcessor.futureEvents.size(), (int)1);
        Assert.assertEquals((int)this.batchPool.getNumActive(), (int)1);
        Assert.assertEquals((int)this.batchPool.getNumIdle(), (int)2);
        Assert.assertFalse((boolean)thirdBatch.isEmpty());
        ((ReplyProcessorImpl)Mockito.verify((Object)this.replyProcessor, (VerificationMode)Mockito.never())).handleReplyBatchEvent((ReplyProcessorImpl.ReplyBatchEvent)Matchers.eq((Object)thirdBatchEvent));
        Batch secondBatch = (Batch)this.batchPool.borrowObject();
        secondBatch.addTimestamp(4L, (Channel)Mockito.mock(Channel.class), this.monCtx);
        secondBatch.addCommit(6L, 7L, (Channel)Mockito.mock(Channel.class), this.monCtx, (Optional<Long>)Optional.absent());
        ReplyProcessorImpl.ReplyBatchEvent secondBatchEvent = ReplyProcessorImpl.ReplyBatchEvent.EVENT_FACTORY.newInstance();
        ReplyProcessorImpl.ReplyBatchEvent.makeReplyBatch(secondBatchEvent, secondBatch, 1L);
        this.replyProcessor.onEvent(secondBatchEvent, 1234L, false);
        Assert.assertEquals((long)this.replyProcessor.nextIDToHandle.get(), (long)0L);
        Assert.assertEquals((int)this.replyProcessor.futureEvents.size(), (int)2);
        Assert.assertEquals((int)this.batchPool.getNumActive(), (int)2);
        Assert.assertEquals((int)this.batchPool.getNumIdle(), (int)1);
        Assert.assertFalse((boolean)secondBatch.isEmpty());
        Assert.assertFalse((boolean)thirdBatch.isEmpty());
        Batch firstBatch = (Batch)this.batchPool.borrowObject();
        firstBatch.addAbort(8L, (Channel)Mockito.mock(Channel.class), this.monCtx);
        ReplyProcessorImpl.ReplyBatchEvent firstBatchEvent = ReplyProcessorImpl.ReplyBatchEvent.EVENT_FACTORY.newInstance();
        ReplyProcessorImpl.ReplyBatchEvent.makeReplyBatch(firstBatchEvent, firstBatch, 0L);
        this.replyProcessor.onEvent(firstBatchEvent, 1234L, false);
        Assert.assertEquals((long)this.replyProcessor.nextIDToHandle.get(), (long)3L);
        Assert.assertEquals((int)this.replyProcessor.futureEvents.size(), (int)0);
        Assert.assertEquals((int)this.batchPool.getNumActive(), (int)0);
        Assert.assertEquals((int)this.batchPool.getNumIdle(), (int)3);
        Assert.assertTrue((boolean)firstBatch.isEmpty());
        Assert.assertTrue((boolean)secondBatch.isEmpty());
        Assert.assertTrue((boolean)thirdBatch.isEmpty());
        InOrder inOrderReplyBatchEvents = Mockito.inOrder((Object[])new Object[]{this.replyProcessor, this.replyProcessor, this.replyProcessor});
        ((ReplyProcessorImpl)inOrderReplyBatchEvents.verify((Object)this.replyProcessor, Mockito.times((int)1))).handleReplyBatchEvent((ReplyProcessorImpl.ReplyBatchEvent)Matchers.eq((Object)firstBatchEvent));
        ((ReplyProcessorImpl)inOrderReplyBatchEvents.verify((Object)this.replyProcessor, Mockito.times((int)1))).handleReplyBatchEvent((ReplyProcessorImpl.ReplyBatchEvent)Matchers.eq((Object)secondBatchEvent));
        ((ReplyProcessorImpl)inOrderReplyBatchEvents.verify((Object)this.replyProcessor, Mockito.times((int)1))).handleReplyBatchEvent((ReplyProcessorImpl.ReplyBatchEvent)Matchers.eq((Object)thirdBatchEvent));
        InOrder inOrderReplies = Mockito.inOrder((Object[])new Object[]{this.replyProcessor, this.replyProcessor, this.replyProcessor, this.replyProcessor, this.replyProcessor});
        ((ReplyProcessorImpl)inOrderReplies.verify((Object)this.replyProcessor, Mockito.times((int)1))).sendAbortResponse(Matchers.eq((long)8L), (Channel)Matchers.any(Channel.class), (MonitoringContext)Matchers.eq((Object)this.monCtx));
        ((ReplyProcessorImpl)inOrderReplies.verify((Object)this.replyProcessor, Mockito.times((int)1))).sendTimestampResponse(Matchers.eq((long)4L), (Channel)Matchers.any(Channel.class), (MonitoringContext)Matchers.eq((Object)this.monCtx));
        ((ReplyProcessorImpl)inOrderReplies.verify((Object)this.replyProcessor, Mockito.times((int)1))).sendCommitResponse(Matchers.eq((long)6L), Matchers.eq((long)7L), (Channel)Matchers.any(Channel.class), (MonitoringContext)Matchers.eq((Object)this.monCtx), (Optional<Long>)((Optional)Matchers.any(Optional.class)));
        ((ReplyProcessorImpl)inOrderReplies.verify((Object)this.replyProcessor, Mockito.times((int)1))).sendTimestampResponse(Matchers.eq((long)0L), (Channel)Matchers.any(Channel.class), (MonitoringContext)Matchers.eq((Object)this.monCtx));
        ((ReplyProcessorImpl)inOrderReplies.verify((Object)this.replyProcessor, Mockito.times((int)1))).sendCommitResponse(Matchers.eq((long)2L), Matchers.eq((long)3L), (Channel)Matchers.any(Channel.class), (MonitoringContext)Matchers.eq((Object)this.monCtx), (Optional<Long>)((Optional)Matchers.any(Optional.class)));
    }

    @Test
    public void testUpdateLowWaterMarkOnlyForMaxInBatch() throws Exception {
        Batch thirdBatch = (Batch)this.batchPool.borrowObject();
        thirdBatch.addTimestamp(0L, (Channel)Mockito.mock(Channel.class), this.monCtx);
        thirdBatch.addCommit(2L, 3L, (Channel)Mockito.mock(Channel.class), this.monCtx, (Optional<Long>)Optional.of((Object)100L));
        thirdBatch.addCommit(4L, 5L, (Channel)Mockito.mock(Channel.class), this.monCtx, (Optional<Long>)Optional.of((Object)50L));
        thirdBatch.addCommit(6L, 7L, (Channel)Mockito.mock(Channel.class), this.monCtx, (Optional<Long>)Optional.absent());
        thirdBatch.addCommit(8L, 9L, (Channel)Mockito.mock(Channel.class), this.monCtx, (Optional<Long>)Optional.of((Object)100L));
        thirdBatch.addCommit(10L, 11L, (Channel)Mockito.mock(Channel.class), this.monCtx, (Optional<Long>)Optional.of((Object)150L));
        ReplyProcessorImpl.ReplyBatchEvent thirdBatchEvent = ReplyProcessorImpl.ReplyBatchEvent.EVENT_FACTORY.newInstance();
        ReplyProcessorImpl.ReplyBatchEvent.makeReplyBatch(thirdBatchEvent, thirdBatch, 0L);
        this.replyProcessor.onEvent(thirdBatchEvent, 1234L, false);
        InOrder inOrderWatermarkWriter = Mockito.inOrder((Object[])new Object[]{this.lowWatermarkWriter, this.lowWatermarkWriter, this.lowWatermarkWriter});
        ((LowWatermarkWriter)inOrderWatermarkWriter.verify((Object)this.lowWatermarkWriter, Mockito.times((int)1))).persistLowWatermark(Matchers.eq((long)100L));
        ((LowWatermarkWriter)inOrderWatermarkWriter.verify((Object)this.lowWatermarkWriter, Mockito.times((int)1))).persistLowWatermark(Matchers.eq((long)150L));
        ((LowWatermarkWriter)Mockito.verify((Object)this.lowWatermarkWriter, (VerificationMode)Mockito.timeout((int)100).never())).persistLowWatermark(Matchers.eq((long)50L));
        InOrder inOrderCheckLWM = Mockito.inOrder((Object[])new Object[]{this.replyProcessor, this.replyProcessor, this.replyProcessor, this.replyProcessor, this.replyProcessor});
        ((ReplyProcessorImpl)inOrderCheckLWM.verify((Object)this.replyProcessor, Mockito.times((int)1))).updateLowWatermark((Optional<Long>)Optional.of((Object)100L));
        ((ReplyProcessorImpl)inOrderCheckLWM.verify((Object)this.replyProcessor, Mockito.times((int)1))).updateLowWatermark((Optional<Long>)Optional.of((Object)50L));
        ((ReplyProcessorImpl)inOrderCheckLWM.verify((Object)this.replyProcessor, Mockito.times((int)1))).updateLowWatermark((Optional<Long>)Optional.absent());
        ((ReplyProcessorImpl)inOrderCheckLWM.verify((Object)this.replyProcessor, Mockito.times((int)1))).updateLowWatermark((Optional<Long>)Optional.of((Object)100L));
        ((ReplyProcessorImpl)inOrderCheckLWM.verify((Object)this.replyProcessor, Mockito.times((int)1))).updateLowWatermark((Optional<Long>)Optional.of((Object)150L));
    }
}

