/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.io.IOException;
import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.Queue;
import org.apache.phoenix.iterate.SizeAwareQueue;

public abstract class SizeBoundQueue<T>
extends AbstractQueue<T>
implements SizeAwareQueue<T> {
    private long maxSizeBytes;
    private Queue<T> delegate;
    private long currentSize;

    public SizeBoundQueue(long maxSizeBytes, Queue<T> delegate) {
        assert (maxSizeBytes > 0L);
        this.maxSizeBytes = maxSizeBytes;
        this.delegate = delegate;
    }

    public abstract long sizeOf(T var1);

    @Override
    public boolean offer(T e) {
        boolean success = false;
        long elementSize = this.sizeOf(e);
        if (this.currentSize + elementSize < this.maxSizeBytes && (success = this.delegate.offer(e))) {
            this.currentSize += elementSize;
        }
        return success;
    }

    @Override
    public boolean add(T e) {
        try {
            return super.add(e);
        }
        catch (IllegalStateException ex) {
            throw new IllegalStateException("Queue full. Consider increasing memory threshold or spooling to disk. Max size: " + this.maxSizeBytes + ", Current size: " + this.currentSize + ", Number of elements:" + this.size(), ex);
        }
    }

    @Override
    public T poll() {
        T e = this.delegate.poll();
        if (e != null) {
            this.currentSize -= this.sizeOf(e);
        }
        return e;
    }

    @Override
    public T peek() {
        return this.delegate.peek();
    }

    @Override
    public void close() throws IOException {
        this.delegate.clear();
    }

    @Override
    public long getByteSize() {
        return this.currentSize;
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }
}

