/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.optimize.Cost;
import org.apache.phoenix.query.QueryServices;

public class CostUtil {
    public static Cost estimateAggregateCost(double inputBytes, double outputBytes, GroupByCompiler.GroupBy groupBy, int parallelLevel) {
        double hashMapOverhead = groupBy.isOrderPreserving() || groupBy.isUngroupedAggregate() ? 1.0 : (outputBytes < 1.0 ? 1.0 : outputBytes);
        return new Cost(0.0, 0.0, (outputBytes + hashMapOverhead * Math.log(inputBytes)) / (double)parallelLevel);
    }

    public static Cost estimateOrderByCost(double inputBytes, double outputBytes, int parallelLevel) {
        if (inputBytes < 1.0) {
            inputBytes = 1.0;
        }
        return new Cost(0.0, 0.0, (outputBytes + outputBytes * Math.log(inputBytes)) / (double)parallelLevel);
    }

    public static Cost estimateHashJoinCost(double lhsBytes, double rhsBytes, double outputBytes, boolean hasKeyRangeExpression, int parallelLevel) {
        if (rhsBytes < 1.0) {
            rhsBytes = 1.0;
        }
        return new Cost(0.0, 0.0, (rhsBytes * Math.log(rhsBytes) + (hasKeyRangeExpression ? 0.0 : lhsBytes)) / (double)parallelLevel + outputBytes);
    }

    public static int estimateParallelLevel(boolean runningOnServer, QueryServices services) {
        return runningOnServer ? 10 : 1;
    }
}

