/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.util.SchemaUtil;

public class PhoenixMultiInputUtil {
    public static final String SELECT_ALL_VIEW_METADATA_FROM_SYSCAT_QUERY = "SELECT TENANT_ID, TABLE_SCHEM, TABLE_NAME, PHOENIX_TTL FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " WHERE " + "TABLE_TYPE" + " = '" + PTableType.VIEW.getSerializedValue() + "' AND " + "PHOENIX_TTL" + " IS NOT NULL AND " + "PHOENIX_TTL" + " > " + 0L + " AND " + "VIEW_TYPE" + " <> " + PTable.ViewType.MAPPED.getSerializedValue();

    public static Connection buildTenantConnection(String url, String tenantId) throws SQLException {
        Properties props = new Properties();
        props.setProperty("TenantId", tenantId);
        return DriverManager.getConnection(url, props);
    }

    public static String getSelectAllPageQuery() {
        return SELECT_ALL_VIEW_METADATA_FROM_SYSCAT_QUERY + " AND (TENANT_ID,TABLE_SCHEM,TABLE_NAME) > (?,?,?) LIMIT ?";
    }

    public static String constructViewMetadataQueryBasedOnView(String fullName, String tenantId) {
        String query = SELECT_ALL_VIEW_METADATA_FROM_SYSCAT_QUERY;
        if (fullName != null) {
            if (fullName.equals("DELETE_ALL_VIEWS")) {
                return query;
            }
            String schema = SchemaUtil.getSchemaNameFromFullName(fullName);
            String viewName = SchemaUtil.getTableNameFromFullName(fullName);
            query = !schema.equals("") ? query + " AND TABLE_SCHEM = '" + schema + "'" : query + " AND TABLE_SCHEM IS NULL";
            query = query + " AND TABLE_NAME = '" + viewName + "'";
        }
        query = tenantId != null && tenantId.length() > 0 ? query + " AND TENANT_ID = '" + tenantId + "'" : query + " AND TENANT_ID IS NULL";
        return query;
    }

    public static String constructViewMetadataQueryBasedOnTenant(String tenant) {
        return PhoenixMultiInputUtil.constructViewMetadataQueryBasedOnView(null, tenant);
    }

    public static String getFetchViewQuery(Configuration configuration) {
        String query = configuration.get("phoenix.mapreduce.phoenix_ttl.all") != null ? PhoenixMultiInputUtil.getSelectAllPageQuery() : (configuration.get("phoenix.mapreduce.tenantid") != null && configuration.get("phoenix.mapreduce.phoenix_ttl.per_view") == null ? PhoenixMultiInputUtil.constructViewMetadataQueryBasedOnTenant(configuration.get("phoenix.mapreduce.tenantid")) : PhoenixMultiInputUtil.constructViewMetadataQueryBasedOnView(configuration.get("phoenix.mapreduce.phoenix_ttl.per_view"), configuration.get("phoenix.mapreduce.tenantid")));
        return query;
    }
}

