/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.persist;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Method;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDFSUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HDFSUtil.class);

    public void recoverFileLease(FileSystem fs, Path p, Configuration conf) throws IOException {
        if (!(fs instanceof DistributedFileSystem)) {
            return;
        }
        this.recoverDFSFileLease((DistributedFileSystem)fs, p, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean recoverDFSFileLease(DistributedFileSystem dfs, Path p, Configuration conf) throws IOException {
        LOG.info("Recovering lease on dfs file " + p);
        long startWaiting = System.currentTimeMillis();
        long recoveryTimeout = (long)conf.getInt("hbase.lease.recovery.timeout", 900000) + startWaiting;
        long firstPause = conf.getInt("hbase.lease.recovery.first.pause", 3000);
        long subsequentPause = conf.getInt("hbase.lease.recovery.dfs.timeout", 61000);
        Method isFileClosedMeth = null;
        boolean findIsFileClosedMeth = true;
        boolean recovered = false;
        int nbAttempt = 0;
        while (!(recovered || (recovered = this.recoverLease(dfs, nbAttempt, p, startWaiting)) || this.checkIfTimedout(conf, recoveryTimeout, nbAttempt, p, startWaiting))) {
            block11: {
                try {
                    if (nbAttempt == 0) {
                        Thread.sleep(firstPause);
                        break block11;
                    }
                    long localStartWaiting = System.currentTimeMillis();
                    while (System.currentTimeMillis() - localStartWaiting < subsequentPause) {
                        Thread.sleep(conf.getInt("hbase.lease.recovery.pause", 1000));
                        if (findIsFileClosedMeth) {
                            try {
                                isFileClosedMeth = dfs.getClass().getMethod("isFileClosed", Path.class);
                            }
                            catch (NoSuchMethodException nsme) {
                                LOG.debug("isFileClosed not available");
                            }
                            finally {
                                findIsFileClosedMeth = false;
                            }
                        }
                        if (isFileClosedMeth == null || !this.isFileClosed(dfs, isFileClosedMeth, p)) continue;
                        recovered = true;
                        break;
                    }
                }
                catch (InterruptedException ie) {
                    InterruptedIOException iioe = new InterruptedIOException();
                    iioe.initCause(ie);
                    throw iioe;
                }
            }
            ++nbAttempt;
        }
        return recovered;
    }

    boolean checkIfTimedout(Configuration conf, long recoveryTimeout, int nbAttempt, Path p, long startWaiting) {
        if (recoveryTimeout < System.currentTimeMillis()) {
            LOG.warn("Cannot recoverLease after trying for " + conf.getInt("hbase.lease.recovery.timeout", 900000) + "ms (hbase.lease.recovery.timeout); continuing, but may be DATALOSS!!!; " + this.getLogMessageDetail(nbAttempt, p, startWaiting));
            return true;
        }
        return false;
    }

    boolean recoverLease(DistributedFileSystem dfs, int nbAttempt, Path p, long startWaiting) throws FileNotFoundException {
        boolean recovered = false;
        try {
            recovered = dfs.recoverLease(p);
            LOG.info("recoverLease=" + recovered + ", " + this.getLogMessageDetail(nbAttempt, p, startWaiting));
        }
        catch (IOException e) {
            if (e instanceof LeaseExpiredException && e.getMessage().contains("File does not exist")) {
                throw new FileNotFoundException("The given file wasn't found at " + p);
            }
            if (e instanceof FileNotFoundException) {
                throw (FileNotFoundException)e;
            }
            LOG.warn(this.getLogMessageDetail(nbAttempt, p, startWaiting), (Throwable)e);
        }
        return recovered;
    }

    private String getLogMessageDetail(int nbAttempt, Path p, long startWaiting) {
        return "attempt=" + nbAttempt + " on file=" + p + " after " + (System.currentTimeMillis() - startWaiting) + "ms";
    }

    private boolean isFileClosed(DistributedFileSystem dfs, Method m, Path p) {
        try {
            return (Boolean)m.invoke((Object)dfs, p);
        }
        catch (SecurityException e) {
            LOG.warn("No access", (Throwable)e);
        }
        catch (Exception e) {
            LOG.warn("Failed invocation for " + p.toString(), (Throwable)e);
        }
        return false;
    }
}

